/*
 * Decompiled with CFR 0.152.
 */
package cn.trythis.ams.bootconfig;

import cn.trythis.ams.bootconfig.EnableAmsBatchProcessing;
import cn.trythis.ams.bootconfig.ScopeConfiguration;
import cn.trythis.ams.util.AmsAssert;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.AbstractLazyCreationTargetSource;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.batch.core.configuration.annotation.DefaultBatchConfigurer;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.support.MapJobRegistry;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

@Configuration
@Import(value={ScopeConfiguration.class})
public class AmsSimpleBatchConfiguration
implements ImportAware {
    @Autowired
    private DataSource dataSource;
    private BatchConfigurer configurer;
    @Autowired
    private PlatformTransactionManager platformTransactionManager;
    @Autowired
    private ApplicationContext context;
    private boolean initialized = false;
    private AtomicReference<JobRepository> jobRepository = new AtomicReference();
    private AtomicReference<JobLauncher> jobLauncher = new AtomicReference();
    private AtomicReference<JobRegistry> jobRegistry = new AtomicReference();
    private AtomicReference<PlatformTransactionManager> transactionManager = new AtomicReference();
    private AtomicReference<JobExplorer> jobExplorer = new AtomicReference();

    @Bean
    public JobBuilderFactory jobBuilders() throws Exception {
        return new JobBuilderFactory(this.jobRepository());
    }

    @Bean
    public StepBuilderFactory stepBuilders() throws Exception {
        return new StepBuilderFactory(this.jobRepository(), this.platformTransactionManager);
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        AnnotationAttributes enabled = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableAmsBatchProcessing.class.getName(), false));
        Assert.notNull((Object)enabled, (String)("@EnableAmsBatchProcessing is not present on importing class " + importMetadata.getClassName()));
    }

    protected BatchConfigurer getConfigurer(Collection<BatchConfigurer> configurers) throws Exception {
        if (this.configurer != null) {
            return this.configurer;
        }
        if (configurers == null || configurers.isEmpty()) {
            if (this.dataSource == null) {
                AmsAssert.fail((String)"\u6570\u636e\u6e90[dataSource]\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                DefaultBatchConfigurer configurer = new DefaultBatchConfigurer(this.dataSource);
                configurer.initialize();
                this.configurer = configurer;
                return configurer;
            }
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException("To use a custom BatchConfigurer the context must contain precisely one, found " + configurers.size());
        }
        this.configurer = configurers.iterator().next();
        return this.configurer;
    }

    @Bean
    public JobRepository jobRepository() throws Exception {
        return this.createLazyProxy(this.jobRepository, JobRepository.class);
    }

    @Bean
    public JobLauncher jobLauncher() throws Exception {
        return this.createLazyProxy(this.jobLauncher, JobLauncher.class);
    }

    @Bean
    public JobRegistry jobRegistry() throws Exception {
        return this.createLazyProxy(this.jobRegistry, JobRegistry.class);
    }

    @Bean
    public JobExplorer jobExplorer() {
        return this.createLazyProxy(this.jobExplorer, JobExplorer.class);
    }

    private <T> T createLazyProxy(AtomicReference<T> reference, Class<T> type) {
        ProxyFactory factory = new ProxyFactory();
        factory.setTargetSource(new ReferenceTargetSource<T>(reference));
        factory.addAdvice((Advice)new PassthruAdvice());
        factory.setInterfaces(new Class[]{type});
        Object proxy = factory.getProxy();
        return (T)proxy;
    }

    protected void initialize() throws Exception {
        if (this.initialized) {
            return;
        }
        BatchConfigurer configurer = this.getConfigurer(this.context.getBeansOfType(BatchConfigurer.class).values());
        this.jobRepository.set(configurer.getJobRepository());
        this.jobLauncher.set(configurer.getJobLauncher());
        this.transactionManager.set(configurer.getTransactionManager());
        this.jobRegistry.set((JobRegistry)new MapJobRegistry());
        this.jobExplorer.set(configurer.getJobExplorer());
        this.initialized = true;
    }

    private class ReferenceTargetSource<T>
    extends AbstractLazyCreationTargetSource {
        private AtomicReference<T> reference;

        public ReferenceTargetSource(AtomicReference<T> reference) {
            this.reference = reference;
        }

        protected Object createObject() throws Exception {
            AmsSimpleBatchConfiguration.this.initialize();
            return this.reference.get();
        }
    }

    private class PassthruAdvice
    implements MethodInterceptor {
        private PassthruAdvice() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            return invocation.proceed();
        }
    }
}

