/*
 * Decompiled with CFR 0.152.
 */
package cn.trythis.ams.application;

import cn.trythis.ams.factory.domain.AppContext;
import cn.trythis.ams.pojo.dto.BatchJobLogDTO;
import cn.trythis.ams.repository.dao.mapper.BatchMonitorMapper;
import cn.trythis.ams.support.annotation.Interaction;
import cn.trythis.ams.support.annotation.Trader;
import cn.trythis.ams.support.exception.ExceptionUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;

@Interaction(groupName="BatchMonitor")
public class BatchMonitorManager {
    private static final Logger logger = LoggerFactory.getLogger(BatchMonitorManager.class);
    @Autowired
    private JobLauncher jobLauncher;
    @Autowired
    private JobOperator jobOperator;
    @Autowired
    private BatchMonitorMapper batchMonitorMapper;

    @Trader(tradeCode="BM1001", tradeName="\u6279\u91cf\u4efb\u52a1\u67e5\u8be2")
    public List<BatchJobLogDTO> selectBatchJob(BatchJobLogDTO inBean) {
        return this.batchMonitorMapper.selectBatchJob(inBean);
    }

    @Trader(tradeCode="BM1002", tradeName="\u6267\u884c\u6279\u91cf\u4efb\u52a1", propagation=Propagation.NOT_SUPPORTED)
    public JobExecution batchRun(String batchName, Map parameters) throws Exception {
        JobParameters jobParameters = new JobParametersBuilder().addLong("startTime", Long.valueOf(System.currentTimeMillis())).toJobParameters();
        if (null != parameters) {
            jobParameters.getParameters().putAll(parameters);
        }
        Job job = (Job)AppContext.getBean((String)batchName);
        JobExecution jobExecution = null;
        try {
            jobExecution = this.jobLauncher.run(job, jobParameters);
        }
        catch (JobInstanceAlreadyCompleteException jace) {
            ExceptionUtil.throwAppException((String)("\u4efb\u52a1[" + batchName + "]\u5df2\u5b58\u5728\u53c2\u6570\u4e3a[" + jobParameters + "]\u7684\u5b9e\u4f8b\u72b6\u6001\u4e3aCOMPLETE,\u5982\u91cd\u65b0\u8fd0\u884c\u9700\u66f4\u6539\u53c2\u6570"));
        }
        catch (JobExecutionAlreadyRunningException jare) {
            ExceptionUtil.throwAppException((String)("\u4efb\u52a1[" + batchName + "]\u5b58\u5728\u53c2\u6570\u4e3a[" + jobParameters + "]\u7684\u5b9e\u4f8b\u5df2\u5728\u8fd0\u884c\u4e2d" + jare.getMessage()));
        }
        return jobExecution;
    }

    @Trader(tradeCode="BM1003", tradeName="\u505c\u6b62\u6279\u91cf\u4efb\u52a1", propagation=Propagation.NOT_SUPPORTED)
    public boolean batchStop(String jobName) throws Exception {
        boolean sendMessage = false;
        Set runningExecutions = this.jobOperator.getRunningExecutions(jobName);
        Iterator iterator = runningExecutions.iterator();
        while (iterator.hasNext()) {
            sendMessage = this.jobOperator.stop(((Long)iterator.next()).longValue());
        }
        return sendMessage;
    }
}

