/*
 * Decompiled with CFR 0.152.
 */
package cn.trythis.ams.processor;

import cn.trythis.ams.annotation.TradeEnum;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class AnnotationProcessor
extends AbstractProcessor {
    private static final String GEN_CLASS_SUFFIX = "Enum";
    private Filer filer;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(TradeEnum.class);
        for (Element element : elements) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            TradeEnum dataDic = typeElement.getAnnotation(TradeEnum.class);
            String objectType = typeElement.getSimpleName().toString();
            Elements elementUtils = this.processingEnv.getElementUtils();
            Types typeUtils = this.processingEnv.getTypeUtils();
            List<? extends Element> members = typeElement.getEnclosedElements();
            for (Element element2 : members) {
                ElementKind kind = element2.getKind();
                if (kind.isField() && !kind.name().equals(ElementKind.ENUM_CONSTANT.name())) continue;
            }
        }
        this.messager.printMessage(Diagnostic.Kind.WARNING, "\u4fe1\u606f");
        return true;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.add(TradeEnum.class.getCanonicalName());
        return types;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

