/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.springframework.jdbc.core.metadata.GenericTableMetaDataProvider;

public class PostgresTableMetaDataProvider
extends GenericTableMetaDataProvider {
    public PostgresTableMetaDataProvider(DatabaseMetaData databaseMetaData) throws SQLException {
        super(databaseMetaData);
    }

    @Override
    public boolean isGetGeneratedKeysSimulated() {
        String version = this.getDatabaseVersion();
        if (version != null && version.compareTo("8.2.0") >= 0) {
            return true;
        }
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("PostgreSQL does not support getGeneratedKeys or INSERT ... RETURNING in version " + version));
        }
        return false;
    }

    @Override
    public String getSimpleQueryForGetGeneratedKey(String tableName, String keyColumnName) {
        return "RETURNING " + keyColumnName;
    }
}

