/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.support;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.handler.MethodInvokingMessageProcessor;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class BeanNameMessageProcessor<T>
implements MessageProcessor<T>,
BeanFactoryAware {
    private final String object;
    private final String methodName;
    private MessageProcessor<T> delegate;

    public BeanNameMessageProcessor(String object, String methodName) {
        this.object = object;
        this.methodName = methodName;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.notNull((Object)beanFactory);
        Object target = beanFactory.getBean(this.object);
        this.delegate = new MethodInvokingMessageProcessor(target, this.methodName);
    }

    public T processMessage(Message<?> message) {
        return (T)this.delegate.processMessage(message);
    }
}

