/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.kafka;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import kafka.serializer.Decoder;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageProducerSpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.kafka.core.ConnectionFactory;
import org.springframework.integration.kafka.core.Partition;
import org.springframework.integration.kafka.inbound.KafkaMessageDrivenChannelAdapter;
import org.springframework.integration.kafka.listener.ErrorHandler;
import org.springframework.integration.kafka.listener.KafkaMessageListenerContainer;
import org.springframework.integration.kafka.listener.OffsetManager;
import org.springframework.util.Assert;

public class KafkaMessageDrivenChannelAdapterSpec<S extends KafkaMessageDrivenChannelAdapterSpec<S>>
extends MessageProducerSpec<S, KafkaMessageDrivenChannelAdapter> {
    KafkaMessageDrivenChannelAdapterSpec(KafkaMessageListenerContainer messageListenerContainer) {
        super(new KafkaMessageDrivenChannelAdapter(messageListenerContainer));
    }

    public <T> S keyDecoder(Decoder<T> keyDecoder) {
        ((KafkaMessageDrivenChannelAdapter)this.target).setKeyDecoder(keyDecoder);
        return (S)((KafkaMessageDrivenChannelAdapterSpec)this._this());
    }

    public <T> S payloadDecoder(Decoder<T> payloadDecoder) {
        ((KafkaMessageDrivenChannelAdapter)this.target).setPayloadDecoder(payloadDecoder);
        return (S)((KafkaMessageDrivenChannelAdapterSpec)this._this());
    }

    public S autoCommitOffset(boolean autoCommitOffset) {
        ((KafkaMessageDrivenChannelAdapter)this.target).setAutoCommitOffset(autoCommitOffset);
        return (S)((KafkaMessageDrivenChannelAdapterSpec)this._this());
    }

    public S generateMessageId(boolean generateMessageId) {
        ((KafkaMessageDrivenChannelAdapter)this.target).setGenerateMessageId(generateMessageId);
        return (S)((KafkaMessageDrivenChannelAdapterSpec)this._this());
    }

    public S generateTimestamp(boolean generateTimestamp) {
        ((KafkaMessageDrivenChannelAdapter)this.target).setGenerateTimestamp(generateTimestamp);
        return (S)((KafkaMessageDrivenChannelAdapterSpec)this._this());
    }

    public S useMessageBuilderFactory(boolean useMessageBuilderFactory) {
        ((KafkaMessageDrivenChannelAdapter)this.target).setUseMessageBuilderFactory(useMessageBuilderFactory);
        return (S)((KafkaMessageDrivenChannelAdapterSpec)this._this());
    }

    public static class KafkaMessageListenerContainerSpec {
        private final KafkaMessageListenerContainer container;

        KafkaMessageListenerContainerSpec(ConnectionFactory connectionFactory, Partition[] partitions) {
            this.container = new KafkaMessageListenerContainer(connectionFactory, partitions);
        }

        KafkaMessageListenerContainerSpec(ConnectionFactory connectionFactory, String[] topics) {
            this.container = new KafkaMessageListenerContainer(connectionFactory, topics);
        }

        public KafkaMessageListenerContainerSpec offsetManager(OffsetManager offsetManager) {
            this.container.setOffsetManager(offsetManager);
            return this;
        }

        public KafkaMessageListenerContainerSpec errorHandler(ErrorHandler errorHandler) {
            this.container.setErrorHandler(errorHandler);
            return this;
        }

        public KafkaMessageListenerContainerSpec concurrency(int concurrency) {
            this.container.setConcurrency(concurrency);
            return this;
        }

        public KafkaMessageListenerContainerSpec stopTimeout(int stopTimeout) {
            this.container.setStopTimeout(stopTimeout);
            return this;
        }

        public KafkaMessageListenerContainerSpec fetchTaskExecutor(Executor fetchTaskExecutor) {
            this.container.setFetchTaskExecutor(fetchTaskExecutor);
            return this;
        }

        public KafkaMessageListenerContainerSpec adminTaskExecutor(Executor adminTaskExecutor) {
            this.container.setAdminTaskExecutor(adminTaskExecutor);
            return this;
        }

        public KafkaMessageListenerContainerSpec queueSize(int queueSize) {
            this.container.setQueueSize(queueSize);
            return this;
        }

        public KafkaMessageListenerContainerSpec maxFetch(int maxFetch) {
            this.container.setMaxFetch(maxFetch);
            return this;
        }
    }

    public static class KafkaMessageDrivenChannelAdapterListenerContainerSpec
    extends KafkaMessageDrivenChannelAdapterSpec<KafkaMessageDrivenChannelAdapterListenerContainerSpec>
    implements ComponentsRegistration {
        private KafkaMessageListenerContainerSpec spec;

        KafkaMessageDrivenChannelAdapterListenerContainerSpec(KafkaMessageListenerContainerSpec spec) {
            super(spec.container);
            this.spec = spec;
        }

        public KafkaMessageDrivenChannelAdapterListenerContainerSpec configureListenerContainer(Consumer<KafkaMessageListenerContainerSpec> configurer) {
            Assert.notNull(configurer);
            configurer.accept(this.spec);
            return (KafkaMessageDrivenChannelAdapterListenerContainerSpec)this._this();
        }

        @Override
        public Collection<Object> getComponentsToRegister() {
            return Collections.singleton(this.spec.container);
        }
    }
}

