/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.jms;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.jms.ChannelPublishingJmsMessageListener;
import org.springframework.integration.jms.JmsMessageDrivenEndpoint;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.messaging.MessageChannel;

public class JmsInboundGateway
extends MessagingGatewaySupport
implements DisposableBean,
OrderlyShutdownCapable {
    private final JmsMessageDrivenEndpoint endpoint;
    private final ChannelPublishingJmsMessageListener listener;

    public JmsInboundGateway(AbstractMessageListenerContainer listenerContainer, ChannelPublishingJmsMessageListener listener) {
        this.endpoint = new JmsMessageDrivenEndpoint(listenerContainer, listener);
        this.listener = listener;
    }

    public void setRequestChannel(MessageChannel requestChannel) {
        this.listener.setRequestChannel(requestChannel);
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.listener.setReplyChannel(replyChannel);
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.listener.setErrorChannel(errorChannel);
    }

    public void setRequestTimeout(long requestTimeout) {
        this.listener.setRequestTimeout(requestTimeout);
    }

    public void setReplyTimeout(long replyTimeout) {
        this.listener.setReplyTimeout(replyTimeout);
    }

    public void setShouldTrack(boolean shouldTrack) {
        this.listener.setShouldTrack(shouldTrack);
    }

    public String getComponentType() {
        return "jms:inbound-gateway";
    }

    public void setComponentName(String componentName) {
        super.setComponentName(componentName);
        this.endpoint.setComponentName(this.getComponentName());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.endpoint.setApplicationContext(applicationContext);
        this.endpoint.setBeanFactory((BeanFactory)applicationContext);
        this.listener.setBeanFactory((BeanFactory)applicationContext);
    }

    protected void onInit() throws Exception {
        this.endpoint.afterPropertiesSet();
    }

    ChannelPublishingJmsMessageListener getListener() {
        return this.listener;
    }

    protected void doStart() {
        this.endpoint.start();
    }

    protected void doStop() {
        this.endpoint.stop();
    }

    public void destroy() throws Exception {
        this.endpoint.destroy();
    }

    public int beforeShutdown() {
        return this.endpoint.beforeShutdown();
    }

    public int afterShutdown() {
        return this.endpoint.afterShutdown();
    }
}

