/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.channel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.dsl.core.IntegrationComponentSpec;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.util.Assert;

public abstract class MessageChannelSpec<S extends MessageChannelSpec<S, C>, C extends AbstractMessageChannel>
extends IntegrationComponentSpec<S, C> {
    protected C channel;
    private final List<Class<?>> datatypes = new ArrayList();
    private final List<ChannelInterceptor> interceptors = new LinkedList<ChannelInterceptor>();
    private MessageConverter messageConverter;

    @Override
    protected S id(String id) {
        return (S)((MessageChannelSpec)super.id(id));
    }

    public S datatype(Class<?> ... datatypes) {
        Assert.noNullElements((Object[])datatypes);
        this.datatypes.addAll(Arrays.asList(datatypes));
        return (S)((MessageChannelSpec)this._this());
    }

    public S interceptor(ChannelInterceptor ... interceptors) {
        Assert.noNullElements((Object[])interceptors);
        this.interceptors.addAll(Arrays.asList(interceptors));
        return (S)((MessageChannelSpec)this._this());
    }

    public S messageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
        return (S)((MessageChannelSpec)this._this());
    }

    @Override
    protected C doGet() {
        this.channel.setDatatypes(this.datatypes.toArray(new Class[this.datatypes.size()]));
        this.channel.setBeanName(this.id);
        this.channel.setInterceptors(this.interceptors);
        this.channel.setMessageConverter(this.messageConverter);
        return this.channel;
    }
}

