/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineSuite;
import org.apache.tinkerpop.gremlin.util.function.ScriptEngineLambda;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class ScriptEngineLambdaTest {
    @Test
    public void shouldCallAsFunction() {
        ScriptEngineLambda lambda = ScriptEngineLambdaTest.newLambda("1+a");
        Assert.assertEquals((long)11L, (long)Integer.parseInt(lambda.apply((Object)10).toString()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowOnBadScriptAsFunction() {
        ScriptEngineLambdaTest.newLambda("1432423)a").apply((Object)"a");
    }

    @Test
    public void shouldCallAsSupplier() {
        ScriptEngineLambda lambda = ScriptEngineLambdaTest.newLambda("11");
        Assert.assertEquals((Object)11, (Object)lambda.get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowOnBadScriptAsSupplier() {
        ScriptEngineLambdaTest.newLambda("1432423)a").get();
    }

    @Test
    public void shouldCallAsPredicate() {
        ScriptEngineLambda lambda = ScriptEngineLambdaTest.newLambda("a > 10");
        MatcherAssert.assertThat((Object)lambda.test((Object)100), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowOnBadScriptAsPredicate() {
        ScriptEngineLambdaTest.newLambda("1432423)a").test((Object)1);
    }

    @Test
    public void shouldCallAsConsumer() {
        ScriptEngineLambda lambda = ScriptEngineLambdaTest.newLambda("a.setData('test')");
        Junk junk = new Junk();
        lambda.accept((Object)junk);
        Assert.assertEquals((Object)"test", (Object)junk.getData());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowOnBadScriptAsConsumer() {
        ScriptEngineLambdaTest.newLambda("1432423)a").accept((Object)"1");
    }

    @Test
    public void shouldCallAsBiConsumer() {
        ScriptEngineLambda lambda = ScriptEngineLambdaTest.newLambda("a.setData('testa');b.setData('testb')");
        Junk junkA = new Junk();
        Junk junkB = new Junk();
        lambda.accept((Object)junkA, (Object)junkB);
        Assert.assertEquals((Object)"testa", (Object)junkA.getData());
        Assert.assertEquals((Object)"testb", (Object)junkB.getData());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowOnBadScriptAsBiConsumer() {
        ScriptEngineLambdaTest.newLambda("1432423)a").accept((Object)"1", (Object)"2");
    }

    @Test
    public void shouldCallAsTriConsumer() {
        ScriptEngineLambda lambda = ScriptEngineLambdaTest.newLambda("a.setData('testa');b.setData('testb');c.setData('testc')");
        Junk junkA = new Junk();
        Junk junkB = new Junk();
        Junk junkC = new Junk();
        lambda.accept((Object)junkA, (Object)junkB, (Object)junkC);
        Assert.assertEquals((Object)"testa", (Object)junkA.getData());
        Assert.assertEquals((Object)"testb", (Object)junkB.getData());
        Assert.assertEquals((Object)"testc", (Object)junkC.getData());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowOnBadScriptAsTriConsumer() {
        ScriptEngineLambdaTest.newLambda("1432423)a").accept((Object)"1", (Object)"2", (Object)"3");
    }

    @Test
    public void shouldCallAsOneArgPredicate() {
        ScriptEngineLambda lambda = ScriptEngineLambdaTest.newLambda("a < 100");
        Assert.assertTrue((boolean)lambda.test((Object)0));
        Assert.assertTrue((boolean)lambda.test((Object)99));
        Assert.assertFalse((boolean)lambda.test((Object)100));
    }

    @Test
    public void shouldCallTrivialFunction() {
        ScriptEngineLambda lambda = ScriptEngineLambdaTest.newLambda("2 + 2");
        Assert.assertEquals((Object)lambda.apply((Object)"foo"), (Object)4);
    }

    @Test
    public void shouldCallAsOneArgFunction() {
        ScriptEngineLambda lambda = ScriptEngineLambdaTest.newLambda("a + 2");
        Assert.assertEquals((Object)lambda.apply((Object)3), (Object)5);
        Assert.assertEquals((Object)lambda.apply((Object)10), (Object)12);
    }

    private static ScriptEngineLambda newLambda(String script) {
        return new ScriptEngineLambda(GremlinScriptEngineSuite.ENGINE_TO_TEST, script);
    }

    public static class Junk {
        private String data = "";

        public String getData() {
            return this.data;
        }

        public void setData(String x) {
            this.data = x;
        }
    }
}

