/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.MemoryLimitException;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.z.ZCompressorInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.config.Field;
import org.apache.tika.detect.zip.CompressorConstants;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.pkg.CompressorParserOptions;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CompressorParser
implements Parser {
    private static final long serialVersionUID = 2793565792967222459L;
    private static Set<MediaType> SUPPORTED_TYPES;
    private static Map<String, String> MIMES_TO_NAME;
    private boolean decompressConcatenated = false;
    private int memoryLimitInKb = 100000;

    private static MediaType getMediaType(CompressorInputStream stream) {
        if (stream instanceof BZip2CompressorInputStream) {
            return CompressorConstants.BZIP2;
        }
        if (stream instanceof GzipCompressorInputStream) {
            return CompressorConstants.GZIP;
        }
        if (stream instanceof XZCompressorInputStream) {
            return CompressorConstants.XZ;
        }
        if (stream instanceof DeflateCompressorInputStream) {
            return CompressorConstants.ZLIB;
        }
        if (stream instanceof ZCompressorInputStream) {
            return CompressorConstants.COMPRESS;
        }
        if (stream instanceof Pack200CompressorInputStream) {
            return CompressorConstants.PACK;
        }
        if (stream instanceof FramedSnappyCompressorInputStream || stream instanceof SnappyCompressorInputStream) {
            return CompressorConstants.SNAPPY_FRAMED;
        }
        if (stream instanceof LZMACompressorInputStream) {
            return CompressorConstants.LZMA;
        }
        return MediaType.OCTET_STREAM;
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        CompressorInputStream cis;
        Object name;
        stream = stream.markSupported() ? CloseShieldInputStream.wrap((InputStream)stream) : new BufferedInputStream((InputStream)CloseShieldInputStream.wrap((InputStream)stream));
        try {
            CompressorParserOptions options = (CompressorParserOptions)context.get(CompressorParserOptions.class, metadata1 -> this.decompressConcatenated);
            CompressorStreamFactory factory = new CompressorStreamFactory(options.decompressConcatenated(metadata), this.memoryLimitInKb);
            name = this.getStreamName(metadata);
            if (name != null) {
                cis = factory.createCompressorInputStream((String)name, stream);
            } else {
                cis = factory.createCompressorInputStream(stream);
                MediaType type = CompressorParser.getMediaType(cis);
                if (!type.equals((Object)MediaType.OCTET_STREAM)) {
                    metadata.set("Content-Type", type.toString());
                }
            }
        }
        catch (CompressorException e) {
            if (e.getCause() != null && e.getCause() instanceof MemoryLimitException) {
                throw new TikaMemoryLimitException(e.getMessage());
            }
            throw new TikaException("Unable to uncompress document stream", (Throwable)e);
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        try {
            EmbeddedDocumentExtractor extractor;
            Metadata entrydata = new Metadata();
            name = metadata.get("resourceName");
            if (name != null) {
                if (((String)name).endsWith(".tbz") || ((String)name).endsWith(".tbz2")) {
                    name = ((String)name).substring(0, ((String)name).lastIndexOf(".")) + ".tar";
                } else if (((String)name).endsWith(".bz") || ((String)name).endsWith(".bz2") || ((String)name).endsWith(".xz") || ((String)name).endsWith(".zlib") || ((String)name).endsWith(".pack") || ((String)name).endsWith(".br")) {
                    name = ((String)name).substring(0, ((String)name).lastIndexOf("."));
                } else if (((String)name).length() > 0) {
                    name = GzipUtils.getUncompressedFileName((String)name);
                }
                entrydata.set("resourceName", (String)name);
            }
            if ((extractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context)).shouldParseEmbedded(entrydata)) {
                extractor.parseEmbedded((InputStream)cis, (ContentHandler)xhtml, entrydata, true);
            }
        }
        finally {
            cis.close();
        }
        xhtml.endDocument();
    }

    private String getStreamName(Metadata metadata) {
        String mimeString = metadata.get("Content-Type");
        if (mimeString == null) {
            return null;
        }
        return MIMES_TO_NAME.get(mimeString);
    }

    @Field
    public void setMemoryLimitInKb(int memoryLimitInKb) {
        this.memoryLimitInKb = memoryLimitInKb;
    }

    public int getMemoryLimitInKb() {
        return this.memoryLimitInKb;
    }

    @Field
    public void setDecompressConcatenated(boolean decompressConcatenated) {
        this.decompressConcatenated = decompressConcatenated;
    }

    public boolean isDecompressConcatenated() {
        return this.decompressConcatenated;
    }

    static {
        HashSet<MediaType> TMP_SET = new HashSet<MediaType>(MediaType.set((MediaType[])new MediaType[]{CompressorConstants.BZIP, CompressorConstants.BZIP2, CompressorConstants.DEFLATE64, CompressorConstants.GZIP, CompressorConstants.GZIP_ALT, CompressorConstants.LZ4_FRAMED, CompressorConstants.COMPRESS, CompressorConstants.XZ, CompressorConstants.PACK, CompressorConstants.SNAPPY_FRAMED, CompressorConstants.ZLIB, CompressorConstants.LZMA}));
        try {
            Class.forName("org.brotli.dec.BrotliInputStream");
            TMP_SET.add(CompressorConstants.BROTLI);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        try {
            Class.forName("com.github.luben.zstd.ZstdInputStream");
            TMP_SET.add(CompressorConstants.ZSTD);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        SUPPORTED_TYPES = Collections.unmodifiableSet(TMP_SET);
        HashMap<String, String> tmpMimesToName = new HashMap<String, String>();
        tmpMimesToName.put(CompressorConstants.BZIP2.toString(), "bzip2");
        tmpMimesToName.put(CompressorConstants.GZIP.toString(), "gz");
        tmpMimesToName.put(CompressorConstants.LZ4_FRAMED.toString(), "lz4-framed");
        tmpMimesToName.put(CompressorConstants.LZ4_BLOCK.toString(), "lz4-block");
        tmpMimesToName.put(CompressorConstants.XZ.toString(), "xz");
        tmpMimesToName.put(CompressorConstants.PACK.toString(), "pack200");
        tmpMimesToName.put(CompressorConstants.SNAPPY_FRAMED.toString(), "snappy-framed");
        tmpMimesToName.put(CompressorConstants.ZLIB.toString(), "deflate");
        tmpMimesToName.put(CompressorConstants.COMPRESS.toString(), "z");
        tmpMimesToName.put(CompressorConstants.LZMA.toString(), "lzma");
        tmpMimesToName.put(CompressorConstants.BROTLI.toString(), "br");
        tmpMimesToName.put(CompressorConstants.ZSTD.toString(), "zstd");
        MIMES_TO_NAME = Collections.unmodifiableMap(tmpMimesToName);
    }
}

