/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.stream;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.plan.nodes.FlinkConventions;
import org.apache.flink.table.plan.nodes.datastream.DataStreamPythonCorrelate;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalTableFunctionScan;
import org.apache.flink.table.plan.rules.AbstractPythonCorrelateRuleBase;
import org.apache.flink.table.plan.schema.RowSchema;
import scala.Option;

public class DataStreamPythonCorrelateRule
extends AbstractPythonCorrelateRuleBase {
    public static final RelOptRule INSTANCE = new DataStreamPythonCorrelateRule();

    private DataStreamPythonCorrelateRule() {
        super(FlinkConventions.DATASTREAM(), "DataStreamPythonCorrelateRule");
    }

    @Override
    public RelNode convert(RelNode rel) {
        DataStreamPythonCorrelateFactory factory = new DataStreamPythonCorrelateFactory(rel);
        return factory.convertToCorrelate();
    }

    private static class DataStreamPythonCorrelateFactory
    extends AbstractPythonCorrelateRuleBase.PythonCorrelateFactoryBase {
        private DataStreamPythonCorrelateFactory(RelNode rel) {
            super(rel, FlinkConventions.DATASTREAM());
        }

        @Override
        public RelNode createPythonCorrelateNode(RelNode relNode, Option<RexNode> condition) {
            FlinkLogicalTableFunctionScan scan = (FlinkLogicalTableFunctionScan)relNode;
            return new DataStreamPythonCorrelate(relNode.getCluster(), this.traitSet, new RowSchema(this.convInput.getRowType()), this.convInput, scan, condition, new RowSchema(this.correlateRel.getRowType()), new RowSchema(this.join.getRowType()), this.join.getJoinType(), "DataStreamPythonCorrelateRule");
        }
    }
}

