/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes;

import java.io.Serializable;
import java.util.Set;
import java.util.SortedSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.table.plan.logical.MatchRecognize;
import org.apache.flink.table.runtime.aggregate.SortUtil$;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}baB\u0001\u0003!\u0003\r\ta\u0004\u0002\u0015\u0007>lWn\u001c8NCR\u001c\u0007NU3d_\u001et\u0017N_3\u000b\u0005\r!\u0011!\u00028pI\u0016\u001c(BA\u0003\u0007\u0003\u0011\u0001H.\u00198\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b]\u0001A\u0011\u0001\r\u0002\r\u0011Jg.\u001b;%)\u0005I\u0002CA\t\u001b\u0013\tY\"C\u0001\u0003V]&$\b\"B\u000f\u0001\t\u0013q\u0012!\u00069beRLG/[8o\u0017\u0016L8\u000fV8TiJLgn\u001a\u000b\u0004?)\"\u0004C\u0001\u0011(\u001d\t\tS\u0005\u0005\u0002#%5\t1E\u0003\u0002%\u001d\u00051AH]8pizJ!A\n\n\u0002\rA\u0013X\rZ3g\u0013\tA\u0013F\u0001\u0004TiJLgn\u001a\u0006\u0003MIAQa\u000b\u000fA\u00021\nAa[3zgB\u0011QFM\u0007\u0002])\u0011q\u0006M\u0001\u0005kRLGN\u0003\u00022\u0015\u000591-\u00197dSR,\u0017BA\u001a/\u0005=IU.\\;uC\ndWMQ5u'\u0016$\b\"B\u001b\u001d\u0001\u00041\u0014A\u00034jK2$g*Y7fgB\u0019q\u0007P\u0010\u000f\u0005aRdB\u0001\u0012:\u0013\u0005\u0019\u0012BA\u001e\u0013\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0010 \u0003\u0007M+\u0017O\u0003\u0002<%!)\u0001\t\u0001C\u0005\u0003\u0006\u0001rN\u001d3fe&tw\rV8TiJLgn\u001a\u000b\u0004?\tS\u0005\"B\"@\u0001\u0004!\u0015AB8sI\u0016\u00148\u000f\u0005\u0002F\u00116\taI\u0003\u0002Ha\u0005\u0019!/\u001a7\n\u0005%3%\u0001\u0004*fY\u000e{G\u000e\\1uS>t\u0007\"B\u001b@\u0001\u00041\u0004\"\u0002'\u0001\t\u0013i\u0015AF7fCN,(/Z:EK\u001aLg.\u001a+p'R\u0014\u0018N\\4\u0015\t}q%m\u0019\u0005\u0006\u001f.\u0003\r\u0001U\u0001\t[\u0016\f7/\u001e:fgB!\u0011KW\u0010]\u001b\u0005\u0011&BA*U\u0003\u001d\u0019w\u000e\u001c7fGRT!!\u0016,\u0002\r\r|W.\\8o\u0015\t9\u0006,\u0001\u0004h_><G.\u001a\u0006\u00023\u0006\u00191m\\7\n\u0005m\u0013&\u0001D%n[V$\u0018M\u00197f\u001b\u0006\u0004\bCA/a\u001b\u0005q&BA01\u0003\r\u0011X\r_\u0005\u0003Cz\u0013qAU3y\u001d>$W\rC\u00036\u0017\u0002\u0007a\u0007C\u0003e\u0017\u0002\u0007Q-\u0001\u0006fqB\u0014Xm]:j_:\u0004b!\u00054]m!|\u0012BA4\u0013\u0005%1UO\\2uS>t7\u0007E\u0002\u0012S.L!A\u001b\n\u0003\r=\u0003H/[8o!\r9D\b\u0018\u0005\u0006[\u0002!IA\\\u0001\u0015e><8\u000fU3s\u001b\u0006$8\r\u001b+p'R\u0014\u0018N\\4\u0015\u0005}y\u0007\"\u00029m\u0001\u0004\t\u0018!B5t\u00032d\u0007CA\ts\u0013\t\u0019(CA\u0004C_>dW-\u00198\t\u000bU\u0004A\u0011\u0002<\u0002\u001dM,(m]3u)>\u001cFO]5oOR\u0011qd\u001e\u0005\u0006qR\u0004\r!_\u0001\u0007gV\u00147/\u001a;\u0011\tESvD\u001f\t\u0004w~|R\"\u0001?\u000b\u0005=j(\"\u0001@\u0002\t)\fg/Y\u0005\u0004\u0003\u0003a(!C*peR,GmU3u\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000f\t!#\u00194uKJl\u0015\r^2i)>\u001cFO]5oOR)q$!\u0003\u0002\u000e!9\u00111BA\u0002\u0001\u0004a\u0016!B1gi\u0016\u0014\bBB\u001b\u0002\u0004\u0001\u0007a\u0007\u0003\u0005\u0002\u0012\u0001!\t\u0001CA\n\u00035i\u0017\r^2i)>\u001cFO]5oOR9q$!\u0006\u0002&\u0005\u001d\u0002\u0002CA\f\u0003\u001f\u0001\r!!\u0007\u0002\u00191|w-[2bY6\u000bGo\u00195\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b\u0005\u0003\u001dawnZ5dC2LA!a\t\u0002\u001e\tqQ*\u0019;dQJ+7m\\4oSj,\u0007BB\u001b\u0002\u0010\u0001\u0007a\u0007\u0003\u0004e\u0003\u001f\u0001\r!\u001a\u0005\t\u0003W\u0001A\u0011\u0001\u0005\u0002.\u0005aQ\r\u001f9mC&tW*\u0019;dQRQ\u0011qFA\u001b\u0003s\tY$!\u0010\u0011\u0007\u0015\u000b\t$C\u0002\u00024\u0019\u0013\u0011BU3m/JLG/\u001a:\t\u0011\u0005]\u0012\u0011\u0006a\u0001\u0003_\t!\u0001]<\t\u0011\u0005]\u0011\u0011\u0006a\u0001\u00033Aa!NA\u0015\u0001\u00041\u0004B\u00023\u0002*\u0001\u0007Q\r")
public interface CommonMatchRecognize {
    private String partitionKeysToString(ImmutableBitSet keys, Seq<String> fieldNames) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(keys.toArray())).map((Function1 & Serializable & scala.Serializable)k -> CommonMatchRecognize.$anonfun$partitionKeysToString$1(fieldNames, BoxesRunTime.unboxToInt((Object)k)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
    }

    private String orderingToString(RelCollation orders, Seq<String> fieldNames) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(orders.getFieldCollations()).asScala()).map((Function1 & Serializable & scala.Serializable)x -> new StringBuilder(1).append(fieldNames.apply(x.getFieldIndex())).append(" ").append(SortUtil$.MODULE$.directionToOrder(x.direction).getShortName()).toString(), Buffer$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String measuresDefineToString(ImmutableMap<String, RexNode> measures, Seq<String> fieldNames, Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String> expression) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(measures).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            RexNode v = (RexNode)tuple2._2();
            String string = new StringBuilder(4).append(expression.apply((Object)v, (Object)fieldNames, (Object)None$.MODULE$)).append(" AS ").append(k).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String rowsPerMatchToString(boolean isAll) {
        return isAll ? "ALL ROWS PER MATCH" : "ONE ROW PER MATCH";
    }

    private String subsetToString(ImmutableMap<String, SortedSet<String>> subset) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(subset).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            SortedSet v = (SortedSet)tuple2._2();
            String string = new StringBuilder(5).append(k).append(" = (").append(((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter((Set)v).asScala()).mkString(", ")).append(")").toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String afterMatchToString(RexNode after, Seq<String> fieldNames) {
        String string;
        SqlKind sqlKind = after.getKind();
        if (((Object)((Object)SqlKind.SKIP_TO_FIRST)).equals((Object)sqlKind)) {
            string = new StringBuilder(14).append("SKIP TO FIRST ").append(((RexNode)((RexCall)after).operands.get(0)).toString()).toString();
        } else if (((Object)((Object)SqlKind.SKIP_TO_LAST)).equals((Object)sqlKind)) {
            string = new StringBuilder(13).append("SKIP TO LAST ").append(((RexNode)((RexCall)after).operands.get(0)).toString()).toString();
        } else if (((Object)((Object)SqlKind.LITERAL)).equals((Object)sqlKind)) {
            String string2;
            SqlMatchRecognize.AfterOption afterOption = ((RexLiteral)after).getValueAs(SqlMatchRecognize.AfterOption.class);
            if (SqlMatchRecognize.AfterOption.SKIP_PAST_LAST_ROW.equals(afterOption)) {
                string2 = "SKIP PAST LAST ROW";
            } else if (SqlMatchRecognize.AfterOption.SKIP_TO_NEXT_ROW.equals(afterOption)) {
                string2 = "SKIP TO NEXT ROW";
            } else {
                throw new MatchError((Object)afterOption);
            }
            string = string2;
        } else {
            throw new IllegalStateException(new StringBuilder(59).append("Corrupted query tree. Unexpected ").append(after).append(" for ").append("after match strategy.").toString());
        }
        return string;
    }

    public static /* synthetic */ String matchToString$(CommonMatchRecognize $this, MatchRecognize logicalMatch, Seq fieldNames, Function3 expression) {
        return $this.matchToString(logicalMatch, (Seq<String>)fieldNames, (Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String>)expression);
    }

    default public String matchToString(MatchRecognize logicalMatch, Seq<String> fieldNames, Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String> expression) {
        String partitionBy = !logicalMatch.partitionKeys().isEmpty() ? new StringBuilder(14).append("PARTITION BY: ").append(this.partitionKeysToString(logicalMatch.partitionKeys(), fieldNames)).toString() : "";
        String orderBy = !logicalMatch.orderKeys().getFieldCollations().isEmpty() ? new StringBuilder(10).append("ORDER BY: ").append(this.orderingToString(logicalMatch.orderKeys(), fieldNames)).toString() : "";
        String measures = !logicalMatch.measures().isEmpty() ? new StringBuilder(10).append("MEASURES: ").append(this.measuresDefineToString(logicalMatch.measures(), fieldNames, expression)).toString() : "";
        String afterMatch = String.valueOf(this.afterMatchToString(logicalMatch.after(), fieldNames));
        String allRows = this.rowsPerMatchToString(logicalMatch.allRows());
        String pattern = new StringBuilder(11).append("PATTERN: (").append(logicalMatch.pattern().toString()).append(")").toString();
        String subset = !logicalMatch.subsets().isEmpty() ? new StringBuilder(9).append("SUBSET: ").append(this.subsetToString(logicalMatch.subsets())).append(" ").toString() : "";
        String define = new StringBuilder(8).append("DEFINE: ").append(this.measuresDefineToString(logicalMatch.patternDefinitions(), fieldNames, expression)).toString();
        String body = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{partitionBy, orderBy, measures, allRows, afterMatch, pattern, subset, define}))).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isEmpty()))).mkString(", ");
        return new StringBuilder(7).append("Match(").append(body).append(")").toString();
    }

    public static /* synthetic */ RelWriter explainMatch$(CommonMatchRecognize $this, RelWriter pw, MatchRecognize logicalMatch, Seq fieldNames, Function3 expression) {
        return $this.explainMatch(pw, logicalMatch, (Seq<String>)fieldNames, (Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String>)expression);
    }

    default public RelWriter explainMatch(RelWriter pw, MatchRecognize logicalMatch, Seq<String> fieldNames, Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String> expression) {
        return pw.itemIf("partitionBy", this.partitionKeysToString(logicalMatch.partitionKeys(), fieldNames), !logicalMatch.partitionKeys().isEmpty()).itemIf("orderBy", this.orderingToString(logicalMatch.orderKeys(), fieldNames), !logicalMatch.orderKeys().getFieldCollations().isEmpty()).itemIf("measures", this.measuresDefineToString(logicalMatch.measures(), fieldNames, expression), !logicalMatch.measures().isEmpty()).item("rowsPerMatch", this.rowsPerMatchToString(logicalMatch.allRows())).item("after", this.afterMatchToString(logicalMatch.after(), fieldNames)).item("pattern", logicalMatch.pattern().toString()).itemIf("subset", this.subsetToString(logicalMatch.subsets()), !logicalMatch.subsets().isEmpty()).item("define", logicalMatch.patternDefinitions());
    }

    public static /* synthetic */ String $anonfun$partitionKeysToString$1(Seq fieldNames$1, int k) {
        return (String)fieldNames$1.apply(k);
    }

    public static void $init$(CommonMatchRecognize $this) {
    }
}

