/*
 * Decompiled with CFR 0.152.
 */
package io.github.asleepyfish.util;

import com.theokanning.openai.OpenAiService;
import com.theokanning.openai.completion.CompletionRequest;
import io.github.asleepyfish.config.ChatGPTProperties;
import io.github.asleepyfish.enums.ChatGPTErrorEnum;
import io.github.asleepyfish.enums.FinishReasonEnum;
import io.github.asleepyfish.enums.ModelEnum;
import io.github.asleepyfish.exception.ChatGPTException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenAiUtils {
    private static final Log LOG = LogFactory.getLog(OpenAiUtils.class);
    private static OpenAiService openAiService;
    private static ChatGPTProperties chatGPTProperties;
    private static final Random RANDOM;

    public OpenAiUtils(OpenAiService openAiService, ChatGPTProperties chatGPTProperties) {
        OpenAiUtils.openAiService = openAiService;
        OpenAiUtils.chatGPTProperties = chatGPTProperties;
    }

    public static List<String> createCompletion(String prompt) {
        return OpenAiUtils.createCompletion(prompt, "DEFAULT USER");
    }

    public static List<String> createCompletion(String prompt, String user) {
        return OpenAiUtils.createCompletion(prompt, user, chatGPTProperties.getModel());
    }

    public static List<String> createCompletion(String prompt, String user, String model) {
        return OpenAiUtils.createCompletion(prompt, user, model, 0.9, 1.0);
    }

    public static List<String> createCompletion(String prompt, String user, String model, Double temperature, Double topP) {
        return OpenAiUtils.createCompletion(CompletionRequest.builder().model(model).prompt(prompt).user(user).temperature(temperature).topP(topP).maxTokens(ModelEnum.getMaxTokens(model)).build());
    }

    public static List<String> createCompletion(CompletionRequest completionRequest) {
        List choices = new ArrayList();
        for (int i = 0; i < chatGPTProperties.getRetries(); ++i) {
            try {
                if (i > 0) {
                    Thread.sleep(500 + RANDOM.nextInt(500));
                }
                choices = openAiService.createCompletion(completionRequest).getChoices();
                break;
            }
            catch (Exception e) {
                LOG.error((Object)("answer failed " + (i + 1) + " times, the error message is: " + e.getMessage()));
                if (i != chatGPTProperties.getRetries() - 1) continue;
                throw new ChatGPTException(ChatGPTErrorEnum.FAILED_TO_GENERATE_ANSWER, e.getMessage());
            }
        }
        ArrayList<String> results = new ArrayList<String>();
        choices.forEach(choice -> {
            String text = choice.getText();
            if (FinishReasonEnum.LENGTH.getMessage().equals(choice.getFinish_reason())) {
                text = text + System.lineSeparator() + "The answer is too long, Please disassemble the above problems into several minor problems.";
            }
            results.add(text);
        });
        return results;
    }

    static {
        RANDOM = new Random();
    }
}

