/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.table;

import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceOptions;
import com.ververica.cdc.connectors.mysql.source.config.ServerIdRange;
import com.ververica.cdc.connectors.mysql.source.utils.ObjectUtils;
import com.ververica.cdc.connectors.mysql.table.JdbcUrlUtils;
import com.ververica.cdc.connectors.mysql.table.MySqlTableSource;
import com.ververica.cdc.connectors.mysql.table.StartupMode;
import com.ververica.cdc.connectors.mysql.table.StartupOptions;
import com.ververica.cdc.debezium.table.DebeziumOptions;
import com.ververica.cdc.debezium.utils.ResolvedSchemaUtils;
import java.time.Duration;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.util.Preconditions;

public class MySqlTableSourceFactory
implements DynamicTableSourceFactory {
    private static final String IDENTIFIER = "mysql-cdc";
    private static final String SCAN_STARTUP_MODE_VALUE_INITIAL = "initial";
    private static final String SCAN_STARTUP_MODE_VALUE_EARLIEST = "earliest-offset";
    private static final String SCAN_STARTUP_MODE_VALUE_LATEST = "latest-offset";
    private static final String SCAN_STARTUP_MODE_VALUE_SPECIFIC_OFFSET = "specific-offset";
    private static final String SCAN_STARTUP_MODE_VALUE_TIMESTAMP = "timestamp";

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"debezium.", "jdbc.properties."});
        ReadableConfig config = helper.getOptions();
        String hostname = (String)config.get(MySqlSourceOptions.HOSTNAME);
        String username = (String)config.get(MySqlSourceOptions.USERNAME);
        String password = (String)config.get(MySqlSourceOptions.PASSWORD);
        String databaseName = (String)config.get(MySqlSourceOptions.DATABASE_NAME);
        this.validateRegex(MySqlSourceOptions.DATABASE_NAME.key(), databaseName);
        String tableName = (String)config.get(MySqlSourceOptions.TABLE_NAME);
        this.validateRegex(MySqlSourceOptions.TABLE_NAME.key(), tableName);
        int port = (Integer)config.get(MySqlSourceOptions.PORT);
        int splitSize = (Integer)config.get(MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE);
        int splitMetaGroupSize = (Integer)config.get(MySqlSourceOptions.CHUNK_META_GROUP_SIZE);
        int fetchSize = (Integer)config.get(MySqlSourceOptions.SCAN_SNAPSHOT_FETCH_SIZE);
        ZoneId serverTimeZone = ZoneId.of((String)config.get(MySqlSourceOptions.SERVER_TIME_ZONE));
        ResolvedSchema physicalSchema = ResolvedSchemaUtils.getPhysicalSchema((ResolvedSchema)context.getCatalogTable().getResolvedSchema());
        String serverId = this.validateAndGetServerId(config);
        StartupOptions startupOptions = MySqlTableSourceFactory.getStartupOptions(config);
        Duration connectTimeout = (Duration)config.get(MySqlSourceOptions.CONNECT_TIMEOUT);
        int connectMaxRetries = (Integer)config.get(MySqlSourceOptions.CONNECT_MAX_RETRIES);
        int connectionPoolSize = (Integer)config.get(MySqlSourceOptions.CONNECTION_POOL_SIZE);
        double distributionFactorUpper = (Double)config.get(MySqlSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND);
        double distributionFactorLower = (Double)config.get(MySqlSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND);
        boolean scanNewlyAddedTableEnabled = (Boolean)config.get(MySqlSourceOptions.SCAN_NEWLY_ADDED_TABLE_ENABLED);
        Duration heartbeatInterval = (Duration)config.get(MySqlSourceOptions.HEARTBEAT_INTERVAL);
        boolean enableParallelRead = (Boolean)config.get(MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_ENABLED);
        if (enableParallelRead) {
            this.validatePrimaryKeyIfEnableParallel(physicalSchema);
            this.validateStartupOptionIfEnableParallel(startupOptions);
            this.validateIntegerOption(MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE, splitSize, 1);
            this.validateIntegerOption(MySqlSourceOptions.CHUNK_META_GROUP_SIZE, splitMetaGroupSize, 1);
            this.validateIntegerOption(MySqlSourceOptions.SCAN_SNAPSHOT_FETCH_SIZE, fetchSize, 1);
            this.validateIntegerOption(MySqlSourceOptions.CONNECTION_POOL_SIZE, connectionPoolSize, 1);
            this.validateIntegerOption(MySqlSourceOptions.CONNECT_MAX_RETRIES, connectMaxRetries, 0);
            this.validateDistributionFactorUpper(distributionFactorUpper);
            this.validateDistributionFactorLower(distributionFactorLower);
        }
        return new MySqlTableSource(physicalSchema, port, hostname, databaseName, tableName, username, password, serverTimeZone, DebeziumOptions.getDebeziumProperties((Map)context.getCatalogTable().getOptions()), serverId, enableParallelRead, splitSize, splitMetaGroupSize, fetchSize, connectTimeout, connectMaxRetries, connectionPoolSize, distributionFactorUpper, distributionFactorLower, startupOptions, scanNewlyAddedTableEnabled, JdbcUrlUtils.getJdbcProperties(context.getCatalogTable().getOptions()), heartbeatInterval);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(MySqlSourceOptions.HOSTNAME);
        options.add(MySqlSourceOptions.USERNAME);
        options.add(MySqlSourceOptions.PASSWORD);
        options.add(MySqlSourceOptions.DATABASE_NAME);
        options.add(MySqlSourceOptions.TABLE_NAME);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(MySqlSourceOptions.PORT);
        options.add(MySqlSourceOptions.SERVER_TIME_ZONE);
        options.add(MySqlSourceOptions.SERVER_ID);
        options.add(MySqlSourceOptions.SCAN_STARTUP_MODE);
        options.add(MySqlSourceOptions.SCAN_STARTUP_SPECIFIC_OFFSET_FILE);
        options.add(MySqlSourceOptions.SCAN_STARTUP_SPECIFIC_OFFSET_POS);
        options.add(MySqlSourceOptions.SCAN_STARTUP_TIMESTAMP_MILLIS);
        options.add(MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_ENABLED);
        options.add(MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE);
        options.add(MySqlSourceOptions.CHUNK_META_GROUP_SIZE);
        options.add(MySqlSourceOptions.SCAN_SNAPSHOT_FETCH_SIZE);
        options.add(MySqlSourceOptions.CONNECT_TIMEOUT);
        options.add(MySqlSourceOptions.CONNECTION_POOL_SIZE);
        options.add(MySqlSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND);
        options.add(MySqlSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND);
        options.add(MySqlSourceOptions.CONNECT_MAX_RETRIES);
        options.add(MySqlSourceOptions.SCAN_NEWLY_ADDED_TABLE_ENABLED);
        options.add(MySqlSourceOptions.HEARTBEAT_INTERVAL);
        return options;
    }

    private static StartupOptions getStartupOptions(ReadableConfig config) {
        String modeString = (String)config.get(MySqlSourceOptions.SCAN_STARTUP_MODE);
        switch (modeString.toLowerCase()) {
            case "initial": {
                return StartupOptions.initial();
            }
            case "latest-offset": {
                return StartupOptions.latest();
            }
            case "earliest-offset": 
            case "specific-offset": 
            case "timestamp": {
                throw new ValidationException(String.format("Unsupported option value '%s', the options [%s, %s, %s] are not supported correctly, please do not use them until they're correctly supported", modeString, SCAN_STARTUP_MODE_VALUE_EARLIEST, SCAN_STARTUP_MODE_VALUE_SPECIFIC_OFFSET, SCAN_STARTUP_MODE_VALUE_TIMESTAMP));
            }
        }
        throw new ValidationException(String.format("Invalid value for option '%s'. Supported values are [%s, %s], but was: %s", MySqlSourceOptions.SCAN_STARTUP_MODE.key(), SCAN_STARTUP_MODE_VALUE_INITIAL, SCAN_STARTUP_MODE_VALUE_LATEST, modeString));
    }

    private void validatePrimaryKeyIfEnableParallel(ResolvedSchema physicalSchema) {
        if (!physicalSchema.getPrimaryKey().isPresent()) {
            throw new ValidationException(String.format("The primary key is necessary when enable '%s' to 'true'", MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_ENABLED));
        }
    }

    private void validateStartupOptionIfEnableParallel(StartupOptions startupOptions) {
        Preconditions.checkState((startupOptions.startupMode == StartupMode.INITIAL || startupOptions.startupMode == StartupMode.LATEST_OFFSET ? 1 : 0) != 0, (Object)String.format("MySql Parallel Source only supports startup mode 'initial' and 'latest-offset', but actual is %s", new Object[]{startupOptions.startupMode}));
    }

    private String validateAndGetServerId(ReadableConfig configuration) {
        String serverIdValue = (String)configuration.get(MySqlSourceOptions.SERVER_ID);
        if (serverIdValue != null) {
            try {
                ServerIdRange.from(serverIdValue);
            }
            catch (Exception e) {
                throw new ValidationException(String.format("The value of option 'server-id' is invalid: '%s'", serverIdValue), (Throwable)e);
            }
        }
        return serverIdValue;
    }

    private void validateIntegerOption(ConfigOption<Integer> option, int optionValue, int exclusiveMin) {
        Preconditions.checkState((optionValue > exclusiveMin ? 1 : 0) != 0, (Object)String.format("The value of option '%s' must larger than %d, but is %d", option.key(), exclusiveMin, optionValue));
    }

    private void validateRegex(String optionName, String regex) {
        try {
            Pattern.compile(regex);
        }
        catch (Exception e) {
            throw new ValidationException(String.format("The %s '%s' is not a valid regular expression", optionName, regex), (Throwable)e);
        }
    }

    private void validateDistributionFactorUpper(double distributionFactorUpper) {
        Preconditions.checkState((ObjectUtils.doubleCompare(distributionFactorUpper, 1.0) >= 0 ? 1 : 0) != 0, (Object)String.format("The value of option '%s' must larger than or equals %s, but is %s", MySqlSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.key(), 1.0, distributionFactorUpper));
    }

    private void validateDistributionFactorLower(double distributionFactorLower) {
        Preconditions.checkState((ObjectUtils.doubleCompare(distributionFactorLower, 0.0) >= 0 && ObjectUtils.doubleCompare(distributionFactorLower, 1.0) <= 0 ? 1 : 0) != 0, (Object)String.format("The value of option '%s' must between %s and %s inclusively, but is %s", MySqlSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.key(), 0.0, 1.0, distributionFactorLower));
    }
}

