/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.utils;

import com.ververica.cdc.connectors.mysql.schema.MySqlTypeUtils;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class ChunkUtils {
    private ChunkUtils() {
    }

    public static RowType getSplitType(Table table) {
        List primaryKeys = table.primaryKeyColumns();
        if (primaryKeys.isEmpty()) {
            throw new ValidationException(String.format("Incremental snapshot for tables requires primary key, but table %s doesn't have primary key.", table.id()));
        }
        return ChunkUtils.getSplitType((Column)primaryKeys.get(0));
    }

    public static RowType getSplitType(Column splitColumn) {
        return (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)splitColumn.name(), (DataType)MySqlTypeUtils.fromDbzColumn(splitColumn))}).getLogicalType();
    }

    public static Column getSplitColumn(Table table) {
        List primaryKeys = table.primaryKeyColumns();
        if (primaryKeys.isEmpty()) {
            throw new ValidationException(String.format("Incremental snapshot for tables requires primary key, but table %s doesn't have primary key.", table.id()));
        }
        return (Column)primaryKeys.get(0);
    }

    public static int getNextMetaGroupId(int receivedMetaNum, int metaGroupSize) {
        Preconditions.checkState((metaGroupSize > 0 ? 1 : 0) != 0);
        return receivedMetaNum % metaGroupSize == 0 ? receivedMetaNum / metaGroupSize : receivedMetaNum / metaGroupSize + 1;
    }
}

