/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source;

import com.ververica.cdc.connectors.mysql.MySqlValidator;
import com.ververica.cdc.connectors.mysql.debezium.DebeziumUtils;
import com.ververica.cdc.connectors.mysql.source.MySqlSourceBuilder;
import com.ververica.cdc.connectors.mysql.source.assigners.MySqlBinlogSplitAssigner;
import com.ververica.cdc.connectors.mysql.source.assigners.MySqlHybridSplitAssigner;
import com.ververica.cdc.connectors.mysql.source.assigners.MySqlSplitAssigner;
import com.ververica.cdc.connectors.mysql.source.assigners.state.BinlogPendingSplitsState;
import com.ververica.cdc.connectors.mysql.source.assigners.state.HybridPendingSplitsState;
import com.ververica.cdc.connectors.mysql.source.assigners.state.PendingSplitsState;
import com.ververica.cdc.connectors.mysql.source.assigners.state.PendingSplitsStateSerializer;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceConfigFactory;
import com.ververica.cdc.connectors.mysql.source.enumerator.MySqlSourceEnumerator;
import com.ververica.cdc.connectors.mysql.source.metrics.MySqlSourceReaderMetrics;
import com.ververica.cdc.connectors.mysql.source.reader.MySqlRecordEmitter;
import com.ververica.cdc.connectors.mysql.source.reader.MySqlSourceReader;
import com.ververica.cdc.connectors.mysql.source.reader.MySqlSourceReaderContext;
import com.ververica.cdc.connectors.mysql.source.reader.MySqlSplitReader;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSplit;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSplitSerializer;
import com.ververica.cdc.connectors.mysql.table.StartupMode;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Supplier;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.synchronization.FutureCompletingBlockingQueue;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.kafka.connect.source.SourceRecord;

@Internal
public class MySqlSource<T>
implements Source<T, MySqlSplit, PendingSplitsState>,
ResultTypeQueryable<T> {
    private static final long serialVersionUID = 1L;
    private final MySqlSourceConfigFactory configFactory;
    private final DebeziumDeserializationSchema<T> deserializationSchema;

    @PublicEvolving
    public static <T> MySqlSourceBuilder<T> builder() {
        return new MySqlSourceBuilder();
    }

    MySqlSource(MySqlSourceConfigFactory configFactory, DebeziumDeserializationSchema<T> deserializationSchema) {
        this.configFactory = configFactory;
        this.deserializationSchema = deserializationSchema;
    }

    public MySqlSourceConfigFactory getConfigFactory() {
        return this.configFactory;
    }

    public Boundedness getBoundedness() {
        return Boundedness.CONTINUOUS_UNBOUNDED;
    }

    public SourceReader<T, MySqlSplit> createReader(SourceReaderContext readerContext) throws Exception {
        MySqlSourceConfig sourceConfig = this.configFactory.createConfig(readerContext.getIndexOfSubtask());
        FutureCompletingBlockingQueue elementsQueue = new FutureCompletingBlockingQueue();
        Method metricGroupMethod = readerContext.getClass().getMethod("metricGroup", new Class[0]);
        metricGroupMethod.setAccessible(true);
        MetricGroup metricGroup = (MetricGroup)metricGroupMethod.invoke((Object)readerContext, new Object[0]);
        MySqlSourceReaderMetrics sourceReaderMetrics = new MySqlSourceReaderMetrics(metricGroup);
        sourceReaderMetrics.registerMetrics();
        MySqlSourceReaderContext mySqlSourceReaderContext = new MySqlSourceReaderContext(readerContext);
        Supplier<MySqlSplitReader> splitReaderSupplier = () -> new MySqlSplitReader(sourceConfig, readerContext.getIndexOfSubtask(), mySqlSourceReaderContext);
        return new MySqlSourceReader((FutureCompletingBlockingQueue<RecordsWithSplitIds<SourceRecord>>)elementsQueue, splitReaderSupplier, new MySqlRecordEmitter<T>(this.deserializationSchema, sourceReaderMetrics, sourceConfig.isIncludeSchemaChanges()), readerContext.getConfiguration(), mySqlSourceReaderContext, sourceConfig);
    }

    public SplitEnumerator<MySqlSplit, PendingSplitsState> createEnumerator(SplitEnumeratorContext<MySqlSplit> enumContext) {
        MySqlSplitAssigner splitAssigner;
        MySqlSourceConfig sourceConfig;
        block15: {
            sourceConfig = this.configFactory.createConfig(0);
            MySqlValidator validator = new MySqlValidator(sourceConfig);
            validator.validate();
            if (sourceConfig.getStartupOptions().startupMode == StartupMode.INITIAL) {
                try (JdbcConnection jdbc = DebeziumUtils.openJdbcConnection(sourceConfig);){
                    List<TableId> remainingTables = DebeziumUtils.discoverCapturedTables(jdbc, sourceConfig);
                    boolean isTableIdCaseSensitive = DebeziumUtils.isTableIdCaseSensitive(jdbc);
                    splitAssigner = new MySqlHybridSplitAssigner(sourceConfig, enumContext.currentParallelism(), remainingTables, isTableIdCaseSensitive);
                    break block15;
                }
                catch (Exception e) {
                    throw new FlinkRuntimeException("Failed to discover captured tables for enumerator", (Throwable)e);
                }
            }
            splitAssigner = new MySqlBinlogSplitAssigner(sourceConfig);
        }
        return new MySqlSourceEnumerator(enumContext, sourceConfig, splitAssigner);
    }

    public SplitEnumerator<MySqlSplit, PendingSplitsState> restoreEnumerator(SplitEnumeratorContext<MySqlSplit> enumContext, PendingSplitsState checkpoint) {
        MySqlSplitAssigner splitAssigner;
        MySqlSourceConfig sourceConfig = this.configFactory.createConfig(0);
        if (checkpoint instanceof HybridPendingSplitsState) {
            splitAssigner = new MySqlHybridSplitAssigner(sourceConfig, enumContext.currentParallelism(), (HybridPendingSplitsState)checkpoint);
        } else if (checkpoint instanceof BinlogPendingSplitsState) {
            splitAssigner = new MySqlBinlogSplitAssigner(sourceConfig, (BinlogPendingSplitsState)checkpoint);
        } else {
            throw new UnsupportedOperationException("Unsupported restored PendingSplitsState: " + checkpoint);
        }
        return new MySqlSourceEnumerator(enumContext, sourceConfig, splitAssigner);
    }

    public SimpleVersionedSerializer<MySqlSplit> getSplitSerializer() {
        return MySqlSplitSerializer.INSTANCE;
    }

    public SimpleVersionedSerializer<PendingSplitsState> getEnumeratorCheckpointSerializer() {
        return new PendingSplitsStateSerializer(this.getSplitSerializer());
    }

    public TypeInformation<T> getProducedType() {
        return this.deserializationSchema.getProducedType();
    }
}

