/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.debezium.task.context;

import io.debezium.DebeziumException;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.relational.TableId;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlErrorHandler
extends ErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlErrorHandler.class);
    private static final Pattern NOT_FOUND_TABLE_MSG_PATTERN = Pattern.compile("Encountered change event for table (.+)\\.(.+) whose schema isn't known to this connector");
    MySqlTaskContext context;

    public MySqlErrorHandler(String logicalName, ChangeEventQueue<?> queue, MySqlTaskContext context) {
        super(MySqlConnector.class, logicalName, queue);
        this.context = context;
    }

    protected boolean isRetriable(Throwable throwable) {
        return false;
    }

    public void setProducerThrowable(Throwable producerThrowable) {
        DebeziumException e;
        String detailMessage;
        Matcher matcher;
        if (producerThrowable.getCause() instanceof DebeziumException && (matcher = NOT_FOUND_TABLE_MSG_PATTERN.matcher(detailMessage = (e = (DebeziumException)producerThrowable.getCause()).getMessage())).find()) {
            String databaseName = matcher.group(1);
            String tableName = matcher.group(2);
            TableId tableId = new TableId(databaseName, null, tableName);
            if (this.context.getSchema().schemaFor(tableId) == null) {
                LOG.warn("Schema for table " + tableId + " is null");
                return;
            }
        }
        super.setProducerThrowable(producerThrowable);
    }
}

