/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql;

import com.ververica.cdc.connectors.mysql.debezium.DebeziumUtils;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import com.ververica.cdc.debezium.Validator;
import io.debezium.config.Configuration;
import io.debezium.jdbc.JdbcConnection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlValidator
implements Validator {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlValidator.class);
    private static final long serialVersionUID = 1L;
    private static final String BINLOG_FORMAT_ROW = "ROW";
    private static final String BINLOG_FORMAT_IMAGE_FULL = "FULL";
    private final Properties dbzProperties;
    private final MySqlSourceConfig sourceConfig;

    public MySqlValidator(Properties dbzProperties) {
        this.dbzProperties = dbzProperties;
        this.sourceConfig = null;
    }

    public MySqlValidator(MySqlSourceConfig sourceConfig) {
        this.dbzProperties = sourceConfig.getDbzProperties();
        this.sourceConfig = sourceConfig;
    }

    public void validate() {
        Object connection = null;
        try {
            connection = this.sourceConfig != null ? DebeziumUtils.openJdbcConnection(this.sourceConfig) : DebeziumUtils.createMySqlConnection(Configuration.from((Properties)this.dbzProperties));
            this.checkVersion((JdbcConnection)connection);
            this.checkBinlogFormat((JdbcConnection)connection);
            this.checkBinlogRowImage((JdbcConnection)connection);
        }
        catch (SQLException ex) {
            throw new TableException("Unexpected error while connecting to MySQL and validating", (Throwable)ex);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw new FlinkRuntimeException("Closing connection error", (Throwable)e);
                }
            }
        }
        LOG.info("MySQL validation passed.");
    }

    private void checkVersion(JdbcConnection connection) throws SQLException {
        boolean isSatisfied;
        String version = (String)connection.queryAndMap("SELECT VERSION()", rs -> rs.next() ? rs.getString(1) : "");
        Integer[] versionNumbers = (Integer[])Arrays.stream(version.split("\\.")).limit(2L).map(Integer::new).toArray(Integer[]::new);
        if (versionNumbers[0] > 5) {
            isSatisfied = true;
        } else if (versionNumbers[0] < 5) {
            isSatisfied = false;
        } else {
            boolean bl = isSatisfied = versionNumbers[1] >= 6;
        }
        if (!isSatisfied) {
            throw new ValidationException(String.format("Currently Flink MySql CDC connector only supports MySql whose version is larger or equal to 5.6, but actual is %s.%s.", versionNumbers[0], versionNumbers[1]));
        }
    }

    private void checkBinlogFormat(JdbcConnection connection) throws SQLException {
        String mode = ((String)connection.queryAndMap("SHOW GLOBAL VARIABLES LIKE 'binlog_format'", rs -> rs.next() ? rs.getString(2) : "")).toUpperCase();
        if (!BINLOG_FORMAT_ROW.equals(mode)) {
            throw new ValidationException(String.format("The MySQL server is configured with binlog_format %s rather than %s, which is required for this connector to work properly. Change the MySQL configuration to use a binlog_format=ROW and restart the connector.", mode, BINLOG_FORMAT_ROW));
        }
    }

    private void checkBinlogRowImage(JdbcConnection connection) throws SQLException {
        String rowImage = ((String)connection.queryAndMap("SHOW GLOBAL VARIABLES LIKE 'binlog_row_image'", rs -> {
            if (rs.next()) {
                return rs.getString(2);
            }
            return BINLOG_FORMAT_IMAGE_FULL;
        })).toUpperCase();
        if (!rowImage.equals(BINLOG_FORMAT_IMAGE_FULL)) {
            throw new ValidationException(String.format("The MySQL server is configured with binlog_row_image %s rather than %s, which is required for this connector to work properly. Change the MySQL configuration to use a binlog_row_image=FULL and restart the connector.", rowImage, BINLOG_FORMAT_IMAGE_FULL));
        }
    }
}

