/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzWYI;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzVVE;
import com.aspose.words.net.System.Data.zzWew;
import com.aspose.words.net.System.Data.zzZ0x;
import com.aspose.words.net.System.Data.zzaQ;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzXwI;
    private final DataColumnCollection zzXYC;
    private final ConstraintCollection zzXAS;
    private final zzZ0x zzW33;
    private ResultSet zzqw;
    private String zzXt;
    private DataSet zzXtq;
    private String zzYtY;
    private UniqueConstraint zzYNA;
    private boolean zzZEF;
    private final List<DataTableEventListener> zzXGu;
    private final Set<DataRow> zzW9y;
    private DataRelationCollection zzWnC;

    public DataTable() {
        this.zzXwI = new DataRowCollection(this);
        this.zzXYC = new DataColumnCollection(this);
        this.zzXAS = new ConstraintCollection(this);
        this.zzW33 = new zzZ0x(this);
        this.zzYtY = "";
        this.zzZEF = true;
        this.zzXGu = new ArrayList<DataTableEventListener>();
        this.zzW9y = new HashSet<DataRow>();
        this.zzWnC = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzXwI = new DataRowCollection(this);
        this.zzXYC = new DataColumnCollection(this);
        this.zzXAS = new ConstraintCollection(this);
        this.zzW33 = new zzZ0x(this);
        this.zzYtY = "";
        this.zzZEF = true;
        this.zzXGu = new ArrayList<DataTableEventListener>();
        this.zzW9y = new HashSet<DataRow>();
        this.zzWnC = new DataRelationCollection();
        this.zzXt = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzaQ.zzXDk(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzXwI = new DataRowCollection(this);
        this.zzXYC = new DataColumnCollection(this);
        this.zzXAS = new ConstraintCollection(this);
        this.zzW33 = new zzZ0x(this);
        this.zzYtY = "";
        this.zzZEF = true;
        this.zzXGu = new ArrayList<DataTableEventListener>();
        this.zzW9y = new HashSet<DataRow>();
        this.zzWnC = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzqw = resultSet;
        this.zzXt = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzqw != null) {
            if (this.zzqw.getStatement() != null) {
                this.zzqw.getStatement().getConnection().close();
            }
            this.zzqw = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzXt;
    }

    public void setTableName(String tableName) {
        this.zzXt = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzXYC.getCount();
    }

    public String getColumnName(int index) {
        return this.zzXYC.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzqw;
    }

    public DataSet getDataSet() {
        return this.zzXtq;
    }

    final void zzX6U(DataSet dataSet) {
        this.zzXtq = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzXtq.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzWnC.add(dataRelation);
        }
        return this.zzWnC;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzXtq.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzXwI;
    }

    public DataColumnCollection getColumns() {
        return this.zzXYC;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzXAS;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzYNA == null) {
            return new DataColumn[0];
        }
        return this.zzYNA.getColumns();
    }

    final void zzZ0x(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzYNA != null) {
                this.zzYNA.zzX4d(false);
                this.getConstraints().remove(this.zzYNA);
                this.zzYNA = null;
            }
            return;
        }
        if (this.zzYNA != null && DataColumn.areColumnSetsTheSame(value, this.zzYNA.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzXDk(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzYNA != null) {
            this.zzYNA.zzX4d(false);
            this.getConstraints().remove(this.zzYNA);
            this.zzYNA = null;
        }
        UniqueConstraint.zzXDk(this.getConstraints(), uniqueConstraint);
        this.zzYNA = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzYtY;
    }

    public void setNamespace(String namespace) {
        this.zzYtY = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzZEF;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzZEF = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzW9y.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzaQ.zzXDk(this.getResultSet(), this);
            zzaQ.zzaQ(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzWYI.zzX6U(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzaQ.zzYRf(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzXGu.contains(listener)) {
            this.zzXGu.add(listener);
        }
    }

    public void removeEventListener(zzWew listener) {
        if (this.zzXGu.contains(listener)) {
            this.zzXGu.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzXGu.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzW9y.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXGu) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzW9y.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXGu) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzW9y.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXGu) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXGu) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXGu) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzVVE zzXDk(zzaQ[] zzaQArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzaQArray.length];
        for (int i = 0; i < zzaQArray.length; ++i) {
            dataColumnArray[i] = zzaQArray[i].zzYnV();
        }
        DataTable dataTable = this;
        zzVVE zzVVE2 = dataTable.zzW33.zzX6U(dataColumnArray);
        if (zzVVE2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzVVE2;
    }

    final zzZ0x zzZa0() {
        return this.zzW33;
    }

    final Set<DataRow> zzWZB() {
        return this.zzW9y;
    }
}

