/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzV3;
import com.aspose.words.internal.zzVOr;
import com.aspose.words.internal.zzVPy;
import com.aspose.words.internal.zzVZn;
import com.aspose.words.internal.zzWA3;
import com.aspose.words.internal.zzWFb;
import com.aspose.words.internal.zzWU5;
import com.aspose.words.internal.zzWZ8;
import com.aspose.words.internal.zzWpK;
import com.aspose.words.internal.zzWsM;
import com.aspose.words.internal.zzXUg;
import com.aspose.words.internal.zzXeJ;
import com.aspose.words.internal.zzXl8;
import com.aspose.words.internal.zzY1s;
import com.aspose.words.internal.zzYBg;
import com.aspose.words.internal.zzYc4;
import com.aspose.words.internal.zzYca;
import com.aspose.words.internal.zzYyM;
import com.aspose.words.internal.zzZ0J;
import com.aspose.words.internal.zzZDH;
import com.aspose.words.internal.zzZOw;
import com.aspose.words.internal.zzZbR;
import com.aspose.words.internal.zzZt1;
import com.aspose.words.internal.zzun;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

abstract class zzZkV
extends X509CRL {
    protected zzWFb zzXiC;
    protected zzYc4 zzW4R;
    protected String zzZsU;
    protected byte[] zzW18;
    protected boolean zzZhj;

    zzZkV(zzWFb zzWFb2, zzYc4 zzYc42, String string, byte[] byArray, boolean bl) {
        this.zzXiC = zzWFb2;
        this.zzW4R = zzYc42;
        this.zzZsU = string;
        this.zzW18 = byArray;
        this.zzZhj = bl;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        set.remove(zzZOw.zzZM9.getId());
        set.remove(zzZOw.zzZKM.getId());
        return !set.isEmpty();
    }

    private Set zzZjl(boolean bl) {
        zzYca zzYca2;
        if (this.getVersion() == 2 && (zzYca2 = this.zzW4R.zzZnq().zzX2J()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = zzYca2.zzXQe();
            while (enumeration.hasMoreElements()) {
                zzYBg zzYBg2 = (zzYBg)enumeration.nextElement();
                zzZOw zzZOw2 = zzYca2.zzYvr(zzYBg2);
                if (bl != zzZOw2.isCritical()) continue;
                hashSet.add(zzYBg2.getId());
            }
            return hashSet;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.zzZjl(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.zzZjl(false);
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        zzWA3 zzWA32 = zzZkV.zzaQ(this.zzW4R, oid);
        if (zzWA32 != null) {
            try {
                return zzWA32.getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    @Override
    public void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        try {
            signature = this.zzXiC.zzIo(this.getSigAlgName());
        }
        catch (Exception exception) {
            signature = Signature.getInstance(this.getSigAlgName());
        }
        this.zzXDk(key, signature);
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = sigProvider != null ? Signature.getInstance(this.getSigAlgName(), sigProvider) : Signature.getInstance(this.getSigAlgName());
        this.zzXDk(key, signature);
    }

    private void zzXDk(PublicKey publicKey, Signature signature) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.zzW4R.zzYyV().equals(this.zzW4R.zzZnq().zzX9H())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        if (this.zzW18 != null) {
            try {
                zzZ0J.zzXDk(signature, zzZbR.zzVSm(this.zzW18));
            }
            catch (IOException iOException) {
                throw new SignatureException("cannot decode signature parameters: " + iOException.getMessage());
            }
        }
        signature.initVerify(publicKey);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(zzVOr.zzXDk(signature), 512);
            this.zzW4R.zzZnq().zzXDk(bufferedOutputStream, "DER");
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    @Override
    public int getVersion() {
        return this.zzW4R.zzXGg();
    }

    @Override
    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.zzW4R.zzfI().getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public Date getThisUpdate() {
        return this.zzW4R.zzZLB().zzOg();
    }

    @Override
    public Date getNextUpdate() {
        if (this.zzW4R.zzY6f() != null) {
            return this.zzW4R.zzY6f().zzOg();
        }
        return null;
    }

    private Set zzYdB() {
        HashSet<zzWpK> hashSet = new HashSet<zzWpK>();
        Enumeration enumeration = this.zzW4R.zzWAr();
        zzun zzun2 = null;
        while (enumeration.hasMoreElements()) {
            zzZOw zzZOw2;
            zzZt1.zzXDk zzXDk2 = (zzZt1.zzXDk)enumeration.nextElement();
            zzWpK zzWpK2 = new zzWpK(zzXDk2, this.zzZhj, zzun2);
            hashSet.add(zzWpK2);
            if (!this.zzZhj || !zzXDk2.hasExtensions() || (zzZOw2 = zzXDk2.zzX2J().zzYvr(zzZOw.zzNx)) == null) continue;
            zzun2 = zzun.zzW3E(zzYyM.zzAa(zzZOw2.zzXsK()).zzdU()[0].zzWjH());
        }
        return hashSet;
    }

    @Override
    public X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
        Enumeration enumeration = this.zzW4R.zzWAr();
        zzun zzun2 = null;
        while (enumeration.hasMoreElements()) {
            zzZOw zzZOw2;
            zzZt1.zzXDk zzXDk2 = (zzZt1.zzXDk)enumeration.nextElement();
            if (zzXDk2.zzWSv().zzaQ(serialNumber)) {
                return new zzWpK(zzXDk2, this.zzZhj, zzun2);
            }
            if (!this.zzZhj || !zzXDk2.hasExtensions() || (zzZOw2 = zzXDk2.zzX2J().zzYvr(zzZOw.zzNx)) == null) continue;
            zzun2 = zzun.zzW3E(zzYyM.zzAa(zzZOw2.zzXsK()).zzdU()[0].zzWjH());
        }
        return null;
    }

    public Set getRevokedCertificates() {
        Set set = this.zzYdB();
        if (!set.isEmpty()) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    @Override
    public byte[] getTBSCertList() throws CRLException {
        try {
            return this.zzW4R.zzZnq().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public byte[] getSignature() {
        return this.zzW4R.zzX5Y().zzZIO();
    }

    @Override
    public String getSigAlgName() {
        return this.zzZsU;
    }

    @Override
    public String getSigAlgOID() {
        return this.zzW4R.zzYyV().zzY3B().getId();
    }

    @Override
    public byte[] getSigAlgParams() {
        return zzXeJ.zzVV2(this.zzW18);
    }

    @Override
    public String toString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = zzZDH.zzXbt();
        stringBuffer.append("              Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("          This update: ").append(this.getThisUpdate()).append(string);
        stringBuffer.append("          Next update: ").append(this.getNextUpdate()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(new String(zzVZn.zzY7e(byArray, 0, 20))).append(string);
        for (int i = 20; i < byArray.length; i += 20) {
            if (i < byArray.length - 20) {
                stringBuffer.append("                       ").append(new String(zzVZn.zzY7e(byArray, i, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(new String(zzVZn.zzY7e(byArray, i, byArray.length - i))).append(string);
        }
        zzYca zzYca2 = this.zzW4R.zzZnq().zzX2J();
        if (zzYca2 != null) {
            object2 = zzYca2.zzXQe();
            if (object2.hasMoreElements()) {
                stringBuffer.append("           Extensions: ").append(string);
            }
            while (object2.hasMoreElements()) {
                object = (zzYBg)object2.nextElement();
                zzZOw zzZOw2 = zzYca2.zzYvr((zzYBg)object);
                if (zzZOw2.zzZb4() != null) {
                    byte[] byArray2 = zzZOw2.zzZb4().zzZIO();
                    zzWZ8 zzWZ82 = new zzWZ8(byArray2);
                    stringBuffer.append("                       critical(").append(zzZOw2.isCritical()).append(") ");
                    try {
                        if (((zzZbR)object).zzaQ(zzZOw.zzZ4l)) {
                            stringBuffer.append(new zzWU5(zzWsM.zzW53(zzWZ82.zzZKs()).zzXUV())).append(string);
                            continue;
                        }
                        if (((zzZbR)object).zzaQ(zzZOw.zzZKM)) {
                            stringBuffer.append("Base CRL: " + new zzWU5(zzWsM.zzW53(zzWZ82.zzZKs()).zzXUV())).append(string);
                            continue;
                        }
                        if (((zzZbR)object).zzaQ(zzZOw.zzZM9)) {
                            stringBuffer.append(zzY1s.zzWLU(zzWZ82.zzZKs())).append(string);
                            continue;
                        }
                        if (((zzZbR)object).zzaQ(zzZOw.zzZcY)) {
                            stringBuffer.append(zzXUg.zzVSx(zzWZ82.zzZKs())).append(string);
                            continue;
                        }
                        if (((zzZbR)object).zzaQ(zzZOw.zzYpJ)) {
                            stringBuffer.append(zzXUg.zzVSx(zzWZ82.zzZKs())).append(string);
                            continue;
                        }
                        stringBuffer.append(((zzYBg)object).getId());
                        stringBuffer.append(" value = ").append(zzVPy.zzZQ5(zzWZ82.zzZKs())).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(((zzYBg)object).getId());
                        stringBuffer.append(" value = *****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        if ((object2 = this.getRevokedCertificates()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isRevoked(Certificate cert) {
        if (!cert.getType().equals("X.509")) {
            throw new IllegalArgumentException("X.509 CRL used with non X.509 Cert");
        }
        Enumeration enumeration = this.zzW4R.zzWAr();
        zzun zzun2 = this.zzW4R.zzfI();
        if (enumeration.hasMoreElements()) {
            BigInteger bigInteger = ((X509Certificate)cert).getSerialNumber();
            while (enumeration.hasMoreElements()) {
                zzV3 zzV32;
                zzZt1.zzXDk zzXDk2 = zzZt1.zzXDk.zzLZ(enumeration.nextElement());
                if (this.zzZhj && zzXDk2.hasExtensions() && (zzV32 = zzXDk2.zzX2J().zzYvr(zzZOw.zzNx)) != null) {
                    zzun2 = zzun.zzW3E(zzYyM.zzAa(zzV32.zzXsK()).zzdU()[0].zzWjH());
                }
                if (!zzXDk2.zzWSv().zzaQ(bigInteger)) continue;
                if (cert instanceof X509Certificate) {
                    zzV32 = zzun.zzW3E(((X509Certificate)cert).getIssuerX500Principal().getEncoded());
                } else {
                    try {
                        zzV32 = zzXl8.zzZv1(cert.getEncoded()).zzfI();
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new IllegalArgumentException("Cannot process certificate: " + certificateEncodingException.getMessage());
                    }
                }
                return zzun2.equals(zzV32);
            }
        }
        return false;
    }

    protected static byte[] zzXDk(zzYc4 zzYc42, String string) {
        zzWA3 zzWA32 = zzZkV.zzaQ(zzYc42, string);
        if (zzWA32 != null) {
            return zzWA32.zzZIO();
        }
        return null;
    }

    private static zzWA3 zzaQ(zzYc4 zzYc42, String string) {
        zzZOw zzZOw2;
        zzYca zzYca2 = zzYc42.zzZnq().zzX2J();
        if (zzYca2 != null && (zzZOw2 = zzYca2.zzYvr(new zzYBg(string))) != null) {
            return zzZOw2.zzZb4();
        }
        return null;
    }
}

