/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zz2D;
import com.aspose.words.internal.zz8B;
import com.aspose.words.internal.zzVOr;
import com.aspose.words.internal.zzVPy;
import com.aspose.words.internal.zzVVJ;
import com.aspose.words.internal.zzVX9;
import com.aspose.words.internal.zzVZn;
import com.aspose.words.internal.zzWA3;
import com.aspose.words.internal.zzWEM;
import com.aspose.words.internal.zzWIr;
import com.aspose.words.internal.zzWZ8;
import com.aspose.words.internal.zzWvp;
import com.aspose.words.internal.zzX54;
import com.aspose.words.internal.zzXD4;
import com.aspose.words.internal.zzXMQ;
import com.aspose.words.internal.zzXeJ;
import com.aspose.words.internal.zzXgg;
import com.aspose.words.internal.zzXi6;
import com.aspose.words.internal.zzXl8;
import com.aspose.words.internal.zzYBg;
import com.aspose.words.internal.zzYNg;
import com.aspose.words.internal.zzYca;
import com.aspose.words.internal.zzYvQ;
import com.aspose.words.internal.zzYvb;
import com.aspose.words.internal.zzZ01;
import com.aspose.words.internal.zzZ0J;
import com.aspose.words.internal.zzZDH;
import com.aspose.words.internal.zzZFl;
import com.aspose.words.internal.zzZOw;
import com.aspose.words.internal.zzZZR;
import com.aspose.words.internal.zzZbR;
import com.aspose.words.internal.zzZsz;
import com.aspose.words.internal.zzun;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

abstract class zzYt5
extends X509Certificate {
    protected zzZZR zzWwX;
    protected zzXl8 zzXRG;
    protected zzWEM zzRO;
    protected boolean[] zzA8;
    protected String zzZsU;
    protected byte[] zzW18;

    zzYt5(zzZZR zzZZR2, zzXl8 zzXl82, zzWEM zzWEM2, boolean[] blArray, String string, byte[] byArray) {
        this.zzWwX = zzZZR2;
        this.zzXRG = zzXl82;
        this.zzRO = zzWEM2;
        this.zzA8 = blArray;
        this.zzZsU = string;
        this.zzW18 = byArray;
    }

    public final zzun zzWyr() {
        return this.zzXRG.zzfI();
    }

    public final zzXi6 zzWHd() {
        return this.zzXRG.zzW9k();
    }

    public final zzun zzQJ() {
        return this.zzXRG.zzXf1();
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.getTime() > this.getNotAfter().getTime()) {
            throw new CertificateExpiredException("certificate expired on " + this.zzXRG.zzZ52().zzZik());
        }
        if (date.getTime() < this.getNotBefore().getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.zzXRG.zzkc().zzZik());
        }
    }

    @Override
    public int getVersion() {
        return this.zzXRG.zzXGg();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.zzXRG.zzYno().zzXEd();
    }

    @Override
    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        try {
            byte[] byArray = this.zzXRG.zzfI().getEncoded("DER");
            return new X500Principal(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public Principal getSubjectDN() {
        return this.getSubjectX500Principal();
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        try {
            byte[] byArray = this.zzXRG.zzXf1().getEncoded("DER");
            return new X500Principal(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode subject DN");
        }
    }

    @Override
    public Date getNotBefore() {
        return this.zzXRG.zzkc().zzOg();
    }

    @Override
    public Date getNotAfter() {
        return this.zzXRG.zzZ52().zzOg();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return this.zzXRG.zzW9k().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    @Override
    public byte[] getSignature() {
        return this.zzXRG.zzX5Y().zzZIO();
    }

    @Override
    public String getSigAlgName() {
        return this.zzZsU;
    }

    @Override
    public String getSigAlgOID() {
        return this.zzXRG.zzYyV().zzY3B().getId();
    }

    @Override
    public byte[] getSigAlgParams() {
        return zzXeJ.zzVV2(this.zzW18);
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        zzYvb zzYvb2 = this.zzXRG.zzW9k().zzZj1();
        if (zzYvb2 != null) {
            byte[] byArray = zzYvb2.zzW2n();
            boolean[] blArray = new boolean[(byArray.length << 3) - zzYvb2.zzY3m()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        zzYvb zzYvb2 = this.zzXRG.zzW9k().zzWsK();
        if (zzYvb2 != null) {
            byte[] byArray = zzYvb2.zzW2n();
            boolean[] blArray = new boolean[(byArray.length << 3) - zzYvb2.zzY3m()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    @Override
    public boolean[] getKeyUsage() {
        return zzXeJ.zzYRf(this.zzA8);
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        byte[] byArray = zzYt5.zzaQ(this.zzXRG, "2.5.29.37");
        if (byArray == null) {
            return null;
        }
        try {
            zz8B zz8B2 = zz8B.zzXuz(zzZbR.zzVSm(byArray));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i != zz8B2.size(); ++i) {
                arrayList.add(((zzYBg)zz8B2.zzXLo(i)).getId());
            }
            return Collections.unmodifiableList(arrayList);
        }
        catch (Exception exception) {
            throw new CertificateParsingException("error processing extended key usage extension");
        }
    }

    @Override
    public int getBasicConstraints() {
        if (this.zzRO != null) {
            if (this.zzRO.zzXmg()) {
                if (this.zzRO.zzz9() == null) {
                    return Integer.MAX_VALUE;
                }
                return this.zzRO.zzz9().intValue();
            }
            return -1;
        }
        return -1;
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return zzYt5.zzXDk(this.zzXRG, zzZOw.zzY5T.getId());
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return zzYt5.zzXDk(this.zzXRG, zzZOw.zzbQ.getId());
    }

    public Set getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            zzYca zzYca2 = this.zzXRG.zzW9k().zzX2J();
            if (zzYca2 != null) {
                Enumeration enumeration = zzYca2.zzXQe();
                while (enumeration.hasMoreElements()) {
                    zzYBg zzYBg2 = (zzYBg)enumeration.nextElement();
                    zzZOw zzZOw2 = zzYca2.zzYvr(zzYBg2);
                    if (!zzZOw2.isCritical()) continue;
                    hashSet.add(zzYBg2.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        zzWA3 zzWA32 = zzYt5.zzWew(this.zzXRG, oid);
        if (zzWA32 != null) {
            try {
                return zzWA32.getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            zzYca zzYca2 = this.zzXRG.zzW9k().zzX2J();
            if (zzYca2 != null) {
                Enumeration enumeration = zzYca2.zzXQe();
                while (enumeration.hasMoreElements()) {
                    zzYBg zzYBg2 = (zzYBg)enumeration.nextElement();
                    zzZOw zzZOw2 = zzYca2.zzYvr(zzYBg2);
                    if (zzZOw2.isCritical()) continue;
                    hashSet.add(zzYBg2.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        zzYca zzYca2;
        if (this.getVersion() == 3 && (zzYca2 = this.zzXRG.zzW9k().zzX2J()) != null) {
            Enumeration enumeration = zzYca2.zzXQe();
            while (enumeration.hasMoreElements()) {
                zzZOw zzZOw2;
                zzYBg zzYBg2 = (zzYBg)enumeration.nextElement();
                if (zzYBg2.zzaQ(zzZOw.zzXNz) || zzYBg2.zzaQ(zzZOw.zzxt) || zzYBg2.zzaQ(zzZOw.zzWOA) || zzYBg2.zzaQ(zzZOw.zzW9l) || zzYBg2.zzaQ(zzZOw.zzZcY) || zzYBg2.zzaQ(zzZOw.zzZM9) || zzYBg2.zzaQ(zzZOw.zzZKM) || zzYBg2.zzaQ(zzZOw.zzmc) || zzYBg2.zzaQ(zzZOw.zzZ7E) || zzYBg2.zzaQ(zzZOw.zzY5T) || zzYBg2.zzaQ(zzZOw.zzYrP) || !(zzZOw2 = zzYca2.zzYvr(zzYBg2)).isCritical()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            return this.zzWwX.zzZ0x(this.zzXRG.zzZmP());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = zzZDH.zzXbt();
        stringBuffer.append("  [0]         Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("         SerialNumber: ").append(this.getSerialNumber()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("           Start Date: ").append(this.getNotBefore()).append(string);
        stringBuffer.append("           Final Date: ").append(this.getNotAfter()).append(string);
        stringBuffer.append("            SubjectDN: ").append(this.getSubjectDN()).append(string);
        stringBuffer.append("           Public Key: ").append(this.getPublicKey()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        if (byArray.length > 20) {
            stringBuffer.append("            Signature: ").append(zzVZn.zzYXi(byArray, 0, 20)).append(string);
            for (int i = 20; i < byArray.length; i += 20) {
                if (i < byArray.length - 20) {
                    stringBuffer.append("                       ").append(zzVZn.zzYXi(byArray, i, 20)).append(string);
                    continue;
                }
                stringBuffer.append("                       ").append(zzVZn.zzYXi(byArray, i, byArray.length - i)).append(string);
            }
        } else {
            stringBuffer.append("            Signature: ").append(zzVZn.zzWVd(byArray)).append(string);
        }
        zzYca zzYca2 = this.zzXRG.zzW9k().zzX2J();
        if (zzYca2 != null) {
            Enumeration enumeration = zzYca2.zzXQe();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("       Extensions: \n");
            }
            while (enumeration.hasMoreElements()) {
                zzYBg zzYBg2 = (zzYBg)enumeration.nextElement();
                zzZOw zzZOw2 = zzYca2.zzYvr(zzYBg2);
                if (zzZOw2.zzZb4() != null) {
                    byte[] byArray2 = zzZOw2.zzZb4().zzZIO();
                    zzWZ8 zzWZ82 = new zzWZ8(byArray2);
                    stringBuffer.append("                       critical(").append(zzZOw2.isCritical()).append(") ");
                    try {
                        if (zzYBg2.zzaQ(zzZOw.zzZ7E)) {
                            stringBuffer.append(zzWEM.zzWQd(zzWZ82.zzZKs())).append(string);
                            continue;
                        }
                        if (zzYBg2.zzaQ(zzZOw.zzXNz)) {
                            stringBuffer.append(zzVVJ.zzYkA(zzWZ82.zzZKs())).append(string);
                            continue;
                        }
                        if (zzYBg2.zzaQ(zzWIr.zzTj)) {
                            stringBuffer.append(new zzZFl(zzYvb.zzH2(zzWZ82.zzZKs()))).append(string);
                            continue;
                        }
                        if (zzYBg2.zzaQ(zzWIr.zzWQP)) {
                            stringBuffer.append(new zzWvp(zzYvQ.zzVRn(zzWZ82.zzZKs()))).append(string);
                            continue;
                        }
                        if (zzYBg2.zzaQ(zzWIr.zzVQj)) {
                            stringBuffer.append(new zzZ01(zzYvQ.zzVRn(zzWZ82.zzZKs()))).append(string);
                            continue;
                        }
                        stringBuffer.append(zzYBg2.getId());
                        stringBuffer.append(" value = ").append(zzVPy.zzZQ5(zzWZ82.zzZKs())).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(zzYBg2.getId());
                        stringBuffer.append(" value = *****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public final void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        String string = zzZ0J.zzWAW(this.zzXRG.zzYyV());
        try {
            signature = this.zzWwX.zzIo(string);
        }
        catch (Exception exception) {
            signature = Signature.getInstance(string);
        }
        this.zzaQ(key, signature);
    }

    @Override
    public final void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string = zzZ0J.zzWAW(this.zzXRG.zzYyV());
        Signature signature = sigProvider != null ? Signature.getInstance(string, sigProvider) : Signature.getInstance(string);
        this.zzaQ(key, signature);
    }

    private void zzaQ(PublicKey publicKey, Signature signature) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!zzYt5.zzXDk(this.zzXRG.zzYyV(), this.zzXRG.zzW9k().zzX9H())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        zzX54 zzX542 = this.zzXRG.zzYyV().zzZd8();
        zzZ0J.zzXDk(signature, zzX542);
        signature.initVerify(publicKey);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(zzVOr.zzXDk(signature), 512);
            this.zzXRG.zzW9k().zzXDk(bufferedOutputStream, "DER");
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("certificate does not verify with supplied key");
        }
    }

    private static boolean zzXDk(zzYNg zzYNg2, zzYNg zzYNg3) {
        if (!zzYNg2.zzY3B().zzaQ(zzYNg3.zzY3B())) {
            return false;
        }
        if (zzXD4.zzrL("org.bouncycastle.x509.allow_absent_equiv_NULL")) {
            if (zzYNg2.zzZd8() == null) {
                return zzYNg3.zzZd8() == null || zzYNg3.zzZd8().equals(zzXMQ.zzYUY);
            }
            if (zzYNg3.zzZd8() == null) {
                return zzYNg2.zzZd8() == null || zzYNg2.zzZd8().equals(zzXMQ.zzYUY);
            }
        }
        if (zzYNg2.zzZd8() != null) {
            return zzYNg2.zzZd8().equals(zzYNg3.zzZd8());
        }
        if (zzYNg3.zzZd8() != null) {
            return zzYNg3.zzZd8().equals(zzYNg2.zzZd8());
        }
        return true;
    }

    private static Collection zzXDk(zzXl8 zzXl82, String string) throws CertificateParsingException {
        byte[] byArray = zzYt5.zzaQ(zzXl82, string);
        if (byArray == null) {
            return null;
        }
        try {
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = zz8B.zzXuz(byArray).zzXpT();
            block11: while (enumeration.hasMoreElements()) {
                zzZsz zzZsz2 = zzZsz.zz3M(enumeration.nextElement());
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                int n = zzZsz2.zzZb0();
                arrayList2.add(n);
                switch (zzZsz2.zzZb0()) {
                    case 0: 
                    case 3: 
                    case 5: {
                        arrayList2.add(zzZsz2.getEncoded());
                        break;
                    }
                    case 4: {
                        arrayList2.add(zzun.zzXDk(zzVX9.zzkB, zzZsz2.zzWjH()).toString());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        arrayList2.add(((zzXgg)((Object)zzZsz2.zzWjH())).getString());
                        break;
                    }
                    case 8: {
                        arrayList2.add(zzYBg.zzYZS(zzZsz2.zzWjH()).getId());
                        break;
                    }
                    case 7: {
                        String string2;
                        byte[] byArray2 = zz2D.zzYms(zzZsz2.zzWjH()).zzZIO();
                        try {
                            string2 = InetAddress.getByAddress(byArray2).getHostAddress();
                        }
                        catch (UnknownHostException unknownHostException) {
                            continue block11;
                        }
                        arrayList2.add(string2);
                        break;
                    }
                    default: {
                        throw new IOException("Bad tag number: " + zzZsz2.zzZb0());
                    }
                }
                arrayList.add(Collections.unmodifiableList(arrayList2));
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return Collections.unmodifiableCollection(arrayList);
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
    }

    protected static byte[] zzaQ(zzXl8 zzXl82, String string) {
        zzWA3 zzWA32 = zzYt5.zzWew(zzXl82, string);
        if (zzWA32 != null) {
            return zzWA32.zzZIO();
        }
        return null;
    }

    private static zzWA3 zzWew(zzXl8 zzXl82, String string) {
        zzZOw zzZOw2;
        zzYca zzYca2 = zzXl82.zzW9k().zzX2J();
        if (zzYca2 != null && (zzZOw2 = zzYca2.zzYvr(new zzYBg(string))) != null) {
            return zzZOw2.zzZb4();
        }
        return null;
    }
}

