/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzW3g;
import com.aspose.words.internal.zzWBh;
import com.aspose.words.internal.zzWJv;
import com.aspose.words.internal.zzWQ8;
import com.aspose.words.internal.zzYAT;
import com.aspose.words.internal.zzYo1;
import com.aspose.words.internal.zzZtZ;
import com.aspose.words.zzXs;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public final class Watermark {
    private Document zzZoi;
    private zzXs zzWdR;

    Watermark(Document doc, zzXs watermarkProvider) {
        this.zzZoi = doc;
        this.zzWdR = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzXaE(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzXDk(text, textWatermarkOptions, this.zzZoi);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzWJv.zzaQ((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzZoi, 75);
        shape.getImageData().setImage(image);
        this.zzXDk(shape, options, this.zzZoi);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzWJv.zzaQ((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzZoi, 75);
        shape.getImageData().setImage(imagePath);
        this.zzXDk(shape, options, this.zzZoi);
    }

    final void zzXDk(zzYo1 zzYo12, ImageWatermarkOptions imageWatermarkOptions) throws Exception {
        zzWJv.zzaQ((Object)zzYo12, "imageStream");
        Shape shape = new Shape((DocumentBase)this.zzZoi, 75);
        shape.getImageData().zzEW(zzYo12);
        this.zzXDk(shape, imageWatermarkOptions, this.zzZoi);
    }

    public final void setImage(InputStream imageStream, ImageWatermarkOptions options) throws Exception {
        this.zzXDk(zzYo1.zzaQ(imageStream), options);
    }

    public final int getType() {
        Shape shape = this.zzWdR.get();
        if (shape == null) {
            return 2;
        }
        shape.zzXUH();
        if (shape.zzZ1M()) {
            return 0;
        }
        if (shape.zzYxz()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzWdR.add(shape);
    }

    public final void remove() {
        this.zzWdR.remove();
    }

    private static void zzXaE(String string) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (zzW3g.zzAa(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzWJv.zzXDk(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzXDk(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzaQ(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzVVE(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzaQ(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzWiX() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzWZO()) / d2) > (double)(f = pageSetup.zzW7J())) {
            d = (double)f / d3;
        }
        shape.zzYTo(zzZtZ.zzWew(d2 * d, 2, 1));
        shape.zzyI(zzZtZ.zzWew(d3 * d, 2, 1));
    }

    private Shape zzXDk(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzXDk(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzVVE(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzXDk(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzXfk() ? 1.0f : textWatermarkOptions.getFontSize();
        zzYAT zzYAT2 = document.zzYq7().zzWew(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzYAT2.zzYHW(shape.getTextPath().getText());
        if (textWatermarkOptions.zzXfk()) {
            l = Watermark.zzXDk(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzYTo(zzZtZ.zzWew(Float.intBitsToFloat(n), 2, 1));
        shape.zzyI(zzZtZ.zzWew(zzWQ8.zzXcQ(l), 2, 1));
    }

    private static long zzXDk(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzWZO();
        float f2 = pageSetup.zzW7J();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzWQ8.zzXcQ(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzWQ8.zzXbU(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzWQ8.zzXcQ(l) >= Float.intBitsToFloat(n)) {
            return zzWQ8.zzXbU(f2 / f3, f2);
        }
        float f6 = f;
        return zzWQ8.zzXbU(f6, f6 * f3);
    }

    private static void zzVVE(Shape shape, String string) {
        shape.setName(zzWBh.zzaQ("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

