/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.Document;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.FixedPageSaveOptions;
import com.aspose.words.IDocumentProcessorPlugin;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Node;
import com.aspose.words.NodeImporter;
import com.aspose.words.PageSet;
import com.aspose.words.Paragraph;
import com.aspose.words.Processor;
import com.aspose.words.Run;
import com.aspose.words.SaveOptions;
import com.aspose.words.Section;
import com.aspose.words.SplitOptions;
import com.aspose.words.SplitterContext;
import com.aspose.words.internal.zz3u;
import com.aspose.words.internal.zzW3g;
import com.aspose.words.internal.zzWBh;
import com.aspose.words.internal.zzWJv;
import com.aspose.words.internal.zzWzI;
import com.aspose.words.internal.zzY61;
import com.aspose.words.internal.zzYAy;
import com.aspose.words.internal.zzYo1;
import com.aspose.words.internal.zzZIw;
import com.aspose.words.internal.zzzo;
import com.aspose.words.zzW5H;
import com.aspose.words.zzXUC;
import com.aspose.words.zzYsG;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class Splitter
extends Processor {
    private SplitterContext zzZyf;

    private Splitter(SplitterContext context) {
        super(context);
        this.zzZyf = context;
    }

    public static Splitter create(SplitterContext context) {
        return new Splitter(context);
    }

    @Override
    protected void executeCore() throws Exception {
        switch (this.zzZyf.getSplitOptions().getSplitCriteria()) {
            case 0: {
                zzYo1[] zzYo1Array;
                Object object;
                zzZIw<zzYsG> zzZIw2;
                if (this.zzZRZ().zzZtm() == 36 && (zzZIw2 = this.zzYuW()).size() > 0) {
                    object = new zzW5H();
                    this.zzZRZ().zzXDk((IDocumentProcessorPlugin)object);
                    while ((zzZIw2 = this.zzYuW()).size() > 0) {
                        zzYo1Array = (zzYo1[])this.zzYuW().pop();
                        zzYo1[] zzYo1Array2 = object.toPagesInternal((FixedPageSaveOptions)zzYo1Array.zzAl());
                        zzYo1Array.zzWew(zzYo1Array2);
                    }
                    zzZIw2 = this.zzWi9();
                    if (zzZIw2.size() > 0) {
                        this.mResultDocument = object.toDocument();
                    }
                }
                if ((zzZIw2 = this.zzWi9()).size() > 0) {
                    if (this.mResultDocument == null) {
                        this.mResultDocument = this.zzZRZ().zzZ8u();
                    }
                    object = Splitter.zzZlN(this.mResultDocument);
                    while ((zzZIw2 = this.zzWi9()).size() > 0) {
                        zzYo1Array = (zzYsG)this.zzWi9().pop();
                        zzYo1Array.zzXDk((Document[])object);
                    }
                }
                if ((zzZIw2 = this.zzYuW()).size() <= 0) break;
                if (this.mResultDocument == null) {
                    this.mResultDocument = this.zzZRZ().zzZ8u();
                }
                while ((zzZIw2 = this.zzYuW()).size() > 0) {
                    object = (zzYsG)this.zzYuW().pop();
                    zzYo1Array = Splitter.zzXDk(this.mResultDocument, (FixedPageSaveOptions)((zzYsG)object).zzAl());
                    ((zzYsG)object).zzWew(zzYo1Array);
                }
                break;
            }
            case 1: {
                if (this.mResultDocument == null) {
                    this.mResultDocument = this.zzZRZ().zzZ8u();
                }
                Document[] documentArray = Splitter.zzYVZ(this.mResultDocument);
                this.zzaQ(documentArray);
                return;
            }
            case 2: {
                if (this.mResultDocument == null) {
                    this.mResultDocument = this.zzZRZ().zzZ8u();
                }
                Document[] documentArray = Splitter.zzYRf(this.mResultDocument, this.zzZyf.getSplitOptions().getSplitStyle());
                this.zzaQ(documentArray);
            }
        }
    }

    private void zzaQ(Document[] documentArray) throws Exception {
        zzYsG zzYsG2;
        zzZIw<zzYsG> zzZIw2;
        while ((zzZIw2 = this.zzWi9()).size() > 0) {
            zzYsG2 = (zzYsG)this.zzWi9().pop();
            zzYsG2.zzXDk(documentArray);
        }
        while ((zzZIw2 = this.zzYuW()).size() > 0) {
            zzYsG2 = (zzYsG)this.zzYuW().pop();
            zzYsG2.zzXDk(documentArray);
        }
    }

    public static ArrayList<Integer> removeBlankPages(String inputFileName, String outputFileName) throws Exception {
        int n = FileFormatUtil.extensionToSaveFormat(zz3u.zzZ3C(outputFileName));
        return Splitter.removeBlankPages(inputFileName, outputFileName, n);
    }

    public static ArrayList<Integer> removeBlankPages(String inputFileName, String outputFileName, int saveFormat) throws Exception {
        return Splitter.removeBlankPages(inputFileName, outputFileName, zzXUC.zzX1p(saveFormat, outputFileName));
    }

    public static ArrayList<Integer> removeBlankPages(String inputFileName, String outputFileName, SaveOptions saveOptions) throws Exception {
        String string = zz3u.zzXMi(outputFileName);
        if (zzW3g.zzWFs(string) && !zzzo.zzY7e(string)) {
            zzzo.zzZzb(string);
        }
        try (zzWzI zzWzI2 = zzWJv.zzXNB(inputFileName);){
            ArrayList<Integer> arrayList;
            zzWzI zzWzI3 = zzWJv.zzXDL(outputFileName);
            try {
                arrayList = Splitter.zzXDk((zzYo1)zzWzI2, zzWzI3, saveOptions);
            }
            catch (Throwable throwable) {
                ((zzYo1)zzWzI3).close();
                throw throwable;
            }
            ((zzYo1)zzWzI3).close();
            return arrayList;
        }
    }

    private static ArrayList<Integer> zzaQ(zzYo1 zzYo12, zzYo1 zzYo13, int n) throws Exception {
        return Splitter.zzXDk(zzYo12, zzYo13, zzXUC.zzX1p(n, null));
    }

    public static ArrayList<Integer> removeBlankPages(InputStream inputStream, OutputStream outputStream, int saveFormat) throws Exception {
        return Splitter.zzaQ(zzYo1.zzaQ(inputStream), zzYo1.zzWew(outputStream), saveFormat);
    }

    private static ArrayList<Integer> zzXDk(zzYo1 zzYo12, zzYo1 zzYo13, SaveOptions saveOptions) throws Exception {
        Document document = new Document(zzYo12);
        ArrayList<Integer> arrayList = document.removeBlankPages();
        document.zzXDk(zzYo13, saveOptions);
        return arrayList;
    }

    public static ArrayList<Integer> removeBlankPages(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions) throws Exception {
        return Splitter.zzXDk(zzYo1.zzaQ(inputStream), zzYo1.zzWew(outputStream), saveOptions);
    }

    public static void extractPages(String inputFileName, String outputFileName, int startPageIndex, int pageCount) throws Exception {
        int n = FileFormatUtil.extensionToSaveFormat(zz3u.zzZ3C(outputFileName));
        Splitter.extractPages(inputFileName, outputFileName, n, startPageIndex, pageCount);
    }

    public static void extractPages(String inputFileName, String outputFileName, int saveFormat, int startPageIndex, int pageCount) throws Exception {
        Splitter.extractPages(inputFileName, outputFileName, zzXUC.zzX1p(saveFormat, outputFileName), startPageIndex, pageCount);
    }

    public static void extractPages(String inputFileName, String outputFileName, SaveOptions saveOptions, int startPageIndex, int pageCount) throws Exception {
        String string = zz3u.zzXMi(outputFileName);
        if (zzW3g.zzWFs(string) && !zzzo.zzY7e(string)) {
            zzzo.zzZzb(string);
        }
        try (zzWzI zzWzI2 = zzWJv.zzXNB(inputFileName);){
            try (zzWzI zzWzI3 = zzWJv.zzXDL(outputFileName);){
                Splitter.zzXDk((zzYo1)zzWzI2, (zzYo1)zzWzI3, saveOptions, startPageIndex, pageCount);
            }
            return;
        }
    }

    private static void zzXDk(zzYo1 zzYo12, zzYo1 zzYo13, int n, int n2, int n3) throws Exception {
        Splitter.zzXDk(zzYo12, zzYo13, zzXUC.zzX1p(n, null), n2, n3);
    }

    public static void extractPages(InputStream inputStream, OutputStream outputStream, int saveFormat, int startPageIndex, int pageCount) throws Exception {
        Splitter.zzXDk(zzYo1.zzaQ(inputStream), (zzYo1)zzYo1.zzWew(outputStream), saveFormat, startPageIndex, pageCount);
    }

    private static void zzXDk(zzYo1 zzYo12, zzYo1 zzYo13, SaveOptions saveOptions, int n, int n2) throws Exception {
        Document document = new Document(zzYo12);
        document.extractPages(n, n2).zzXDk(zzYo13, saveOptions);
    }

    public static void extractPages(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions, int startPageIndex, int pageCount) throws Exception {
        Splitter.zzXDk(zzYo1.zzaQ(inputStream), (zzYo1)zzYo1.zzWew(outputStream), saveOptions, startPageIndex, pageCount);
    }

    public static void split(String inputFileName, String outputFileName, SplitOptions options) throws Exception {
        int n = FileFormatUtil.extensionToSaveFormat(zz3u.zzZ3C(outputFileName));
        Splitter.split(inputFileName, outputFileName, n, options);
    }

    public static void split(String inputFileName, String outputFileName, int saveFormat, SplitOptions options) throws Exception {
        Splitter.split(inputFileName, outputFileName, zzXUC.zzX1p(saveFormat, outputFileName), options);
    }

    public static void split(String inputFileName, String outputFileName, SaveOptions saveOptions, SplitOptions options) throws Exception {
        SplitterContext splitterContext = new SplitterContext(options);
        Splitter.create(splitterContext).from(inputFileName).to(outputFileName).execute();
    }

    private static zzYo1[] zzXDk(zzYo1 zzYo12, int n, SplitOptions splitOptions) throws Exception {
        return Splitter.zzXDk(zzYo12, zzXUC.zzX1p(n, null), splitOptions);
    }

    public static OutputStream[] split(InputStream inputStream, int saveFormat, SplitOptions options) throws Exception {
        return zzYo1.zzaQ(Splitter.zzXDk(zzYo1.zzaQ(inputStream), saveFormat, options));
    }

    private static zzYo1[] zzXDk(zzYo1 zzYo12, SaveOptions saveOptions, SplitOptions splitOptions) throws Exception {
        SplitterContext splitterContext = new SplitterContext(splitOptions);
        ArrayList<zzYo1> arrayList = new ArrayList<zzYo1>();
        Splitter.create(splitterContext).zzZJF(zzYo12).to(arrayList, saveOptions).execute();
        zzYo1[] zzYo1Array = new zzYo1[]{};
        ArrayList<zzYo1> arrayList2 = arrayList;
        return arrayList2.toArray(zzYo1Array);
    }

    public static OutputStream[] split(InputStream inputStream, SaveOptions saveOptions, SplitOptions options) throws Exception {
        return zzYo1.zzaQ(Splitter.zzXDk(zzYo1.zzaQ(inputStream), saveOptions, options));
    }

    private static zzYo1[] zzXDk(Document document, FixedPageSaveOptions fixedPageSaveOptions) throws Exception {
        int n = document.getPageCount();
        zzYo1[] zzYo1Array = new zzYo1[n];
        for (int i = 0; i < n; ++i) {
            zzYo1Array[i] = new zzY61();
            fixedPageSaveOptions.setPageSet(new PageSet(i));
            document.zzXDk(zzYo1Array[i], fixedPageSaveOptions);
        }
        return zzYo1Array;
    }

    private static Document[] zzZlN(Document document) throws Exception {
        int n = document.getPageCount();
        Document[] documentArray = new Document[n];
        for (int i = 0; i < n; ++i) {
            documentArray[i] = document.extractPages(i, 1);
        }
        return documentArray;
    }

    private static Document[] zzYVZ(Document document) {
        Document[] documentArray = new Document[document.getSections().getCount()];
        for (int i = 0; i < document.getSections().getCount(); ++i) {
            Section section = document.getSections().get(i);
            Document document2 = (Document)document.deepClone(false);
            document2.appendChild(document2.importNode(section, true, 0));
            documentArray[i] = document2;
        }
        return documentArray;
    }

    private static Document[] zzYRf(Document document, String string) {
        ImportFormatOptions importFormatOptions = new ImportFormatOptions();
        importFormatOptions.setKeepSourceNumbering(true);
        ArrayList arrayList = new ArrayList();
        Document document2 = (Document)document.deepClone(false);
        NodeImporter nodeImporter = new NodeImporter(document, document2, 0, importFormatOptions);
        zzYAy.zzXDk(arrayList, document2);
        for (CompositeNode compositeNode : document.getSections()) {
            Section section = (Section)nodeImporter.importNode(compositeNode, true);
            section.getBody().removeAllChildren();
            document2.appendChild(section);
            for (Node node : ((Section)compositeNode).getBody().getChildNodes(0, false)) {
                Paragraph paragraph;
                if (node != ((Section)compositeNode).getBody().getFirstChild() && node.getNodeType() == 8 && zzWBh.zzZYF((paragraph = (Paragraph)node).getParagraphFormat().getStyleName(), string)) {
                    document2 = (Document)document.deepClone(false);
                    nodeImporter = new NodeImporter(document, document2, 0, importFormatOptions);
                    zzYAy.zzXDk(arrayList, document2);
                    section = (Section)nodeImporter.importNode(compositeNode, true);
                    section.getBody().removeAllChildren();
                    document2.appendChild(section);
                }
                section.getBody().appendChild(nodeImporter.importNode(node, true));
            }
        }
        for (CompositeNode compositeNode : arrayList) {
            while (((Document)compositeNode).getLastSection().getBody().getLastParagraph().getLastChild() != null && ((Document)compositeNode).getLastSection().getBody().getLastParagraph().getLastChild().getNodeType() == 21 && zzWBh.zzZYF(((Run)((Document)compositeNode).getLastSection().getBody().getLastParagraph().getLastChild()).getText(), ControlChar.PAGE_BREAK)) {
                ((Document)compositeNode).getLastSection().getBody().getLastParagraph().getLastChild().remove();
            }
        }
        Document[] documentArray = new Document[]{};
        ArrayList arrayList2 = arrayList;
        return arrayList2.toArray(documentArray);
    }
}

