/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Cell;
import com.aspose.words.CellCollection;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.PreferredWidth;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzWJv;
import com.aspose.words.zzVU1;
import com.aspose.words.zzVX5;
import com.aspose.words.zzW69;
import com.aspose.words.zzW8u;
import com.aspose.words.zzXGx;
import com.aspose.words.zzXUC;
import com.aspose.words.zzXeO;
import com.aspose.words.zzYAn;
import com.aspose.words.zzZ4s;
import com.aspose.words.zzZFo;
import com.aspose.words.zzZX9;

public class Row
extends CompositeNode<Cell>
implements zzVU1,
zzVX5 {
    private int zzXdN;
    private int zzW1d;
    private zzW69 zzYtF;
    private RowFormat zzVUX;
    private CellCollection zzoy;

    public Row(DocumentBase doc) {
        this(doc, zzW69.zzB8());
    }

    Row(DocumentBase doc, zzW69 rowPr) {
        super(doc);
        this.zzYtF = rowPr;
    }

    @Override
    public int getNodeType() {
        return 6;
    }

    public Table getParentTable() {
        return (Table)this.zzYa4();
    }

    public boolean isFirstRow() {
        Row row = this;
        return row == row.getParentTable().getFirstRow();
    }

    public boolean isLastRow() {
        Row row = this;
        return row == row.getParentTable().getLastRow();
    }

    final boolean zzW0z() {
        if (!this.getRowFormat().getHeadingFormat()) {
            return false;
        }
        return this.isFirstRow() || this.getPreviousRow().zzW0z();
    }

    public Row getNextRow() {
        return (Row)this.zzXWD();
    }

    public Row getPreviousRow() {
        return (Row)this.zzWv6();
    }

    final int zzXT0() {
        Table table = this.getParentTable();
        if (table != null) {
            for (int i = 0; i < table.getRows().getCount(); ++i) {
                if (this != table.getRows().get(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public Cell getFirstCell() {
        return (Cell)this.zzZw9();
    }

    public Cell getLastCell() {
        return (Cell)this.zzB();
    }

    public CellCollection getCells() {
        if (this.zzoy == null) {
            this.zzoy = new CellCollection(this);
        }
        return this.zzoy;
    }

    public RowFormat getRowFormat() {
        if (this.zzVUX == null) {
            this.zzVUX = new RowFormat(this);
        }
        return this.zzVUX;
    }

    public boolean getHidden() {
        return this.zzYtF.getHidden();
    }

    public void setHidden(boolean value) {
        this.zzYtF.setHidden(value);
        this.zzFN(value);
    }

    private void zzFN(boolean bl) {
        for (Cell cell : this.zzoy) {
            for (Paragraph paragraph : cell.getParagraphs()) {
                paragraph.zzXCG().zzXDk(bl ? zzXeO.zzWHa : zzXeO.zzZfq);
                for (Run run : paragraph.getRuns()) {
                    run.getFont().setHidden(bl);
                }
            }
        }
    }

    final zzW69 zzW9p() {
        return this.zzYtF;
    }

    final void zzXDk(zzW69 zzW692) {
        this.zzYtF = zzW692;
    }

    final boolean zzYFB() {
        PreferredWidth preferredWidth = this.zzZx();
        return preferredWidth != null && preferredWidth.zzZ5z();
    }

    final int zzZcw() {
        if (this.zzYFB()) {
            return Math.max(this.zzZx().zzWvs(), 0);
        }
        return 0;
    }

    private PreferredWidth zzZx() {
        PreferredWidth preferredWidth = (PreferredWidth)this.getDirectRowAttr(4290);
        if (preferredWidth == null) {
            TableStyle tableStyle = zzWJv.zzXDk((Object)this.getParentTable().getStyle(), TableStyle.class);
            while (tableStyle != null && (preferredWidth = (PreferredWidth)tableStyle.getDirectRowAttr(4290)) == null) {
                tableStyle = zzWJv.zzXDk((Object)tableStyle.zzXDb(), TableStyle.class);
            }
        }
        return preferredWidth;
    }

    final void zzZ8b() {
        Row row = this;
        if (row.zzYtF.zzWON(4005)) {
            row = this;
            Style style = this.getDocument().getStyles().zzND(row.zzYtF.zzZC9(), false);
            if (style == null || style.getType() != 3) {
                row = this;
                row.zzYtF.zzXaE(11);
            }
        }
    }

    @Override
    final Node zzXDk(boolean bl, zzYAn zzYAn2) {
        Row row = (Row)super.zzXDk(bl, zzYAn2);
        zzW69 zzW692 = this.zzYtF;
        ((Row)super.zzXDk(bl, zzYAn2)).zzYtF = (zzW69)zzW692.zzXQq();
        row.zzVUX = null;
        row.zzoy = null;
        return row;
    }

    final boolean zzZ54(Row row) {
        Paragraph paragraph;
        Paragraph paragraph2;
        Cell cell;
        Cell cell2;
        Row row2 = this;
        Row row3 = row2;
        row3 = row;
        if (!row2.zzYtF.zzWpp(row3.zzYtF)) {
            return false;
        }
        row3 = this;
        if (!row3.zzYtF.zzXzC() && !this.getParentTable().zzXHQ() && zzWJv.zzYAx(cell2 = this.getFirstCell(), cell = row.getFirstCell()) && zzWJv.zzYAx(paragraph2 = (Paragraph)cell2.getChild(8, 0, true), paragraph = (Paragraph)cell.getChild(8, 0, true))) {
            zzZFo zzZFo2 = paragraph2.zzWVj(265);
            zzZFo zzZFo3 = paragraph.zzWVj(265);
            return zzZFo2.zzYAx(zzZFo3);
        }
        return true;
    }

    final void zzZKl() {
        Table table = this.getParentTable();
        Table table2 = new Table(table.getDocument());
        table.zzY5E(table2);
        Node node = this;
        while (node != null) {
            Node node2 = node.getNextSibling();
            node.remove();
            table2.zzYT7(node);
            node = node2;
        }
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitRowStart(this);
    }

    @Override
    public int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitRowEnd(this);
    }

    @Override
    public String getText() {
        return super.getText();
    }

    public void ensureMinimum() {
        Cell cell = this.getFirstCell();
        if (cell == null) {
            cell = this.appendChild(new Cell(this.getDocument()));
        }
        cell.ensureMinimum();
    }

    @Override
    final String zzZDH() {
        return ControlChar.CELL;
    }

    @Override
    final boolean zzXcI(Node node) {
        return zzXUC.zzZVN(node);
    }

    final void zzXDk(CellCollection cellCollection) {
        this.getCells().getCount();
        cellCollection.getCount();
        for (int i = 0; i < cellCollection.getCount(); ++i) {
            zzXGx zzXGx2 = this.getCells().get(i).zzWTf();
            if (zzXGx2 == null) continue;
            zzXGx zzXGx3 = zzXGx2;
            cellCollection.get(i).zzXDk((zzXGx)zzXGx3.zzXQq());
        }
    }

    final void zzXB6() {
        for (Paragraph paragraph : this.getChildNodes(8, true)) {
            paragraph.zzVZn().zzWwJ();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzYtF.zzYfo(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        Object object = this.zzYtF.get(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedRowAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        TableStyle tableStyle;
        if (this.getParentTable() != null && (tableStyle = zzWJv.zzXDk((Object)this.getParentTable().getStyle(), TableStyle.class)) != null) {
            return tableStyle.fetchRowAttr(key);
        }
        return zzW69.zzYBr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzYtF.zzXFB(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzYtF.clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() throws Exception {
        this.zzYtF.resetToDefaultAttrs();
    }

    final void zzuN() {
        if (!this.getDocument().zzL4().zzYyQ.zzXeJ()) {
            return;
        }
        Row row = this;
        if (row.zzYtF.getAlignment() != 0) {
            row = this;
            row.zzYtF.remove(4340);
        }
        row = this;
        if (row.zzYtF.zzN()) {
            int n;
            row = this;
            zzW69 zzW692 = (zzW69)row.zzYtF.zzXDP().zz1x();
            if (zzW692.zzZBD(4010)) {
                n = zzW692.getAlignment();
            } else {
                int n2;
                row = this;
                n = n2 = row.zzYtF.getAlignment();
            }
            if (n != 0) {
                zzW692.remove(4340);
            }
        }
    }

    final int zzY0Y() {
        return this.zzXdN;
    }

    final void zzYOv(int n) {
        this.zzXdN = n;
    }

    final int zzYCh() {
        return this.zzW1d;
    }

    final void zz0a(int n) {
        this.zzW1d = n;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZ4s getInsertRevision() {
        Row row = this;
        return row.zzYtF.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzZ4s value) {
        Cloneable cloneable = this;
        zzZ4s zzZ4s2 = value;
        cloneable = cloneable.zzYtF;
        ((zzZX9)cloneable).zzXFB(14, zzZ4s2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZ4s getDeleteRevision() {
        Row row = this;
        return row.zzYtF.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzZ4s value) {
        Cloneable cloneable = this;
        zzZ4s zzZ4s2 = value;
        cloneable = cloneable.zzYtF;
        ((zzZX9)cloneable).zzXFB(12, zzZ4s2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzW8u getMoveFromRevision() {
        Row row = this;
        return row.zzYtF.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzW8u value) {
        Cloneable cloneable = this;
        zzW8u zzW8u2 = value;
        cloneable = cloneable.zzYtF;
        ((zzZX9)cloneable).zzXFB(13, zzW8u2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzW8u getMoveToRevision() {
        Row row = this;
        return row.zzYtF.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzW8u value) {
        Cloneable cloneable = this;
        zzW8u zzW8u2 = value;
        cloneable = cloneable.zzYtF;
        ((zzZX9)cloneable).zzXFB(15, zzW8u2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Row row = this;
        row.zzYtF.remove(13);
        row = this;
        row.zzYtF.remove(15);
    }
}

