/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.LoadOptions;
import com.aspose.words.ProcessorContext;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zz3u;
import com.aspose.words.internal.zzYAy;
import com.aspose.words.internal.zzYo1;
import com.aspose.words.internal.zzZIw;
import com.aspose.words.zzWwz;
import com.aspose.words.zzXUC;
import com.aspose.words.zzYsG;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class Processor {
    private static boolean zzYt8 = false;
    protected Document mResultDocument;
    private ProcessorContext zzHP;
    private zzWwz zzWTT;
    private ArrayList<zzWwz> zzXPz = new ArrayList();
    private zzZIw<zzYsG> zzIT = new zzZIw();
    private zzZIw<zzYsG> zzDN = new zzZIw();

    Processor(ProcessorContext context) {
        this.zzHP = context;
    }

    public Processor from(String input) {
        return this.from(input, null);
    }

    public Processor from(String input, LoadOptions loadOptions) {
        this.zzWTT = new zzWwz(input, this.zzX6U(loadOptions), this.zzHP.getLayoutOptions());
        zzYAy.zzXDk(this.zzXPz, this.zzWTT);
        return this;
    }

    final Processor zzZJF(zzYo1 zzYo12) {
        return this.zzWew(zzYo12, null);
    }

    final Processor zzWew(zzYo1 zzYo12, LoadOptions loadOptions) {
        this.zzWTT = new zzWwz(zzYo12, this.zzX6U(loadOptions), this.zzHP.getLayoutOptions());
        zzYAy.zzXDk(this.zzXPz, this.zzWTT);
        return this;
    }

    public Processor from(InputStream input) {
        return this.zzWew(zzYo1.zzaQ(input), null);
    }

    public Processor from(InputStream input, LoadOptions loadOptions) {
        return this.zzWew(zzYo1.zzaQ(input), loadOptions);
    }

    public Processor to(String output) throws Exception {
        return this.to(output, null);
    }

    public Processor to(String output, SaveOptions saveOptions) throws Exception {
        if (saveOptions == null) {
            int n = FileFormatUtil.extensionToSaveFormat(zz3u.zzZ3C(output));
            saveOptions = zzXUC.zzX1p(n, output);
        }
        this.zzXDk(new zzYsG(output, saveOptions));
        return this;
    }

    public Processor to(String output, int saveFormat) throws Exception {
        SaveOptions saveOptions = zzXUC.zzX1p(saveFormat, output);
        this.zzXDk(new zzYsG(output, saveOptions));
        return this;
    }

    final Processor zzaQ(zzYo1 zzYo12, SaveOptions saveOptions) {
        this.zzXDk(new zzYsG(zzYo12, saveOptions));
        return this;
    }

    public Processor to(OutputStream output, SaveOptions saveOptions) {
        return this.zzaQ(zzYo1.zzWew(output), saveOptions);
    }

    private Processor zzXFB(zzYo1 zzYo12, int n) throws Exception {
        SaveOptions saveOptions = zzXUC.zzX1p(n, null);
        this.zzXDk(new zzYsG(zzYo12, saveOptions));
        return this;
    }

    public Processor to(OutputStream output, int saveFormat) throws Exception {
        return this.zzXFB(zzYo1.zzWew(output), saveFormat);
    }

    public Processor toOutput(ArrayList<OutputStream> output, SaveOptions saveOptions) {
        return this.to(zzYo1.zzXbU(output), saveOptions);
    }

    public Processor to(ArrayList<zzYo1> output, SaveOptions saveOptions) {
        this.zzXDk(new zzYsG(output, saveOptions));
        return this;
    }

    public Processor toOutput(ArrayList<OutputStream> output, int saveFormat) throws Exception {
        return this.to(zzYo1.zzXbU(output), saveFormat);
    }

    public Processor to(ArrayList<zzYo1> output, int saveFormat) throws Exception {
        SaveOptions saveOptions = zzXUC.zzX1p(saveFormat, null);
        this.zzXDk(new zzYsG(output, saveOptions));
        return this;
    }

    public void execute() throws Exception {
        this.checkArgumentsSet();
        this.executeCore();
    }

    protected void executeCore() throws Exception {
        zzZIw<zzYsG> zzZIw2 = this;
        zzZIw2 = ((Processor)((Object)zzZIw2)).zzDN;
        if (zzZIw2.size() == 0) {
            zzZIw2 = this;
            zzZIw2 = ((Processor)((Object)zzZIw2)).zzIT;
            if (zzZIw2.size() == 0) {
                return;
            }
        }
        this.zzWUu();
        this.zzK8();
    }

    protected void checkArgumentsSet() {
        zzZIw<zzYsG> zzZIw2 = this;
        if (((Processor)((Object)zzZIw2)).zzXPz.size() == 0) {
            throw new IllegalArgumentException("Input document is not specified.");
        }
        zzZIw2 = this;
        zzZIw2 = ((Processor)((Object)zzZIw2)).zzDN;
        if (zzZIw2.size() == 0) {
            zzZIw2 = this;
            zzZIw2 = ((Processor)((Object)zzZIw2)).zzIT;
            if (zzZIw2.size() == 0) {
                throw new IllegalArgumentException("Output document is not specified.");
            }
        }
    }

    private void zzWUu() throws Exception {
        if (this.mResultDocument == null) {
            throw new IllegalStateException("Result document is not initialized.");
        }
        while (true) {
            zzZIw<zzYsG> zzZIw2 = this;
            zzZIw2 = ((Processor)((Object)zzZIw2)).zzDN;
            if (zzZIw2.size() <= 0) break;
            zzZIw2 = this;
            zzYsG zzYsG2 = (zzYsG)((Processor)((Object)zzZIw2)).zzDN.pop();
            zzYsG2.zzWXF(this.mResultDocument);
        }
    }

    private void zzK8() throws Exception {
        if (this.mResultDocument == null) {
            throw new IllegalStateException("Result document is not initialized.");
        }
        if (this.mResultDocument.getOriginalLoadFormat() == 64) {
            this.mResultDocument.zzXTt();
        }
        while (true) {
            zzZIw<zzYsG> zzZIw2 = this;
            zzZIw2 = ((Processor)((Object)zzZIw2)).zzIT;
            if (zzZIw2.size() <= 0) break;
            zzZIw2 = this;
            zzYsG zzYsG2 = (zzYsG)((Processor)((Object)zzZIw2)).zzIT.pop();
            zzYsG2.zzWXF(this.mResultDocument);
        }
    }

    private LoadOptions zzX6U(LoadOptions loadOptions) {
        if (this.zzHP.getWarningCallback() != null || this.zzHP.getFontSettings() != null) {
            if (loadOptions == null) {
                loadOptions = new LoadOptions();
            }
            if (loadOptions.getWarningCallback() == null) {
                loadOptions.setWarningCallback(this.zzHP.getWarningCallback());
            }
            if (loadOptions.getFontSettings() == null) {
                loadOptions.setFontSettings(this.zzHP.getFontSettings());
            }
        }
        return loadOptions;
    }

    private void zzXDk(zzYsG zzYsG2) {
        if (FileFormatUtil.zzYAk(zzYsG2.zzAl().getSaveFormat())) {
            this.zzIT.push(zzYsG2);
            return;
        }
        this.zzDN.push(zzYsG2);
    }

    protected static String getPartFileName(String fileName, int partIndex, int saveFormat) throws Exception {
        String string = zz3u.zzXMi(fileName);
        String string2 = zz3u.zzX0Y(fileName) + "_" + partIndex + FileFormatUtil.saveFormatToExtension(saveFormat);
        return zz3u.zzZVN(string, string2);
    }

    final zzWwz zzZRZ() {
        return this.zzWTT;
    }

    final ArrayList<zzWwz> zzXOw() {
        return this.zzXPz;
    }

    final zzZIw<zzYsG> zzYuW() {
        return this.zzIT;
    }

    final zzZIw<zzYsG> zzWi9() {
        return this.zzDN;
    }
}

