/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.AiModel;
import com.aspose.words.CheckGrammarOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.IAiModelText;
import com.aspose.words.Language;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.Run;
import com.aspose.words.SummarizeOptions;
import com.aspose.words.internal.zzVRI;
import com.aspose.words.internal.zzW3g;
import com.aspose.words.internal.zzWBh;
import com.aspose.words.internal.zzWJv;
import com.aspose.words.internal.zzXsN;
import com.aspose.words.internal.zzYAy;
import com.aspose.words.internal.zzax;
import com.aspose.words.zzWAW;
import com.aspose.words.zzWRk;
import com.aspose.words.zzWcw;
import com.aspose.words.zzWdN;
import com.aspose.words.zzXs7;
import com.aspose.words.zzcw;
import com.aspose.words.zztZ;
import com.aspose.words.zzun;
import java.util.ArrayList;

public abstract class OpenAiModel
extends AiModel
implements IAiModelText {
    private String zzZOW;
    private String zzYa7;
    private double zzWy5 = 1.0;
    private double zzYLQ = 1.0;
    private int zzWiN = 1;

    protected OpenAiModel() {
    }

    public Document summarize(Document sourceDocument) throws Exception {
        return this.summarize(sourceDocument, null);
    }

    @Override
    public Document summarize(Document sourceDocument, SummarizeOptions options) throws Exception {
        String string = sourceDocument.toString(70);
        String string2 = this.zzXDk(string, options);
        Document document = zzWcw.zzZUE(zzcw.zzYCs(string2));
        document.zzZML().add(32);
        return document;
    }

    public Document summarize(Document[] sourceDocuments) throws Exception {
        return this.summarize(sourceDocuments, null);
    }

    @Override
    public Document summarize(Document[] sourceDocuments, SummarizeOptions options) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = sourceDocuments;
        int n = sourceDocuments.length;
        for (int i = 0; i < n; ++i) {
            Document document = object[i];
            String string = document.toString(70);
            String string2 = this.zzXDk(string, options);
            zzWJv.zzXDk(stringBuilder, string2);
        }
        object = this.zzXDk(stringBuilder.toString(), options);
        Document document = zzWcw.zzZUE(zzcw.zzYCs((String)object));
        document.zzZML().add(32);
        return document;
    }

    @Override
    public Document translate(Document sourceDocument, int targetLanguage) throws Exception {
        NodeCollection nodeCollection;
        Document document = sourceDocument.deepClone();
        document.joinRunsWithSameFormatting();
        NodeCollection nodeCollection2 = nodeCollection = new NodeCollection((CompositeNode)document, new zzWAW(), true);
        ArrayList<Node> arrayList = nodeCollection.zzZcF();
        if (arrayList.size() == 0) {
            return document;
        }
        document.zzZML().add(32);
        zzWcw.zzWpp(arrayList);
        String string = zzWcw.zzYT7(arrayList);
        ArrayList<zzWRk> arrayList2 = new ArrayList<zzWRk>();
        zzYAy.zzXDk(arrayList2, new zztZ(zzWBh.zzaQ("Never write any explanations. Pay special attention to never translating '{0}' and leaving it in the text as is. ", new Object[]{"___run___"})));
        String string2 = zzWBh.zzX6U(this.zzXDk(string, targetLanguage, arrayList2), "\r\n".toCharArray());
        if ("CanNotTranslate!".equals(string2)) {
            return document;
        }
        zzax zzax2 = zzWcw.zzaQ(string2, arrayList);
        zzax zzax3 = zzWcw.zzaQ(zzax2, arrayList.size() - 1);
        for (int i = 0; i < zzax3.getCount(); ++i) {
            int n = zzax3.get(i);
            this.zzaQ((Run)arrayList.get(n), targetLanguage);
        }
        return document;
    }

    @Override
    final String zzYRQ(ArrayList<zzWRk> arrayList, int n) {
        zzun zzun2 = new zzun();
        zzun2.zzY04("{\n");
        zzun2.zzX4L("model", this.getName());
        if (this.zzWiN != 1) {
            zzun2.zzJS("n", this.zzWiN);
        }
        if (!zzVRI.zzCL(this.zzYLQ, 1.0)) {
            zzun2.zzYvr("top_p", this.zzYLQ);
        }
        if (!zzVRI.zzCL(this.zzWy5, 1.0)) {
            zzun2.zzYvr("temperature", this.zzWy5);
        }
        zzun2.zzYRf("messages", arrayList);
        zzun2.zzY04("\n}");
        return zzun2.toString();
    }

    public OpenAiModel withOrganization(String organizationId) {
        String string = organizationId;
        OpenAiModel openAiModel = this;
        this.zzZOW = string;
        return this;
    }

    public OpenAiModel withProject(String projectId) {
        String string = projectId;
        OpenAiModel openAiModel = this;
        this.zzYa7 = string;
        return this;
    }

    ArrayList<zzWRk> zzWew(CheckGrammarOptions checkGrammarOptions) {
        ArrayList<zzWRk> arrayList = new ArrayList<zzWRk>();
        zzYAy.zzXDk(arrayList, new zztZ("Don't write any explanations in response."));
        zzYAy.zzXDk(arrayList, new zztZ("Respond in the same language as the source text."));
        if (checkGrammarOptions != null && checkGrammarOptions.getImproveStylistics()) {
            zzYAy.zzXDk(arrayList, new zztZ("Paraphrase output text more nicely."));
        }
        zzYAy.zzXDk(arrayList, new zztZ(zzWBh.zzaQ("Always preserve every '{0}' in text and do not change it, even at the very start, middle or end of text.", new Object[]{"run___"})));
        zzYAy.zzXDk(arrayList, new zztZ("Make sure there is a punctuation mark at the very end of text."));
        zzYAy.zzXDk(arrayList, new zztZ(zzWBh.zzaQ("Check spelling and grammar and correct all found errors ignoring every '{0}'.", new Object[]{"run___"})));
        zzYAy.zzXDk(arrayList, new zztZ(zzWBh.zzaQ("Don't add any punctuation or whitespace character immediately after the numbers coming immediately after the {0}.", new Object[]{"run___"})));
        zzYAy.zzXDk(arrayList, new zztZ("The text is the following."));
        return arrayList;
    }

    private String zzXDk(String string, SummarizeOptions summarizeOptions) throws Exception {
        Object object;
        ArrayList<zzWdN> arrayList = this.zzaQ(string, summarizeOptions);
        while (arrayList.size() > 1) {
            object = OpenAiModel.zzYG8(arrayList);
            arrayList = this.zzaQ((String)object, summarizeOptions);
        }
        object = arrayList.get(0);
        if (object == null || ((zzWdN)object).zzXmy().size() == 0) {
            return "";
        }
        return ((zzWdN)object).zzXmy().get(0);
    }

    private ArrayList<zzWdN> zzaQ(String string, SummarizeOptions summarizeOptions) throws Exception {
        ArrayList<zzWdN> arrayList = new ArrayList<zzWdN>();
        String string2 = SummarizeOptions.zzXDk(summarizeOptions);
        ArrayList<zzWRk> arrayList2 = new ArrayList<zzWRk>();
        zzXs7 zzXs72 = new zzXs7(zzWBh.zzaQ("Please summarize the following text in {0} sentences. The result must be in the same language in which this text is written.", new Object[]{string2}));
        zzYAy.zzXDk(arrayList2, zzXs72);
        ArrayList<zzWRk> arrayList3 = OpenAiModel.zzY62(string, 0x100000);
        zzYAy.zzXDk(arrayList2, arrayList3);
        String string3 = this.zzWE0(arrayList2, 1);
        zzcw zzcw2 = new zzcw(string3);
        zzWdN zzWdN2 = zzWdN.zzYvr(zzcw2);
        if (zzWdN2.zzZQM() == 1) {
            int n = zzWdN2.zzYsb().zzWYT();
            if (n == -1) {
                throw new Exception(zzWBh.zzaQ("Cannot parse resulted tokens: {0}", new Object[]{zzWdN2.zzYsb().getMessage()}));
            }
            zzXs72.zzYl6("Please summarize the following text. The result must be in the same language in which this text is written.");
            double d = (double)this.getContextWindow() / (double)n;
            int n2 = (int)((double)string.length() * d);
            while (string.length() > n2) {
                int n3 = zzWcw.zzYl8(string, n2);
                if (n3 <= 0) {
                    throw new IllegalStateException("Cannot split by sentences. Please check ContextWindow");
                }
                zzYAy.zzXDk(arrayList, this.zzaQ(string.substring(0, n3 + 0), summarizeOptions));
                int n4 = n3;
                string = string.substring(n4, n4 + (string.length() - n3));
            }
            if (string.length() > 0) {
                zzYAy.zzXDk(arrayList, this.zzaQ(string, summarizeOptions));
            }
            return arrayList;
        }
        if (zzWdN2.zzZQM() != 0) {
            throw new Exception(zzWdN2.zzYsb().getMessage());
        }
        zzYAy.zzXDk(arrayList, zzWdN2);
        return arrayList;
    }

    private void zzaQ(Run run, int n) throws Exception {
        if (zzW3g.zzOu(run.getText()) == -1) {
            return;
        }
        String string = zzWBh.zzX6U(this.zzXDk(run.getText(), n, null), "\r\n".toCharArray());
        if ("CanNotTranslate!".equals(string)) {
            return;
        }
        run.setText(string);
    }

    private String zzXDk(String string, int n, ArrayList<zzWRk> arrayList) throws Exception {
        ArrayList<zzWdN> arrayList2 = this.zzaQ(string, n, arrayList);
        String string2 = OpenAiModel.zzYG8(arrayList2);
        return zzcw.zzYCs(string2);
    }

    private ArrayList<zzWdN> zzaQ(String string, int n, ArrayList<zzWRk> arrayList) throws Exception {
        String string2;
        ArrayList<zzWdN> arrayList2 = new ArrayList<zzWdN>();
        ArrayList<zzWRk> arrayList3 = new ArrayList<zzWRk>();
        if (arrayList != null) {
            zzYAy.zzXDk(arrayList3, arrayList);
        }
        zzYAy.zzXDk(arrayList3, new zztZ(zzWBh.zzaQ("I will send you a text in any language and you will translate it to {0}.", new Object[]{Language.toString(n)})));
        zzYAy.zzXDk(arrayList3, new zztZ("If provided text can not be translated, then respond only: CanNotTranslate!"));
        zzYAy.zzXDk(arrayList3, new zztZ("Always preserve all punctuations, digits and whitespace characters, even at the very start, middle or end of words."));
        ArrayList<zzWRk> arrayList4 = OpenAiModel.zzY62(string, 0x100000);
        zzYAy.zzXDk(arrayList3, arrayList4);
        double d = this.zzWy5;
        try {
            this.zzWy5 = 0.3;
            string2 = this.zzWE0(arrayList3, 1);
        }
        finally {
            this.zzWy5 = d;
        }
        zzcw zzcw2 = new zzcw(string2);
        zzWdN zzWdN2 = zzWdN.zzYvr(zzcw2);
        if (zzWdN2.zzZQM() == 1) {
            int n2 = zzWdN2.zzYsb().zzWYT();
            if (n2 == -1) {
                throw new Exception(zzWBh.zzaQ("Cannot parse resulted tokens: {0}", new Object[]{zzWdN2.zzYsb().getMessage()}));
            }
            double d2 = (double)this.getContextWindow() / (double)n2;
            int n3 = (int)((double)string.length() * d2);
            while (string.length() > n3) {
                int n4 = zzWcw.zzYl8(string, n3);
                if (n4 <= 0) {
                    throw new IllegalStateException("Cannot split by sentences. Please check ContextWindow");
                }
                zzYAy.zzXDk(arrayList2, this.zzaQ(string.substring(0, n4 + 0), n, arrayList));
                int n5 = n4;
                string = string.substring(n5, n5 + (string.length() - n4));
            }
            if (string.length() > 0) {
                zzYAy.zzXDk(arrayList2, this.zzaQ(string, n, arrayList));
            }
            return arrayList2;
        }
        if (zzWdN2.zzZQM() != 0) {
            throw new Exception(zzWdN2.zzYsb().getMessage());
        }
        zzYAy.zzXDk(arrayList2, zzWdN2);
        return arrayList2;
    }

    @Override
    final String zzXDk(String string, CheckGrammarOptions checkGrammarOptions) throws Exception {
        ArrayList<zzWdN> arrayList = this.zzaQ(string, checkGrammarOptions);
        String string2 = OpenAiModel.zzYG8(arrayList);
        return zzcw.zzYCs(string2);
    }

    private ArrayList<zzWdN> zzaQ(String string, CheckGrammarOptions checkGrammarOptions) throws Exception {
        ArrayList<zzWdN> arrayList = new ArrayList<zzWdN>();
        ArrayList<zzWRk> arrayList2 = this.zzWew(checkGrammarOptions);
        ArrayList<zzWRk> arrayList3 = OpenAiModel.zzY62(string, 0x100000);
        zzYAy.zzXDk(arrayList2, arrayList3);
        String string2 = this.zzWE0(arrayList2, 1);
        zzcw zzcw2 = new zzcw(string2);
        zzWdN zzWdN2 = zzWdN.zzYvr(zzcw2);
        if (zzWdN2.zzZQM() == 1) {
            int n = zzWdN2.zzYsb().zzWYT();
            if (n == -1) {
                throw new Exception(zzWBh.zzaQ("Cannot parse resulted tokens: {0}", new Object[]{zzWdN2.zzYsb().getMessage()}));
            }
            double d = (double)this.getContextWindow() / (double)n;
            int n2 = (int)((double)string.length() * d);
            while (string.length() > n2) {
                int n3 = zzWcw.zzYl8(string, n2);
                if (n3 <= 0) {
                    throw new IllegalStateException("Cannot split by sentences. Please check ContextWindow");
                }
                zzYAy.zzXDk(arrayList, this.zzaQ(string.substring(0, n3 + 0), checkGrammarOptions));
                int n4 = n3;
                string = string.substring(n4, n4 + (string.length() - n3));
            }
            if (string.length() > 0) {
                zzYAy.zzXDk(arrayList, this.zzaQ(string, checkGrammarOptions));
            }
            return arrayList;
        }
        if (zzWdN2.zzZQM() != 0) {
            throw new Exception(zzWdN2.zzYsb().getMessage());
        }
        zzYAy.zzXDk(arrayList, zzWdN2);
        return arrayList;
    }

    private static ArrayList<zzWRk> zzY62(String string, int n) {
        zzWJv.zzX6U(n, "MaxStringLength");
        ArrayList<zzWRk> arrayList = new ArrayList<zzWRk>();
        String string2 = string;
        while (string2.length() > n) {
            zzYAy.zzXDk(arrayList, new zzXs7(string2.substring(0, n + 0)));
            int n2 = n;
            string2 = string2.substring(n2, n2 + (string2.length() - n));
        }
        zzYAy.zzXDk(arrayList, new zzXs7(string2));
        return arrayList;
    }

    private static String zzYG8(ArrayList<zzWdN> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (zzWdN zzWdN2 : arrayList) {
            for (String string : zzWdN2.zzXmy()) {
                zzWJv.zzaQ(stringBuilder, string);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected String getUrl() {
        return "https://api.openai.com/";
    }

    @Override
    final String zzWKU() {
        return "v1/chat/completions";
    }

    @Override
    final String zzWJa() {
        return "";
    }

    @Override
    final zzXsN zzWeK() {
        zzXsN zzXsN2 = new zzXsN();
        zzXsN2.add("Authorization", zzWBh.zzaQ("Bearer {0}", new Object[]{this.zzXc()}));
        OpenAiModel openAiModel = this;
        if (zzW3g.zzWFs(openAiModel.zzZOW)) {
            openAiModel = this;
            zzXsN2.add("OpenAI-Organization", openAiModel.zzZOW);
        }
        openAiModel = this;
        if (zzW3g.zzWFs(openAiModel.zzYa7)) {
            openAiModel = this;
            zzXsN2.add("OpenAI-Project", openAiModel.zzYa7);
        }
        return zzXsN2;
    }

    protected int getContextWindow() {
        return 16385;
    }

    protected int getMaxOutputTokens() {
        return 4096;
    }
}

