/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzYAy;
import com.aspose.words.zzXUC;
import com.aspose.words.zzXnA;
import com.aspose.words.zzY5W;
import com.aspose.words.zzYAH;
import com.aspose.words.zzZXT;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzZXT,
Iterable<T> {
    private Node zzYEp;
    private CompositeNode zzY7G;
    private DocumentBase zzWU6;
    private boolean zzZXM;
    private int zzW6m;
    private int zzSC;
    private Node zzWBw;
    private int zzZBy;
    private zzYAH zzXu0;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzY5W.zzYQB(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzY5W(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzYAH matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: container");
        }
        if (matcher == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: matcher");
        }
        this.zzY7G = container;
        this.zzWU6 = container.getDocument();
        this.zzXu0 = matcher;
        this.zzZXM = isDeep;
        this.zzYxS();
    }

    public Node get(int index) {
        try {
            this.zzWep();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzSC == index) {
                return this.zzWBw;
            }
            int n = index - this.zzSC;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzZqk(nodeCollection.zzWBw, n);
            if (node != null) {
                this.zzSC = index;
                this.zzWBw = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzZXM) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzY7G.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzZXM) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzY7G.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzZcF();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXnA(this);
    }

    final <TNode extends Node> zzXnA<TNode> zzWiZ() {
        return new zzXnA(this);
    }

    final ArrayList<Node> zzTf() {
        return this.zzZcF();
    }

    final <TValue extends Node> ArrayList<TValue> zzZcF() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzYAy.zzXDk(arrayList, node);
        }
        return arrayList;
    }

    private Node zzZqk(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzZVZ(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzYvZ(curNode, true);
    }

    private Node zzYvZ(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzYEp = node;
        do {
            boolean bl2;
            node2 = this.zzYEp;
            boolean bl3 = bl2 = zzXUC.zzaF(this.zzY7G.getNodeType()) && this.zzXu0.zzY6s();
            Node node3 = this.zzZXM ? this.zzXDk(true, this.zzYEp) : (this.zzYEp = bl2 ? this.zzWew(true, this.zzYEp) : this.zzaQ(true, this.zzYEp));
        } while (this.zzYEp != null && !this.zzXu0.zzXDk(this.zzYEp));
        return node2;
    }

    private Node zzZVZ(Node node, boolean bl) throws Exception {
        while ((this.zzZXM ? this.zzXDk(bl, node) : (node = this.zzXu0.zzY6s() ? this.zzWew(bl, node) : this.zzaQ(bl, node))) != null && !this.zzXu0.zzXDk(node)) {
        }
        return node;
    }

    private Node zzXDk(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzY7G);
        }
        return node.previousPreOrder(this.zzY7G);
    }

    private Node zzaQ(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzY7G) {
                return this.zzY7G.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzY7G) {
            return this.zzY7G.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzWew(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzY7G ? this.zzY7G.zzXD4() : node.zzWRD();
        } else {
            Node node3 = node2 = node == this.zzY7G ? this.zzY7G.zzZPH() : node.zzZyP();
        }
        if (node2 == this.zzY7G.getNextSibling() || node2 == this.zzY7G.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzWep() {
        if (this.zzW6m != this.zz1h()) {
            this.zzYxS();
        }
    }

    private void zzYxS() {
        this.zzW6m = this.zz1h();
        this.zzSC = -1;
        this.zzWBw = this.zzY7G;
        this.zzZBy = -1;
    }

    private int zz1h() {
        if (this.zzWU6 != null) {
            return this.zzWU6.zzQW();
        }
        return 0;
    }

    public int getCount() {
        this.zzWep();
        if (this.zzZBy == -1) {
            this.zzZBy = zzXnA.zzXDk(this);
        }
        return this.zzZBy;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzYEp;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzY7G;
    }
}

