/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzWBh;
import com.aspose.words.internal.zzWJv;
import com.aspose.words.internal.zzZIw;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzVSo;
import com.aspose.words.zzXUC;
import com.aspose.words.zzXlZ;
import com.aspose.words.zzYAn;
import com.aspose.words.zzYC9;
import com.aspose.words.zzbb;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzWEg;
    private Node zzZq9;
    private Node zzYet;
    private int zzY3w;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzWew(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzWEg == null) {
            return null;
        }
        if (this.zzWEg.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzWEg;
    }

    final CompositeNode zzYa4() {
        if (zzXUC.zzYVZ(this.getParentNode())) {
            return this.getParentNode().zzYa4();
        }
        return this.getParentNode();
    }

    final CompositeNode zzLM() {
        if (zzXUC.zzYVZ(this.getParentNode()) || zzXUC.zzD(this.getParentNode())) {
            return this.getParentNode().zzLM();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzWEg != null) {
            return this.zzWEg.getDocument();
        }
        return null;
    }

    final Document zzx() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzkn() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzW5L();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzYet;
    }

    final Node zzoc() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzXUC.zzXK((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzZyP() {
        Node node = zzXUC.zzXFB(this.getPreviousSibling(), false);
        if (node == null && zzXUC.zzYVZ(this.getParentNode())) {
            node = this.getParentNode().zzZyP();
        }
        return node;
    }

    final Node zzWRD() {
        Node node = zzXUC.zzYAx(this.getNextSibling(), false);
        if (node == null && zzXUC.zzYVZ(this.getParentNode())) {
            node = this.getParentNode().zzWRD();
        }
        return node;
    }

    final CompositeNode zzWv6() {
        Node node = this;
        while ((node = node.zzZyP()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzXWD() {
        Node node = this;
        while ((node = node.zzWRD()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzZq9;
    }

    final Node zzZcn() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzXUC.zzXK((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzW9b() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzYF8() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzX0m() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzXUC.zzVVw(node)) continue;
            return false;
        }
        return true;
    }

    final boolean zzYbp() {
        for (Node node = this.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (zzXUC.zzVVw(node)) continue;
            return false;
        }
        return true;
    }

    final Node zz1A() {
        return this.zzZq9;
    }

    final void zzBv(Node node) {
        this.zzZq9 = node;
    }

    final Node zz3y() {
        return this.zzYet;
    }

    final void zzQm(Node node) {
        this.zzYet = node;
    }

    final Node zzWGl() {
        Node node = this;
        if (node.zzZq9 != null) {
            node = this;
            return node.zzZq9;
        }
        return this.getParentNode();
    }

    final int zzY7K() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzXUC.zz3b(this);
        boolean bl2 = zzXUC.zzYXi(this);
        boolean bl3 = zzXUC.zzZVN(this);
        boolean bl4 = zzXUC.zzZBV(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzY7K() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzY7K() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzXDk(isCloneChildren, new zzXDk(this));
    }

    Node zzXDk(boolean bl, zzYAn zzYAn2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzWEg != null) {
            node.zzWEg = this.getDocument().zzY7I();
        }
        node.zzZq9 = null;
        node.zzYet = null;
        if (zzYAn2 != null) {
            zzYAn2.zzX6U(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzXzs(StringBuilder stringBuilder) {
        zzWJv.zzaQ(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    final zzXlZ zzW9z() {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            zzXlZ zzXlZ2 = zzWJv.zzXDk((Object)compositeNode, zzXlZ.class);
            if (zzXlZ2 == null) continue;
            return zzXlZ2;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzYfb(Node node) {
        this.zzWEg = node != null ? node : this.getDocument().zzY7I();
    }

    final void zzWew(DocumentBase documentBase) {
        this.zzWEg = documentBase != null ? documentBase.zzY7I() : null;
    }

    final boolean zzVX(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzZdX() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzYoI(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzXHL(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzZuV(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzWII(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzYDH(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    final Node zzY5E(Node node) {
        return this.getParentNode().insertAfter(node, this);
    }

    final void zzZ54(Node node, Node node2) {
        this.getParentNode().zzaQ(node, node2, this);
    }

    final Node zzYni(Node node) {
        return this.getParentNode().insertBefore(node, this);
    }

    final void zzZsp(Node node, Node node2) {
        this.getParentNode().zzXDk(node, node2, this);
    }

    public String toString(int saveFormat) throws Exception {
        zzbb zzbb2 = zzXUC.zzYg4(saveFormat);
        return zzbb2.zzXGP(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzbb zzbb2 = zzXUC.zzaQ(saveOptions);
        return zzbb2.zzXGP(this);
    }

    final Node zzWYv(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzXUC.zzZO3(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzYC9 zzWGz() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzYC9.zzYvZ(node);
        }
        return zzYC9.zzVZ0(this.getParentNode());
    }

    final zzYC9 zzZI4() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzYC9.zzVZ0(node);
        }
        return zzYC9.zzYvZ(this.getParentNode());
    }

    final boolean zzYy9(Node node) {
        return Node.zzVZ0(this, node);
    }

    final boolean zzYv8() {
        return this.getAncestor(1) == null;
    }

    static Node zzZay(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzZIw<Node> zzZIw2 = Node.zzZjB(node);
        zzZIw<Node> zzZIw3 = Node.zzZjB(node2);
        return Node.zzXDk(zzZIw2, zzZIw3);
    }

    static boolean zzVZ0(Node node, Node node2) {
        zzZIw<Node> zzZIw2;
        if (node == null || node2 == null) {
            return false;
        }
        zzZIw<Node> zzZIw3 = Node.zzZjB(node);
        Node node3 = Node.zzXDk(zzZIw3, zzZIw2 = Node.zzZjB(node2));
        if (node3 == null) {
            return false;
        }
        zzZIw<Node> zzZIw4 = zzZIw3;
        if (zzZIw4.size() == 0 || (zzZIw4 = zzZIw2).size() == 0) {
            zzZIw4 = zzZIw2;
            boolean bl = zzZIw4.size() > 0;
            return bl;
        }
        Object e = zzZIw3.peek();
        Object e2 = zzZIw2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes(0, false)) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzZIw<Node> zzZjB(Node node) {
        zzZIw<Node> zzZIw2 = new zzZIw<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzZIw2.push(node2);
        }
        return zzZIw2;
    }

    private static Node zzXDk(zzZIw<Node> zzZIw2, zzZIw<Node> zzZIw3) {
        Node node = null;
        while (zzZIw2.peek() == zzZIw3.peek()) {
            node = (Node)zzZIw2.pop();
            zzZIw3.pop();
            zzZIw<Node> zzZIw4 = zzZIw2;
            if (zzZIw4.size() != 0 && (zzZIw4 = zzZIw3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzY3w;
    }

    public void setCustomNodeId(int value) {
        this.zzY3w = value;
    }

    private String zzIp() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzWJv.zzXDk(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzWBh.zzYZb(stringBuilder.toString());
    }

    public String toString() {
        return zzWBh.zzYZb(zzWBh.zzaQ("{0} {1}", new Object[]{Node.nodeTypeToString(this.getNodeType()), this.zzIp()}));
    }

    final Node zzgb(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzXF0(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    private boolean zzXF0(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzXDk
    implements zzYAn {
        private Node zzWDe;
        private HashMap<Integer, Integer> zzYmj;

        zzXDk(Node node) {
            this.zzWDe = node;
        }

        @Override
        public final void zzX6U(Node node, Node node2) {
            if (node == this.zzWDe) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzVSo zzVSo2 = (zzVSo)((Object)node2);
            if (this.zzYmj == null) {
                this.zzYmj = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzWJv.zzXDk(this.zzYmj, Integer.valueOf(zzVSo2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzXmZ();
                zzWJv.zzaQ(this.zzYmj, Integer.valueOf(zzVSo2.getIdInternal()), Integer.valueOf(n));
            }
            zzVSo2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzWJv.zzXDk(this.zzYmj, Integer.valueOf(zzVSo2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzVSo2.setParentIdInternal(n2);
            }
        }
    }
}

