/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.LoadOptions;
import com.aspose.words.MergerContext;
import com.aspose.words.Processor;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zz3u;
import com.aspose.words.internal.zzYo1;
import com.aspose.words.zzWwz;
import com.aspose.words.zzXUC;
import com.aspose.words.zzwr;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class Merger
extends Processor {
    private MergerContext zzYoX;

    private Merger(MergerContext context) {
        super(context);
        this.zzYoX = context;
    }

    public static Merger create() {
        return Merger.create(new MergerContext());
    }

    public static Merger create(MergerContext context) {
        return new Merger(context);
    }

    @Override
    protected void executeCore() throws Exception {
        Document[] documentArray = new Document[this.zzXOw().size()];
        for (int i = 0; i < this.zzXOw().size(); ++i) {
            documentArray[i] = this.zzXOw().get(i).zzZ8u();
        }
        this.mResultDocument = Merger.zzXDk(documentArray, this.zzYoX.getMergeFormatMode());
        super.executeCore();
    }

    public static void merge(String outputFile, String[] inputFiles) throws Exception {
        Merger.merge(outputFile, inputFiles, FileFormatUtil.extensionToSaveFormat(zz3u.zzZ3C(outputFile)), 1);
    }

    public static void merge(String outputFile, String[] inputFiles, int saveFormat, int mergeFormatMode) throws Exception {
        Merger.merge(outputFile, inputFiles, zzXUC.zzX1p(saveFormat, outputFile), mergeFormatMode);
    }

    public static void merge(String outputFile, String[] inputFiles, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        Merger.merge(outputFile, inputFiles, null, saveOptions, mergeFormatMode);
    }

    public static void merge(String outputFile, String[] inputFiles, LoadOptions[] loadOptions, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        if (loadOptions != null && inputFiles.length != loadOptions.length) {
            throw new IllegalArgumentException("Arrays of input files and load options must be of the same dimension.");
        }
        MergerContext mergerContext = new MergerContext();
        mergerContext.setMergeFormatMode(mergeFormatMode);
        Merger merger = Merger.create(mergerContext);
        for (int i = 0; i < inputFiles.length; ++i) {
            merger.from(inputFiles[i], loadOptions != null ? loadOptions[i] : null);
        }
        merger.to(outputFile, saveOptions).execute();
    }

    public static Document merge(String[] inputFiles, int mergeFormatMode) throws Exception {
        return Merger.merge(inputFiles, null, mergeFormatMode);
    }

    public static Document merge(String[] inputFiles, LoadOptions[] loadOptions, int mergeFormatMode) throws Exception {
        if (loadOptions != null && inputFiles.length != loadOptions.length) {
            throw new IllegalArgumentException("Arrays of input files and load options must be of the same dimension.");
        }
        Document[] documentArray = new Document[inputFiles.length];
        for (int i = 0; i < inputFiles.length; ++i) {
            documentArray[i] = new Document(inputFiles[i], loadOptions != null ? loadOptions[i] : null);
        }
        return Merger.zzXDk(documentArray, mergeFormatMode);
    }

    public static Document merge(Document[] inputDocuments, int mergeFormatMode) throws Exception {
        return Merger.zzXDk(inputDocuments, mergeFormatMode);
    }

    private static void zzXDk(zzYo1 zzYo12, zzYo1[] zzYo1Array, int n) throws Exception {
        Merger.zzXDk(zzYo12, zzYo1Array, zzXUC.zzX1p(n, null), 1);
    }

    public static void merge(OutputStream outputStream, InputStream[] inputStreams, int saveFormat) throws Exception {
        Merger.zzXDk(zzYo1.zzWew(outputStream), zzYo1.zzXDk(inputStreams), saveFormat);
    }

    private static void zzXDk(zzYo1 zzYo12, zzYo1[] zzYo1Array, SaveOptions saveOptions, int n) throws Exception {
        Merger.zzXDk(zzYo12, zzYo1Array, null, saveOptions, n);
    }

    public static void merge(OutputStream outputStream, InputStream[] inputStreams, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        Merger.zzXDk(zzYo1.zzWew(outputStream), zzYo1.zzXDk(inputStreams), saveOptions, mergeFormatMode);
    }

    private static void zzXDk(zzYo1 zzYo12, zzYo1[] zzYo1Array, LoadOptions[] loadOptionsArray, SaveOptions saveOptions, int n) throws Exception {
        Merger.zzaQ(zzYo12, zzYo1Array, loadOptionsArray, saveOptions, n);
    }

    public static void merge(OutputStream outputStream, InputStream[] inputStreams, LoadOptions[] loadOptions, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        Merger.zzXDk(zzYo1.zzWew(outputStream), zzYo1.zzXDk(inputStreams), loadOptions, saveOptions, mergeFormatMode);
    }

    private static Document zzXDk(zzYo1[] zzYo1Array, int n) throws Exception {
        int n2 = n;
        LoadOptions[] loadOptionsArray = null;
        zzYo1[] zzYo1Array2 = zzYo1Array;
        return Merger.zzXDk(zzYo1Array, loadOptionsArray, n2);
    }

    public static Document merge(InputStream[] inputStreams, int mergeFormatMode) throws Exception {
        return Merger.zzXDk(zzYo1.zzXDk(inputStreams), mergeFormatMode);
    }

    public static Document merge(InputStream[] inputStreams, LoadOptions[] loadOptions, int mergeFormatMode) throws Exception {
        int n = mergeFormatMode;
        LoadOptions[] loadOptionsArray = loadOptions;
        zzYo1[] zzYo1Array = zzYo1.zzXDk(inputStreams);
        return Merger.zzXDk(zzYo1Array, loadOptionsArray, n);
    }

    private static zzYo1[] zzXDk(String[] stringArray, ImageSaveOptions imageSaveOptions, int n) throws Exception {
        MergerContext mergerContext = new MergerContext();
        mergerContext.setMergeFormatMode(n);
        Merger merger = Merger.create(mergerContext);
        for (int i = 0; i < stringArray.length; ++i) {
            merger.from(stringArray[i]);
        }
        ArrayList<zzYo1> arrayList = new ArrayList<zzYo1>();
        merger.to(arrayList, (SaveOptions)imageSaveOptions).execute();
        zzYo1[] zzYo1Array = new zzYo1[]{};
        ArrayList<zzYo1> arrayList2 = arrayList;
        return arrayList2.toArray(zzYo1Array);
    }

    public static InputStream[] mergeToImages(String[] inputFiles, ImageSaveOptions saveOptions, int mergeFormatMode) throws Exception {
        return zzYo1.zzXDk(Merger.zzXDk(inputFiles, saveOptions, mergeFormatMode));
    }

    private static zzYo1[] zzXDk(zzYo1[] zzYo1Array, ImageSaveOptions imageSaveOptions, int n) throws Exception {
        Object object;
        zzYo1[] zzYo1Array2;
        MergerContext mergerContext = new MergerContext();
        mergerContext.setMergeFormatMode(n);
        Merger merger = Merger.create(mergerContext);
        for (int i = 0; i < zzYo1Array.length; ++i) {
            zzYo1Array2 = zzYo1Array[i];
            object = merger;
            ((Processor)object).zzWew((zzYo1)zzYo1Array2, null);
        }
        ArrayList<zzYo1> arrayList = new ArrayList<zzYo1>();
        merger.to(arrayList, (SaveOptions)imageSaveOptions).execute();
        zzYo1Array2 = new zzYo1[]{};
        object = arrayList;
        return ((ArrayList)object).toArray(zzYo1Array2);
    }

    public static InputStream[] mergeToImages(InputStream[] inputStreams, ImageSaveOptions saveOptions, int mergeFormatMode) throws Exception {
        return zzYo1.zzXDk(Merger.zzXDk(zzYo1.zzXDk(inputStreams), saveOptions, mergeFormatMode));
    }

    private static Document zzXDk(Document[] documentArray, int n) throws Exception {
        if (documentArray == null || documentArray.length == 0) {
            return null;
        }
        Document document = documentArray[0].deepClone();
        for (int i = 1; i < documentArray.length; ++i) {
            if (n == 2) {
                Document[] documentArray2 = new Document[]{documentArray[i]};
                Document document2 = document;
                zzwr.zzXDk(document2, documentArray2);
                continue;
            }
            document.appendDocument(documentArray[i], Merger.zzYAj(n));
        }
        return document;
    }

    private static void zzaQ(zzYo1 zzYo12, zzYo1[] zzYo1Array, LoadOptions[] loadOptionsArray, SaveOptions saveOptions, int n) throws Exception {
        if (loadOptionsArray != null && zzYo1Array.length != loadOptionsArray.length) {
            throw new IllegalArgumentException("Arrays of input streams and load options must be of the same dimension.");
        }
        MergerContext mergerContext = new MergerContext();
        mergerContext.setMergeFormatMode(n);
        Merger merger = Merger.create(mergerContext);
        for (int i = 0; i < zzYo1Array.length; ++i) {
            merger.zzWew(zzYo1Array[i], loadOptionsArray != null ? loadOptionsArray[i] : null);
        }
        merger.zzaQ(zzYo12, saveOptions).execute();
    }

    private static Document zzXDk(zzYo1[] zzYo1Array, LoadOptions[] loadOptionsArray, int n) throws Exception {
        if (loadOptionsArray != null && zzYo1Array.length != loadOptionsArray.length) {
            throw new IllegalArgumentException("Arrays of input streams and load options must be of the same dimension.");
        }
        Document[] documentArray = new Document[zzYo1Array.length];
        for (int i = 0; i < zzYo1Array.length; ++i) {
            zzWwz zzWwz2 = new zzWwz(zzYo1Array[i], loadOptionsArray != null ? loadOptionsArray[i] : null, null);
            documentArray[i] = zzWwz2.zzZ8u();
        }
        return Merger.zzXDk(documentArray, n);
    }

    private static int zzYAj(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 1;
    }
}

