/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzW3g;
import com.aspose.words.internal.zzWJv;
import com.aspose.words.internal.zzWZ9;
import com.aspose.words.internal.zzWzI;
import com.aspose.words.internal.zzYAy;
import com.aspose.words.internal.zzYo1;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzYSE;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzXUm = new HashMap();
    private static HashMap<Integer, Integer> zzZDO = new HashMap();
    private static HashMap<Integer, Integer> zz0v = new HashMap();
    private static HashMap<Integer, Integer> zzWmF = new HashMap();
    private static HashMap<Integer, Integer> zzYYk = new HashMap();
    private static HashMap<Integer, Integer> zzv2 = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzWJv.zzVVE(fileName, "fileName");
        try (zzWzI zzWzI2 = zzWJv.zzXNB(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzYSF(zzWzI2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzYSF(zzYAy.zzXDk(stream));
    }

    static FileFormatInfo zzYSF(zzYo1 zzYo12) throws Exception {
        if (zzYo12 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        try {
            zzYSE zzYSE2 = new zzYSE();
            zzYo1 zzYo13 = zzYo12;
            zzYSE zzYSE3 = zzYSE2;
            return zzYSE2.zzaQ(zzYo13, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzWew(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzXEH(zzWZ9.zz3b(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzY3F(zzWZ9.zz3b(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzW3g.zzWFs(string = zzWZ9.zzZ2T(FileFormatUtil.zzVM(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzXEH(FileFormatUtil.zzvT(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzY3F(FileFormatUtil.zzVM(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzWZ9.zzZ2T(FileFormatUtil.zzvT(saveFormat));
        if (zzW3g.zzWFs(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: extension");
        }
        return FileFormatUtil.zzY3F(zzWZ9.zzZlN(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzWZ9.zzZ2T(FileFormatUtil.zzIS(imageType));
    }

    static Exception zzWew(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static boolean zzZm0(int n) {
        return n == 50;
    }

    static String zzX1D(int n) {
        return zzWZ9.toString(FileFormatUtil.zzvT(n));
    }

    static int zzY3F(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzWJv.zzXDk(zzYYk, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzdt(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzWJv.zzXDk(zzv2, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzhG(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    static boolean zzYAk(int n) {
        return n == 40 || n == 107 || n == 103 || n == 100 || n == 101 || n == 102 || n == 104 || n == 44 || n == 105 || n == 106 || n == 41 || n == 48 || n == 46 || n == 45;
    }

    static boolean zzXNE(int n) {
        return n == 103 || n == 107 || n == 100 || n == 101 || n == 102 || n == 104 || n == 44 || n == 105 || n == 106;
    }

    static int zzVM(int n) {
        return zzWJv.zzXDk(zzXUm, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzvT(int n) {
        return zzWJv.zzXDk(zzZDO, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzIS(int n) {
        return zzWJv.zzXDk(zz0v, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzXEH(int n) {
        return zzWJv.zzXDk(zzWmF, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzCL(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzWJv.zzaQ(zzYYk, Integer.valueOf(n), Integer.valueOf(n2));
            zzWJv.zzaQ(zzZDO, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzWmF.containsKey(n)) {
                zzWJv.zzaQ(zzWmF, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzWJv.zzaQ(zzXUm, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzWJv.zzaQ(zzv2, Integer.valueOf(n), Integer.valueOf(n4));
            zzWJv.zzaQ(zz0v, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzCL(13, 10, 10, 1);
        FileFormatUtil.zzCL(13, 0, 0, 1);
        FileFormatUtil.zzCL(14, 11, 11, 1);
        FileFormatUtil.zzCL(15, 20, 20, 1);
        FileFormatUtil.zzCL(15, 0, 254, 1);
        FileFormatUtil.zzCL(16, 21, 21, 1);
        FileFormatUtil.zzCL(17, 22, 22, 1);
        FileFormatUtil.zzCL(18, 23, 23, 1);
        FileFormatUtil.zzCL(20, 24, 24, 1);
        FileFormatUtil.zzCL(21, 25, 25, 1);
        FileFormatUtil.zzCL(22, 26, 26, 1);
        FileFormatUtil.zzCL(23, 27, 27, 1);
        FileFormatUtil.zzCL(26, 30, 30, 1);
        FileFormatUtil.zzCL(19, 31, 31, 1);
        FileFormatUtil.zzCL(27, 50, 50, 1);
        FileFormatUtil.zzCL(28, 45, 255, 1);
        FileFormatUtil.zzCL(29, 51, 51, 1);
        FileFormatUtil.zzCL(30, 54, 52, 1);
        FileFormatUtil.zzCL(31, 0, 53, 1);
        FileFormatUtil.zzCL(33, 53, 54, 1);
        FileFormatUtil.zzCL(24, 60, 60, 1);
        FileFormatUtil.zzCL(25, 61, 61, 1);
        FileFormatUtil.zzCL(36, 40, 64, 1);
        FileFormatUtil.zzCL(43, 47, 255, 1);
        FileFormatUtil.zzCL(44, 48, 255, 1);
        FileFormatUtil.zzCL(37, 41, 255, 1);
        FileFormatUtil.zzCL(38, 46, 255, 1);
        FileFormatUtil.zzCL(40, 42, 255, 1);
        FileFormatUtil.zzCL(39, 44, 255, 1);
        FileFormatUtil.zzCL(32, 52, 55, 1);
        FileFormatUtil.zzCL(34, 70, 62, 1);
        FileFormatUtil.zzCL(35, 73, 63, 1);
        FileFormatUtil.zzCL(41, 71, 255, 1);
        FileFormatUtil.zzCL(8, 100, 255, 1);
        FileFormatUtil.zzCL(9, 105, 255, 10);
        FileFormatUtil.zzCL(6, 101, 255, 6);
        FileFormatUtil.zzCL(7, 102, 255, 7);
        FileFormatUtil.zzCL(5, 104, 255, 5);
        FileFormatUtil.zzCL(4, 0, 255, 4);
        FileFormatUtil.zzCL(3, 0, 255, 3);
        FileFormatUtil.zzCL(42, 72, 255, 1);
        FileFormatUtil.zzCL(2, 103, 255, 2);
        FileFormatUtil.zzCL(10, 106, 255, 8);
        FileFormatUtil.zzCL(48, 80, 255, 1);
        FileFormatUtil.zzCL(11, 107, 255, 9);
        FileFormatUtil.zzCL(49, 0, 8, 1);
    }
}

