/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz6q;
import com.aspose.words.internal.zzWBh;
import com.aspose.words.internal.zzWJv;
import com.aspose.words.internal.zzWUa;
import com.aspose.words.internal.zzWzI;
import com.aspose.words.internal.zzY61;
import com.aspose.words.internal.zzYG8;
import com.aspose.words.internal.zzYZu;
import com.aspose.words.internal.zzYo1;
import com.aspose.words.internal.zzYpd;
import com.aspose.words.internal.zzZZ9;
import com.aspose.words.internal.zzkg;
import com.aspose.words.internal.zzrU;
import com.aspose.words.ref.Ref;
import com.aspose.words.zzWz2;
import com.aspose.words.zzXHO;
import com.aspose.words.zzXPc;
import com.aspose.words.zzXUC;
import com.aspose.words.zzXvU;
import com.aspose.words.zzY3j;
import com.aspose.words.zzY4Q;
import com.aspose.words.zzYSE;
import com.aspose.words.zzYjk;
import com.aspose.words.zzYpC;
import com.aspose.words.zzZLD;
import com.aspose.words.zzZuZ;
import com.aspose.words.zzqb;
import com.aspose.words.zzt5;
import com.aspose.words.zzwq;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private static final String zz3T = zzYpd.zzcd().zzY8E(new byte[]{105, 83, 110, 103, 110, 105, 32, 103, 101, 102, 116, 97, 114, 117, 32, 101, 115, 105, 110, 32, 116, 111, 115, 32, 112, 117, 111, 112, 116, 114, 100, 101, 98, 32, 32, 121, 104, 116, 115, 105, 102, 32, 108, 105, 32, 101, 111, 102, 109, 114, 116, 97, 46});

    private DigitalSignatureUtil() {
    }

    private static void zzXDk(zzYo1 zzYo12, zzYo1 zzYo13, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzWJv.zzaQ((Object)zzYo12, "srcStream");
        zzWJv.zzaQ((Object)zzYo13, "dstStream");
        zzWJv.zzaQ((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzaQ(zzYo12, zzYo13, certificateHolder, signOptions);
        zzYo13.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzXDk(zzYo1.zzaQ(srcStream), (zzYo1)zzYo1.zzWew(dstStream), certHolder, signOptions);
    }

    private static void zzaQ(zzYo1 zzYo12, zzYo1 zzYo13, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzWew(digitalSignature);
        }
        DigitalSignatureUtil.zzXDk(digitalSignature, signOptions);
        if (zzYSE.zzYhr(zzYo12)) {
            DigitalSignatureUtil.zzXDk(zzYo12, zzYo13, digitalSignature, true);
            return;
        }
        zzYSE zzYSE2 = new zzYSE();
        zzYo1 zzYo14 = zzYo12;
        zzYSE zzYSE3 = zzYSE2;
        FileFormatInfo fileFormatInfo = zzYSE2.zzaQ(zzYo14, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzrU zzrU2 = new zzrU(zzYo12);
                int n = fileFormatInfo.zzpp() == 1 ? 1 : 2;
                zzt5.zzXDk(zzrU2, digitalSignature, n);
                zzYo13.zzYT7(0L);
                zzrU2.zzX1p(zzYo13);
                return;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzXDk(fileFormatInfo.zzXcN(), zzYo13, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzXDk(zzYo12, zzYo13, digitalSignature, false);
                return;
            }
            case 60: 
            case 61: {
                DigitalSignatureUtil.zzXDk(zzYo12, zzYo13, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException(zz3T);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzWJv.zzVVE(srcFileName, "srcFileName");
        zzWJv.zzVVE(dstFileName, "dstFileName");
        try (zzWzI zzWzI2 = zzWJv.zzaQ(srcFileName, 3, 1);){
            try (zzWzI zzWzI3 = zzWJv.zzaQ(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzXDk((zzYo1)zzWzI2, (zzYo1)zzWzI3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzYZu zzYZu2 = zzYo1.zzWew(dstStream);
        zzYo1 zzYo12 = zzYo1.zzaQ(srcStream);
        DigitalSignatureUtil.zzXDk(zzYo12, (zzYo1)zzYZu2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzWzI zzWzI2 = zzWJv.zzaQ(srcFileName, 3, 1);){
            try (zzWzI zzWzI3 = zzWJv.zzaQ(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzYRf(zzWzI2, zzWzI3);
            }
            return;
        }
    }

    private static void zzYRf(zzYo1 zzYo12, zzYo1 zzYo13) throws Exception {
        zzYSE zzYSE2 = new zzYSE();
        zzYo1 zzYo14 = zzYo12;
        Object object = zzYSE2;
        FileFormatInfo fileFormatInfo = zzYSE2.zzaQ(zzYo14, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzrU zzrU2 = new zzrU(zzYo12);
                zzrU2.zzWuo().zz3b("_xmlsignatures");
                zzrU2.zzWuo().zz3b("_signatures");
                zzYo13.zzXDX(0L);
                zzrU2.zzX1p(zzYo13);
                zzYo1 zzYo15 = zzYo13;
                zzYo15.zzYT7(zzYo15.zzZyC());
                return;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                zzZZ9 zzZZ92 = new zzZZ9(zzYo12);
                zz6q zz6q2 = zzZZ92.zzXDk(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zz6q2 != null) {
                    for (zzkg zzkg2 : zz6q2.zzk9()) {
                        String string = zz6q2.zzXDk(zzkg2);
                        zzZZ92.zzYLC().remove(string);
                    }
                    zzZZ92.zzYLC().remove(zz6q2.getName());
                    zzkg zzkg3 = zzZZ92.zzk9().zzZb1("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzZZ92.zzk9().remove(zzkg3.getId());
                    zzZZ92.zzYY0();
                }
                zzYo13.zzXDX(0L);
                zzZZ92.zzX1p(zzYo13);
                zzYo1 zzYo16 = zzYo13;
                zzYo16.zzYT7(zzYo16.zzZyC());
                return;
            }
            case 60: 
            case 61: {
                zzYpC zzYpC2 = new zzYpC(zzYo12);
                zzXPc zzXPc2 = zzYpC2.zzWpp("/META-INF/documentsignatures.xml");
                if (zzXPc2 != null) {
                    zzYpC2.zzYhb().remove(zzXPc2.getName());
                }
                zzYo13.zzXDX(0L);
                String string = "application/vnd.oasis.opendocument.text";
                zzYo14 = zzYo13;
                object = zzYpC2;
                ((zzYpC)object).zzXDk(zzYo14, string, null);
                zzYo1 zzYo17 = zzYo13;
                zzYo17.zzYT7(zzYo17.zzZyC());
                return;
            }
        }
        throw new IllegalStateException(zz3T);
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzYRf(zzYo1.zzaQ(srcStream), zzYo1.zzWew(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzWzI zzWzI2 = zzWJv.zzaQ(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzYgP(zzWzI2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzYgP(zzYo1 zzYo12) throws Exception {
        if (zzYSE.zzYhr(zzYo12)) {
            return DigitalSignatureUtil.zzZFP(zzYo12);
        }
        zzYSE zzYSE2 = new zzYSE();
        zzYo1 zzYo13 = zzYo12;
        zzYSE zzYSE3 = zzYSE2;
        FileFormatInfo fileFormatInfo = zzYSE2.zzaQ(zzYo13, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 60: 
            case 61: {
                Document document = new Document(zzYo12, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException(zz3T);
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzYgP(zzYo1.zzaQ(stream));
    }

    static zzY61 zzXDk(zzrU zzrU2, String string) throws Exception {
        zzXHO zzXHO2 = new zzXHO(zzrU2);
        if (zzXHO2.zzZNe()) {
            zzY61 zzY612 = zzXHO2.zzZLV(string);
            return zzY612;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzuA(int n) {
        switch (n) {
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        return "http://www.w3.org/2000/09/xmldsig#sha1";
    }

    private static void zzXDk(zzYo1 zzYo12, zzYo1 zzYo13, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzZZ9 zzZZ92 = new zzZZ9(zzYo12);
        zzZuZ zzZuZ2 = bl ? new zzWz2(zzZZ92) : new zzqb(zzZZ92);
        zzZuZ2.zzaQ(digitalSignature);
        zzYo13.zzYT7(0L);
        zzZZ92.zzX1p(zzYo13);
    }

    private static void zzXDk(zzYo1 zzYo12, zzYo1 zzYo13, DigitalSignature digitalSignature) throws Exception {
        zzYpC zzYpC2 = new zzYpC(zzYo12);
        zzZLD zzZLD2 = new zzZLD(zzYpC2);
        zzZLD2.zzaQ(digitalSignature);
        zzYo13.zzYT7(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzYo1 zzYo14 = zzYo13;
        zzYpC zzYpC3 = zzYpC2;
        zzYpC3.zzXDk(zzYo14, string, null);
    }

    private static void zzXDk(zzrU zzrU2, zzYo1 zzYo12, DigitalSignature digitalSignature, String string) throws Exception {
        zzY61 zzY612 = DigitalSignatureUtil.zzXDk(zzrU2, string);
        zzY61 zzY613 = new zzY61();
        DigitalSignatureUtil.zzXDk((zzYo1)zzY612, (zzYo1)zzY613, digitalSignature, false);
        zzrU zzrU3 = zzXHO.zzX6U(zzY613, string);
        zzrU3.zzX1p(zzYo12);
    }

    private static DigitalSignatureCollection zzZFP(zzYo1 zzYo12) throws Exception {
        zzYo12.zzXDX(0L);
        zzZZ9 zzZZ92 = new zzZZ9(zzYo12);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zz6q zz6q2 = zzZZ92.zzXDk(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zz6q2 != null) {
            for (zzkg zzkg2 : zz6q2.zzk9()) {
                String string = zz6q2.zzXDk(zzkg2);
                zz6q zz6q3 = zzZZ92.zzYmi(string);
                zz6q zz6q4 = zzZZ92.zzXDk(zz6q3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzYG8 zzYG82 = zzWUa.zzXbU(zz6q4.zzYBm().zzZmZ());
                zzY4Q.zzXDk(zz6q3.zzZsB(), zzYG82, new zzYjk(zzZZ92), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }

    private static void zzXDk(DigitalSignature digitalSignature, SignOptions signOptions) {
        byte[] byArray = zzY3j.zzZ5i();
        if (byArray == zzwq.zz3d) {
            return;
        }
        if (byArray == zzwq.zzWIi && zzY3j.zzY7v(30)) {
            return;
        }
        Object t = null;
        Ref<Object> ref = new Ref<Object>(t);
        boolean bl = signOptions != null && zzXvU.zzXDk(signOptions.zzlq(), ref) == 2;
        ref.get();
        if (bl) {
            return;
        }
        String string = digitalSignature.getComments();
        if (!zzWBh.zzZYF(string, "")) {
            string = zzWBh.zzXqM(string, zzYpd.zzcd().zzY8E(new byte[]{10, 13}));
        }
        int[] nArray = new int[]{43, 25, 5, 9, 91, 21, 12, 29, 1, 1, 68, 42, 64, 24, 1, 90, 78, 44, 22, 0, 79, 0, 29, 16, 78, 24, 13, 17, 70, 84, 57, 7, 30, 0, 23, 0, 0, 35, 23, 6, 10, 28, 74, 69, 109, 27, 8, 13, 28, 6, 3, 13, 90, 84, 74, 68, 94, 92, 73, 87, 30, 70, 77, 84, 47, 28, 20, 10, 93, 17, 88, 36, 26, 22, 68, 41, 90, 16, 86, 41};
        string = zzWBh.zzXqM(string, zzXUC.zzWfn(nArray));
        digitalSignature.setComments(string);
    }
}

