/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ConverterContext;
import com.aspose.words.Document;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.LoadOptions;
import com.aspose.words.PageSet;
import com.aspose.words.Processor;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zz3u;
import com.aspose.words.internal.zzWJv;
import com.aspose.words.internal.zzWzI;
import com.aspose.words.internal.zzY61;
import com.aspose.words.internal.zzYAy;
import com.aspose.words.internal.zzYZu;
import com.aspose.words.internal.zzYo1;
import com.aspose.words.internal.zzYpd;
import com.aspose.words.internal.zzZIw;
import com.aspose.words.zzXUC;
import com.aspose.words.zzYsG;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class Converter
extends Processor {
    private static final String zzZ8r = zzYpd.zzcd().zzY8E(new byte[]{110, 65, 105, 32, 118, 110, 108, 97, 100, 105, 83, 32, 118, 97, 70, 101, 114, 111, 97, 109, 32, 116, 97, 119, 32, 115, 104, 99, 115, 111, 110, 101, 32, 46, 110, 79, 121, 108, 69, 32, 102, 109, 32, 44, 101, 87, 80, 98, 32, 44, 105, 84, 102, 102, 32, 44, 110, 80, 44, 103, 66, 32, 112, 109, 32, 44, 112, 74, 103, 101, 32, 44, 118, 83, 44, 103, 71, 32, 102, 105, 97, 32, 100, 110, 69, 32, 115, 112, 105, 32, 97, 109, 101, 103, 115, 32, 118, 97, 32, 101, 111, 102, 109, 114, 116, 97, 32, 115, 114, 97, 32, 101, 108, 97, 111, 108, 101, 119, 100});

    private Converter(ConverterContext context) {
        super(context);
    }

    public static Converter create() {
        return Converter.create(new ConverterContext());
    }

    public static Converter create(ConverterContext context) {
        return new Converter(context);
    }

    @Override
    protected void executeCore() throws Exception {
        zzZIw<zzYsG> zzZIw2;
        if (this.mResultDocument == null && ((zzZIw2 = this.zzYuW()).size() > 0 || (zzZIw2 = this.zzWi9()).size() > 0)) {
            this.mResultDocument = this.zzZRZ().zzZ8u();
        }
        super.executeCore();
    }

    public static void convert(String inputFile, String outputFile) throws Exception {
        String string = outputFile;
        Converter.convert(inputFile, string, FileFormatUtil.extensionToSaveFormat(zz3u.zzZ3C(string)));
    }

    public static void convert(String inputFile, String outputFile, int saveFormat) throws Exception {
        Converter.convert(inputFile, outputFile, zzXUC.zzX1p(saveFormat, outputFile));
    }

    public static void convert(String inputFile, String outputFile, SaveOptions saveOptions) throws Exception {
        Converter.convert(inputFile, null, outputFile, saveOptions);
    }

    public static void convert(String inputFile, LoadOptions loadOptions, String outputFile, SaveOptions saveOptions) throws Exception {
        Converter.create().from(inputFile, loadOptions).to(outputFile, saveOptions).execute();
    }

    private static void zzXDk(zzYo1 zzYo12, zzYo1 zzYo13, int n) throws Exception {
        SaveOptions saveOptions = zzXUC.zzX1p(n, null);
        zzYo1 zzYo14 = zzYo13;
        zzYo1 zzYo15 = zzYo12;
        Converter.zzXDk(zzYo15, null, zzYo14, saveOptions);
    }

    public static void convert(InputStream inputStream, OutputStream outputStream, int saveFormat) throws Exception {
        Converter.zzXDk(zzYo1.zzaQ(inputStream), zzYo1.zzWew(outputStream), saveFormat);
    }

    public static void convert(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions) throws Exception {
        SaveOptions saveOptions2 = saveOptions;
        zzYZu zzYZu2 = zzYo1.zzWew(outputStream);
        zzYo1 zzYo12 = zzYo1.zzaQ(inputStream);
        Converter.zzXDk(zzYo12, null, zzYZu2, saveOptions2);
    }

    private static void zzXDk(zzYo1 zzYo12, LoadOptions loadOptions, zzYo1 zzYo13, SaveOptions saveOptions) throws Exception {
        Converter.create().zzWew(zzYo12, loadOptions).zzaQ(zzYo13, saveOptions).execute();
    }

    public static void convert(InputStream inputStream, LoadOptions loadOptions, OutputStream outputStream, SaveOptions saveOptions) throws Exception {
        Converter.zzXDk(zzYo1.zzaQ(inputStream), loadOptions, zzYo1.zzWew(outputStream), saveOptions);
    }

    @Deprecated
    public static void convertToImages(String inputFile, String outputFile) throws Exception {
        int n = FileFormatUtil.extensionToSaveFormat(zz3u.zzZ3C(outputFile));
        Converter.convertToImages(inputFile, outputFile, n);
    }

    @Deprecated
    public static void convertToImages(String inputFile, String outputFile, int saveFormat) throws Exception {
        if (!FileFormatUtil.zzXNE(saveFormat)) {
            throw new IllegalArgumentException(zzZ8r);
        }
        Converter.convertToImages(inputFile, outputFile, new ImageSaveOptions(saveFormat));
    }

    @Deprecated
    public static void convertToImages(String inputFile, String outputFile, ImageSaveOptions saveOptions) throws Exception {
        Converter.convertToImages(inputFile, null, outputFile, saveOptions);
    }

    @Deprecated
    public static void convertToImages(String inputFile, LoadOptions loadOptions, String outputFile, ImageSaveOptions saveOptions) throws Exception {
        Converter.create().from(inputFile, loadOptions).to(outputFile, (SaveOptions)saveOptions).execute();
    }

    private static zzYo1[] zzXF0(String string, int n) throws Exception {
        if (!FileFormatUtil.zzXNE(n)) {
            throw new IllegalArgumentException(zzZ8r);
        }
        return Converter.zzXDk(string, new ImageSaveOptions(n));
    }

    public static OutputStream[] convertToImages(String inputFile, int saveFormat) throws Exception {
        return zzYo1.zzaQ(Converter.zzXF0(inputFile, saveFormat));
    }

    private static zzYo1[] zzXDk(String string, ImageSaveOptions imageSaveOptions) throws Exception {
        try (zzWzI zzWzI2 = zzWJv.zzXNB(string);){
            ImageSaveOptions imageSaveOptions2 = imageSaveOptions;
            zzWzI zzWzI3 = zzWzI2;
            zzYo1[] zzYo1Array = Converter.zzXDk((zzYo1)zzWzI3, null, imageSaveOptions2);
            return zzYo1Array;
        }
    }

    public static OutputStream[] convertToImages(String inputFile, ImageSaveOptions saveOptions) throws Exception {
        return zzYo1.zzaQ(Converter.zzXDk(inputFile, saveOptions));
    }

    private static zzYo1[] zzWcw(zzYo1 zzYo12, int n) throws Exception {
        if (!FileFormatUtil.zzXNE(n)) {
            throw new IllegalArgumentException(zzZ8r);
        }
        ImageSaveOptions imageSaveOptions = new ImageSaveOptions(n);
        zzYo1 zzYo13 = zzYo12;
        return Converter.zzXDk(zzYo13, null, imageSaveOptions);
    }

    public static OutputStream[] convertToImages(InputStream inputStream, int saveFormat) throws Exception {
        return zzYo1.zzaQ(Converter.zzWcw(zzYo1.zzaQ(inputStream), saveFormat));
    }

    public static OutputStream[] convertToImages(InputStream inputStream, ImageSaveOptions saveOptions) throws Exception {
        ImageSaveOptions imageSaveOptions = saveOptions;
        zzYo1 zzYo12 = zzYo1.zzaQ(inputStream);
        return zzYo1.zzaQ(Converter.zzXDk(zzYo12, null, imageSaveOptions));
    }

    private static zzYo1[] zzXDk(zzYo1 zzYo12, LoadOptions loadOptions, ImageSaveOptions imageSaveOptions) throws Exception {
        ArrayList<zzYo1> arrayList = new ArrayList<zzYo1>();
        Converter.create().zzWew(zzYo12, loadOptions).to(arrayList, (SaveOptions)imageSaveOptions).execute();
        zzYo1[] zzYo1Array = new zzYo1[]{};
        ArrayList<zzYo1> arrayList2 = arrayList;
        return arrayList2.toArray(zzYo1Array);
    }

    public static OutputStream[] convertToImages(InputStream inputStream, LoadOptions loadOptions, ImageSaveOptions saveOptions) throws Exception {
        return zzYo1.zzaQ(Converter.zzXDk(zzYo1.zzaQ(inputStream), loadOptions, saveOptions));
    }

    private static zzYo1[] zzaQ(Document document, int n) throws Exception {
        if (!FileFormatUtil.zzXNE(n)) {
            throw new IllegalArgumentException(zzZ8r);
        }
        return Converter.zzXDk(document, new ImageSaveOptions(n));
    }

    public static OutputStream[] convertToImages(Document doc, int saveFormat) throws Exception {
        return zzYo1.zzaQ(Converter.zzaQ(doc, saveFormat));
    }

    private static zzYo1[] zzXDk(Document document, ImageSaveOptions imageSaveOptions) throws Exception {
        int n;
        ArrayList arrayList = new ArrayList();
        Iterator<Integer> iterator = imageSaveOptions.getPageSet().iterator();
        while (iterator.hasNext() && (n = iterator.next().intValue()) < document.getPageCount()) {
            ImageSaveOptions imageSaveOptions2 = imageSaveOptions.deepClone();
            imageSaveOptions2.setPageSet(new PageSet(n));
            zzY61 zzY612 = new zzY61();
            document.zzXDk((zzYo1)zzY612, imageSaveOptions2);
            zzY612.zzXDX(0L);
            zzYAy.zzXDk(arrayList, zzY612);
        }
        zzYo1[] zzYo1Array = new zzYo1[]{};
        ArrayList arrayList2 = arrayList;
        return arrayList2.toArray(zzYo1Array);
    }

    public static OutputStream[] convertToImages(Document doc, ImageSaveOptions saveOptions) throws Exception {
        return zzYo1.zzaQ(Converter.zzXDk(doc, saveOptions));
    }
}

