/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CommentCollection;
import com.aspose.words.CommentRangeEnd;
import com.aspose.words.CommentRangeStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.InlineStory;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zzWJv;
import com.aspose.words.internal.zzWc5;
import com.aspose.words.internal.zzYAy;
import com.aspose.words.zzVSo;
import com.aspose.words.zzW8u;
import com.aspose.words.zzWcl;
import com.aspose.words.zzXpG;
import com.aspose.words.zzYfb;
import com.aspose.words.zzZrc;
import com.aspose.words.zznp;
import java.util.ArrayList;
import java.util.Date;

public final class Comment
extends InlineStory
implements zzVSo,
zzWcl {
    private zzXpG zzZ4c;
    private int zzVRH;
    private boolean zzWKj;
    private boolean zzY0r;
    private int zzJS;
    private int zzCB = -1;
    private String zzZsA = "";
    private String zzZ8w = "";
    private zzWc5 zzWg1 = zzWc5.zzXlR;
    private zzWc5 zzYji = zzWc5.zzXlR;
    private CommentCollection zzWED;

    Comment(DocumentBase doc, zzZrc runPr) {
        super(doc, runPr);
        this.zzJS = doc.zzXmZ();
    }

    public Comment(DocumentBase doc) {
        this(doc, "", "", zzWc5.zzXlR);
    }

    private Comment(DocumentBase doc, String author, String initial, zzWc5 dateTime) {
        this(doc, new zzZrc());
        this.setAuthor(author);
        this.setInitial(initial);
        zzWc5 zzWc52 = dateTime;
        Comment comment = this;
        this.zzWg1 = zzWc52;
        this.getFont().setStyleIdentifier(39);
    }

    public Comment(DocumentBase doc, String author, String initial, Date dateTime) {
        this(doc, author, initial, zzWc5.zzXDk(dateTime));
    }

    @Override
    public final int getNodeType() {
        return 19;
    }

    @Override
    public final int getStoryType() {
        return 4;
    }

    public final int getId() {
        return this.zzJS;
    }

    public final void setId(int value) {
        this.zzJS = value;
        if (this.getDocument() != null) {
            this.getDocument().zzXW();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getIdInternal() {
        return this.getId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setIdInternal(int value) {
        this.setId(value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getParentIdInternal() {
        return this.getParentId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setParentIdInternal(int value) {
        this.setParentId(value);
    }

    public final String getInitial() {
        return this.zzZsA;
    }

    public final void setInitial(String value) {
        zzWJv.zzaQ((Object)value, "Initial");
        this.zzZsA = value;
    }

    public final Date getDateTime() {
        Comment comment = this;
        return zzWc5.zzCL(comment.zzWg1);
    }

    private void zzWfn(zzWc5 zzWc52) {
        this.zzWg1 = zzWc52;
        if (!zzWc5.zzXDk(this.zzYji, zzWc5.zzXlR)) {
            this.zzYji = !zzWc5.zzXDk(zzWc52, zzWc5.zzXlR) ? zzWc52.zzYDi() : zzWc5.zzXlR;
        }
    }

    public final void setDateTime(Date value) {
        this.zzWfn(zzWc5.zzXDk(value));
    }

    final zzWc5 zzVo() {
        if (!zzWc5.zzXDk(this.zzYji, zzWc5.zzXlR)) {
            return this.zzYji;
        }
        if (!zzWc5.zzXDk(this.zzWg1, zzWc5.zzXlR)) {
            return this.zzWg1.zzYDi();
        }
        return zzWc5.zzXlR;
    }

    public final Date getDateTimeUtc() {
        return zzWc5.zzCL(this.zzVo());
    }

    final void zzZdP(zzWc5 zzWc52) {
        this.zzYji = zzWc52;
    }

    public final String getAuthor() {
        return this.zzZ8w;
    }

    public final void setAuthor(String value) {
        zzWJv.zzaQ((Object)value, "Author");
        this.zzZ8w = value;
    }

    final zzWc5 zzZNM() {
        return this.zzWg1;
    }

    final void zzWSY(zzWc5 zzWc52) {
        this.zzWg1 = zzWc52;
    }

    final boolean zza1() {
        return !zzWc5.zzXDk(this.zzYji, zzWc5.zzXlR);
    }

    final zzXpG zzZL5() {
        return this.zzZ4c;
    }

    final void zzXDk(zzXpG zzXpG2) {
        this.zzZ4c = zzXpG2;
    }

    final boolean zzXX() {
        Comment comment = this;
        if (comment.zzZ4c != null) {
            comment = this;
            if (comment.zzZ4c.getCount() > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    private Comment zzXDk(String string, String string2, zzWc5 zzWc52, String string3) throws Exception {
        if (this.getParentId() != -1) {
            throw new IllegalStateException("Cannot add a reply to another reply.");
        }
        if (this.getParentNode() == null) {
            throw new IllegalStateException("No parent node.");
        }
        Comment comment = new Comment(this.getDocument(), string, string2, zzWc52);
        comment.setIdInternal(zzYfb.zzXDk(this.getDocument()));
        comment.setParentId(this.zzJS);
        comment.setText(string3);
        Comment comment2 = this;
        Comment comment3 = zzWJv.zzXDk((Object)this.zzZcn(), Comment.class);
        while (comment3 != null && comment3.getParentId() == this.zzJS) {
            comment2 = comment3;
            comment3 = zzWJv.zzXDk((Object)comment3.zzZcn(), Comment.class);
        }
        this.getParentNode().insertAfter(comment, comment2);
        zznp zznp2 = new zznp();
        if (zznp2.zzaQ(this.getDocument(), this.zzJS)) {
            this.zzXDk(zznp2.zzYHT(), new CommentRangeStart(this.getDocument(), comment.getId()));
            this.zzXDk(zznp2.zzWhR(), new CommentRangeEnd(this.getDocument(), comment.getId()));
        }
        return comment;
    }

    public final Comment addReply(String author, String initial, Date dateTime, String text) throws Exception {
        return this.zzXDk(author, initial, zzWc5.zzXDk(dateTime), text);
    }

    private void zzXDk(CommentRangeStart commentRangeStart, CommentRangeStart commentRangeStart2) {
        Node node2;
        ArrayList arrayList = new ArrayList();
        for (Node node2 : this.getReplies()) {
            zzYAy.zzXDk(arrayList, Integer.valueOf(node2.getId()));
        }
        Object object = commentRangeStart;
        while (((Node)object).getNextSibling() != null && ((Node)(node2 = ((Node)object).getNextSibling())).getNodeType() == 33 && arrayList.contains(((CommentRangeStart)node2).getId())) {
            object = node2;
        }
        ((Node)object).zzY5E(commentRangeStart2);
    }

    private void zzXDk(CommentRangeEnd commentRangeEnd, CommentRangeEnd commentRangeEnd2) {
        ArrayList arrayList = new ArrayList();
        for (Node node : this.getReplies()) {
            if (((Comment)node).getId() == commentRangeEnd2.getId()) continue;
            zzYAy.zzXDk(arrayList, Integer.valueOf(((Comment)node).getId()));
        }
        Object object = commentRangeEnd;
        while (((Node)object).getNextSibling() != null) {
            int n;
            Node node;
            node = ((Node)object).getNextSibling();
            if (node.getNodeType() == 34) {
                n = ((CommentRangeEnd)node).getId();
            } else {
                if (node.getNodeType() != 19) break;
                n = ((Comment)node).getId();
            }
            if (!arrayList.contains(n) && n != this.zzJS) break;
            object = node;
        }
        ((Node)object).zzY5E(commentRangeEnd2);
    }

    public final void removeReply(Comment reply) throws Exception {
        zznp zznp2 = new zznp();
        if (zznp2.zzaQ(this.getDocument(), reply.getId())) {
            zznp2.zzYHT().remove();
            zznp2.zzWhR().remove();
        }
        reply.remove();
    }

    public final void removeAllReplies() throws Exception {
        for (Comment comment : this.getReplies().zzZcF()) {
            this.removeReply(comment);
        }
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentEnd(this);
    }

    public final void setText(String text) {
        this.removeAllChildren();
        Paragraph paragraph = new Paragraph(this.getDocument());
        paragraph.getParagraphFormat().setStyleIdentifier(30);
        this.appendChild(paragraph);
        DocumentBuilder documentBuilder = new DocumentBuilder(this.zzx());
        documentBuilder.moveTo(paragraph);
        SpecialChar specialChar = new SpecialChar(this.zzx(), '\u0005', new zzZrc());
        specialChar.getFont().setStyleIdentifier(39);
        documentBuilder.insertNode(specialChar);
        documentBuilder.write(text);
    }

    public final Comment getAncestor() {
        if (this.getDocument() == null || this.getParentId() == -1) {
            return null;
        }
        for (Comment comment : this.getDocument().getChildNodes(19, true)) {
            if (comment.getId() != this.getParentId()) continue;
            return comment;
        }
        return null;
    }

    public final CommentCollection getReplies() {
        if (this.zzWED == null) {
            this.zzWED = new CommentCollection(this.getDocument(), this);
        }
        return this.zzWED;
    }

    public final boolean getDone() {
        return this.zzY0r;
    }

    public final void setDone(boolean value) {
        this.zzY0r = value;
    }

    public final int getParentId() {
        return this.zzCB;
    }

    public final void setParentId(int value) {
        this.zzCB = value;
        if (this.getDocument() != null) {
            this.getDocument().zzXW();
        }
    }

    final int zzXqF() {
        return this.zzVRH;
    }

    final void zzWNL(int n) {
        this.zzVRH = n;
    }

    final boolean zzZHD() {
        return this.zzWKj;
    }

    final void zzBv(boolean bl) {
        this.zzWKj = bl;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzW8u getMoveFromRevision() {
        return this.zzX6B().getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveFromRevision(zzW8u value) {
        zzW8u zzW8u2 = value;
        zzZrc zzZrc2 = this.zzX6B();
        zzZrc2.zzXFB(13, zzW8u2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzW8u getMoveToRevision() {
        return this.zzX6B().getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveToRevision(zzW8u value) {
        zzW8u zzW8u2 = value;
        zzZrc zzZrc2 = this.zzX6B();
        zzZrc2.zzXFB(15, zzW8u2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void removeMoveRevisions() {
        this.zzX6B().remove(13);
        this.zzX6B().remove(15);
    }

    final String zzXsL() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzXzs(stringBuilder);
        if (stringBuilder.length() > 0 && stringBuilder.charAt(0) == '\u0005') {
            stringBuilder.delete(0, 1);
        }
        return stringBuilder.toString();
    }
}

