/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzWJv;
import com.aspose.words.zzVX5;
import com.aspose.words.zzW8u;
import com.aspose.words.zzWRl;
import com.aspose.words.zzX4H;
import com.aspose.words.zzXGx;
import com.aspose.words.zzXUC;
import com.aspose.words.zzXvU;
import com.aspose.words.zzYAn;
import com.aspose.words.zzZ4s;
import com.aspose.words.zzZX9;

public class Cell
extends CompositeNode<Node>
implements zzVX5,
zzX4H {
    private zzXGx zzXoL;
    private CellFormat zzWBj;
    private ParagraphCollection zzXn9;
    private TableCollection zzls;

    public Cell(DocumentBase doc) {
        this(doc, new zzXGx());
    }

    Cell(DocumentBase doc, zzXGx cellPr) {
        super(doc);
        this.zzXoL = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    public Cell getNextCell() {
        return (Cell)this.zzXWD();
    }

    public Cell getPreviousCell() {
        return (Cell)this.zzWv6();
    }

    public Row getParentRow() {
        return (Row)this.zzYa4();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzYys() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzYRf(this, true);
        }
        return -1;
    }

    final int zzXT0() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzXT0();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzWBj == null) {
            this.zzWBj = new CellFormat(this);
        }
        return this.zzWBj;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzXn9 == null) {
            this.zzXn9 = new ParagraphCollection(this);
        }
        return this.zzXn9;
    }

    public TableCollection getTables() {
        if (this.zzls == null) {
            this.zzls = new TableCollection(this);
        }
        return this.zzls;
    }

    final zzXGx zzWTf() {
        return this.zzXoL;
    }

    final void zzXDk(zzXGx zzXGx2) {
        this.zzXoL = zzXGx2;
    }

    @Override
    final Node zzXDk(boolean bl, zzYAn zzYAn2) {
        zzXGx zzXGx2;
        Cell cell = (Cell)super.zzXDk(bl, zzYAn2);
        zzXGx zzXGx3 = this.zzXoL;
        cell.zzXoL = zzXGx2 = (zzXGx)zzXGx3.zzXQq();
        cell.zzWBj = null;
        cell.zzXn9 = null;
        cell.zzls = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellStart(this);
    }

    @Override
    public int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzXvU.zzYT7(this);
    }

    @Override
    final boolean zzXcI(Node node) {
        return zzXUC.zzYXi(node);
    }

    final int zzWlH() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        for (Cell cell = row.getFirstCell(); cell != null; cell = cell.getNextCell()) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell != this) continue;
            return n;
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzXoL.zzYfo(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzXoL.zzYfo(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzWRl zzWRl2 = zzWJv.zzXDk(object, zzWRl.class);
        if (zzWRl2 != null && zzWRl2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzst(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzXGx.zzYBr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzXoL.zzXFB(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzXoL.clear();
    }

    private Object zzst(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzWJv.zzXDk((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzXDk(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZ4s getInsertRevision() {
        Cell cell = this;
        return cell.zzXoL.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzZ4s value) {
        zzX4H zzX4H2 = this;
        zzZ4s zzZ4s2 = value;
        zzX4H2 = zzX4H2.zzXoL;
        ((zzZX9)((Object)zzX4H2)).zzXFB(14, zzZ4s2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZ4s getDeleteRevision() {
        Cell cell = this;
        return cell.zzXoL.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzZ4s value) {
        zzX4H zzX4H2 = this;
        zzZ4s zzZ4s2 = value;
        zzX4H2 = zzX4H2.zzXoL;
        ((zzZX9)((Object)zzX4H2)).zzXFB(12, zzZ4s2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzW8u getMoveFromRevision() {
        Cell cell = this;
        return cell.zzXoL.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzW8u value) {
        zzX4H zzX4H2 = this;
        zzW8u zzW8u2 = value;
        zzX4H2 = zzX4H2.zzXoL;
        ((zzZX9)((Object)zzX4H2)).zzXFB(13, zzW8u2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzW8u getMoveToRevision() {
        Cell cell = this;
        return cell.zzXoL.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzW8u value) {
        zzX4H zzX4H2 = this;
        zzW8u zzW8u2 = value;
        zzX4H2 = zzX4H2.zzXoL;
        ((zzZX9)((Object)zzX4H2)).zzXFB(15, zzW8u2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzXoL.remove(13);
        cell = this;
        cell.zzXoL.remove(15);
    }

    final zzXGx zzWl4(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzXGx zzXGx2 = new zzXGx();
        this.zzXDk(3120, zzXGx2);
        this.zzXDk(3140, zzXGx2);
        this.zzXDk(3110, zzXGx2);
        this.zzXDk(3130, zzXGx2);
        this.zzXDk(3090, zzXGx2);
        this.zzXDk(3100, zzXGx2);
        this.zzXDk(3070, zzXGx2);
        this.zzXDk(3080, zzXGx2);
        if (bl && (tableStyle = zzWJv.zzXDk((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzaQ(this, zzXGx2);
        }
        this.zzXoL.zzaQ((zzZX9)zzXGx2);
        return zzXGx2;
    }

    private void zzXDk(int n, zzXGx zzXGx2) {
        zzXGx2.zzXFB(n, this.fetchInheritedCellAttr(n));
    }
}

