/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CheckGrammarOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.Run;
import com.aspose.words.SummarizeOptions;
import com.aspose.words.internal.zzWBh;
import com.aspose.words.internal.zzWJv;
import com.aspose.words.internal.zzWc5;
import com.aspose.words.internal.zzXVD;
import com.aspose.words.internal.zzXsN;
import com.aspose.words.internal.zzYXH;
import com.aspose.words.internal.zzax;
import com.aspose.words.zz8R;
import com.aspose.words.zzDa;
import com.aspose.words.zzVVQ;
import com.aspose.words.zzWAW;
import com.aspose.words.zzWRk;
import com.aspose.words.zzWcw;
import com.aspose.words.zzWds;
import com.aspose.words.zzXCa;
import com.aspose.words.zzXk9;
import com.aspose.words.zzXwB;
import com.aspose.words.zzYKE;
import com.aspose.words.zzYLC;
import com.aspose.words.zzYRk;
import com.aspose.words.zzYY0;
import com.aspose.words.zzYmi;
import com.aspose.words.zzZq5;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;

public abstract class AiModel {
    private String zzX4U;

    public abstract Document summarize(Document var1, SummarizeOptions var2) throws Exception;

    public abstract Document summarize(Document[] var1, SummarizeOptions var2) throws Exception;

    public Document checkGrammar(Document sourceDocument, CheckGrammarOptions options) throws Exception {
        Document document = options == null || options.getPreserveFormatting() ? this.zzaQ(sourceDocument, options) : this.zzXDk(sourceDocument, options);
        document.zzZML().add(32);
        if (options != null && options.getMakeRevisions()) {
            Document document2 = sourceDocument.deepClone();
            document2.zzXDk(document, "AI", zzWc5.zzZ3I());
            return document2;
        }
        return document;
    }

    public abstract Document translate(Document var1, int var2) throws Exception;

    public AiModel withApiKey(String apiKey) {
        String string = apiKey;
        AiModel aiModel = this;
        this.zzX4U = string;
        return this;
    }

    public static AiModel create(int modelType) {
        switch (modelType) {
            case 0: {
                return new zz8R();
            }
            case 1: {
                return new zzXwB();
            }
            case 2: {
                return new zzVVQ();
            }
            case 3: {
                return new zzYKE();
            }
            case 4: {
                return new zzYY0();
            }
            case 5: {
                return new zzXCa();
            }
            case 6: {
                return new zzYLC();
            }
            case 7: {
                return new zzDa();
            }
            case 8: {
                return new zzYRk();
            }
            case 10: {
                return new zzYmi();
            }
            case 9: {
                return new zzWds();
            }
            case 11: {
                return new zzZq5();
            }
        }
        throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: modelType" + modelType);
    }

    AiModel() {
    }

    private static String zzYRf(InputStream inputStream) throws IOException {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder stringBuilder = new StringBuilder();
        while (-1 != (n = bufferedReader.read())) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    final String zzWE0(ArrayList<zzWRk> arrayList, int n) throws Exception {
        String string = this.zzYRQ(arrayList, n);
        zzYXH zzYXH2 = new zzYXH();
        byte[] byArray = zzYXH2.zzya(string);
        HttpURLConnection httpURLConnection = this.zzZuE(n);
        httpURLConnection.setRequestProperty("Content-Length", Integer.toString(byArray.length));
        AiModel.zzXDk(string, httpURLConnection);
        return AiModel.zzWew(httpURLConnection);
    }

    private HttpURLConnection zzZuE(int n) throws Exception {
        String string = zzWBh.zzaQ("{0}{1}{2}", new Object[]{this.getUrl(), zzWBh.zzaQ(this.getUrl(), "/", zzXVD.INVARIANT_CULTURE_IGNORE_CASE) ? "" : "/", this.toString(n)});
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setRequestMethod("POST");
        if (this.zzWeK() != null) {
            zzXsN.zzXDk zzXDk2 = this.zzWeK().zzWWK();
            while (zzXDk2.moveNext()) {
                httpURLConnection.setRequestProperty(zzXDk2.zzWFa(), zzXDk2.zz72());
            }
        }
        return httpURLConnection;
    }

    private static void zzXDk(String string, HttpURLConnection httpURLConnection) throws IOException {
        httpURLConnection.setDoOutput(true);
        OutputStream outputStream = httpURLConnection.getOutputStream();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        bufferedWriter.write(string);
        bufferedWriter.flush();
        bufferedWriter.close();
        outputStream.close();
    }

    private static String zzWew(HttpURLConnection httpURLConnection) throws IOException {
        try {
            String string = AiModel.zzYRf(httpURLConnection.getInputStream());
            int n = httpURLConnection.getResponseCode();
            if (n == 200 || n == 202 || n == 201) {
                return string;
            }
        }
        catch (Exception exception) {
            String string = AiModel.zzYRf(httpURLConnection.getErrorStream());
            if (string.isEmpty()) {
                throw new IllegalStateException("Request error with Error message: " + exception.getMessage());
            }
            return string;
        }
        return "";
    }

    private String toString(int requestMethod) {
        switch (requestMethod) {
            case 0: {
                return this.zzWJa();
            }
            case 1: {
                return this.zzWKU();
            }
        }
        throw new IllegalArgumentException(null + "\r\nParameter name: " + zzXk9.toString(requestMethod) + "\r\nParameter value: " + requestMethod);
    }

    private Document zzXDk(Document document, CheckGrammarOptions checkGrammarOptions) throws Exception {
        Object object2;
        NodeCollection nodeCollection;
        NodeCollection nodeCollection2 = nodeCollection = new NodeCollection((CompositeNode)document, new zzWAW(), true);
        ArrayList arrayList = nodeCollection.zzZcF();
        if (arrayList.size() == 0) {
            return document.deepClone();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object2 : arrayList) {
            zzWJv.zzaQ(stringBuilder, ((Run)object2).getText());
        }
        String string = zzWBh.zzX6U(this.zzXDk(stringBuilder.toString(), checkGrammarOptions), "\r\n".toCharArray());
        object2 = new DocumentBuilder();
        ((DocumentBuilder)object2).write(string);
        return ((DocumentBuilder)object2).getDocument();
    }

    private Document zzaQ(Document document, CheckGrammarOptions checkGrammarOptions) throws Exception {
        String string;
        NodeCollection nodeCollection;
        Document document2 = document.deepClone();
        document2.joinRunsWithSameFormatting();
        NodeCollection nodeCollection2 = nodeCollection = new NodeCollection((CompositeNode)document2, new zzWAW(), true);
        ArrayList<Node> arrayList = nodeCollection.zzZcF();
        if (arrayList.size() == 0) {
            return document2;
        }
        zzWcw.zzWpp(arrayList);
        String string2 = zzWcw.zzXDX(arrayList);
        zzax zzax2 = null;
        for (int i = 0; i <= 3 && (zzax2 = zzWcw.zzWew(string = zzWBh.zzX6U(this.zzXDk(string2, checkGrammarOptions), "\r\n".toCharArray()), arrayList)).getCount() <= 0; ++i) {
        }
        if (zzax2.getCount() > 0) {
            zzax zzax3 = zzWcw.zzaQ(zzax2, arrayList.size() - 1);
            for (int i = 0; i < zzax3.getCount(); ++i) {
                int n = zzax3.get(i);
                arrayList.get(n).remove();
            }
        }
        return document2;
    }

    protected abstract String getName();

    protected abstract String getUrl();

    final String zzXc() {
        return this.zzX4U;
    }

    abstract String zzXDk(String var1, CheckGrammarOptions var2) throws Exception;

    abstract String zzYRQ(ArrayList<zzWRk> var1, int var2);

    abstract String zzWKU();

    abstract String zzWJa();

    abstract zzXsN zzWeK();
}

