/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXV7;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzW3X;
import com.aspose.words.net.System.Data.zzYhT;
import com.aspose.words.net.System.Data.zzYxS;
import com.aspose.words.net.System.Data.zzZON;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzYI7;
    private final DataColumnCollection zzXnt;
    private final ConstraintCollection zzWJk;
    private final zzYhT zzWm7;
    private ResultSet zzXtP;
    private String zzFy;
    private DataSet zzVTr;
    private String zzZfc;
    private UniqueConstraint zzY8P;
    private boolean zzXUS;
    private final List<DataTableEventListener> zzWfu;
    private final Set<DataRow> zz4C;
    private DataRelationCollection zzQ6;

    public DataTable() {
        this.zzYI7 = new DataRowCollection(this);
        this.zzXnt = new DataColumnCollection(this);
        this.zzWJk = new ConstraintCollection(this);
        this.zzWm7 = new zzYhT(this);
        this.zzZfc = "";
        this.zzXUS = true;
        this.zzWfu = new ArrayList<DataTableEventListener>();
        this.zz4C = new HashSet<DataRow>();
        this.zzQ6 = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzYI7 = new DataRowCollection(this);
        this.zzXnt = new DataColumnCollection(this);
        this.zzWJk = new ConstraintCollection(this);
        this.zzWm7 = new zzYhT(this);
        this.zzZfc = "";
        this.zzXUS = true;
        this.zzWfu = new ArrayList<DataTableEventListener>();
        this.zz4C = new HashSet<DataRow>();
        this.zzQ6 = new DataRelationCollection();
        this.zzFy = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzYxS.zzWBj(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzYI7 = new DataRowCollection(this);
        this.zzXnt = new DataColumnCollection(this);
        this.zzWJk = new ConstraintCollection(this);
        this.zzWm7 = new zzYhT(this);
        this.zzZfc = "";
        this.zzXUS = true;
        this.zzWfu = new ArrayList<DataTableEventListener>();
        this.zz4C = new HashSet<DataRow>();
        this.zzQ6 = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzXtP = resultSet;
        this.zzFy = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzXtP != null) {
            if (this.zzXtP.getStatement() != null) {
                this.zzXtP.getStatement().getConnection().close();
            }
            this.zzXtP = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzFy;
    }

    public void setTableName(String tableName) {
        this.zzFy = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzXnt.getCount();
    }

    public String getColumnName(int index) {
        return this.zzXnt.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzXtP;
    }

    public DataSet getDataSet() {
        return this.zzVTr;
    }

    final void zzZdS(DataSet dataSet) {
        this.zzVTr = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzVTr.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzQ6.add(dataRelation);
        }
        return this.zzQ6;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzVTr.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzYI7;
    }

    public DataColumnCollection getColumns() {
        return this.zzXnt;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzWJk;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzY8P == null) {
            return new DataColumn[0];
        }
        return this.zzY8P.getColumns();
    }

    final void zzYhT(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzY8P != null) {
                this.zzY8P.zzWB1(false);
                this.getConstraints().remove(this.zzY8P);
                this.zzY8P = null;
            }
            return;
        }
        if (this.zzY8P != null && DataColumn.areColumnSetsTheSame(value, this.zzY8P.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzWBj(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzY8P != null) {
            this.zzY8P.zzWB1(false);
            this.getConstraints().remove(this.zzY8P);
            this.zzY8P = null;
        }
        UniqueConstraint.zzWBj(this.getConstraints(), uniqueConstraint);
        this.zzY8P = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzZfc;
    }

    public void setNamespace(String namespace) {
        this.zzZfc = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzXUS;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXUS = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zz4C.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzYxS.zzWBj(this.getResultSet(), this);
            zzYxS.zzYxS(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzXV7.zzZdS(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzYxS.zzYnw(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzWfu.contains(listener)) {
            this.zzWfu.add(listener);
        }
    }

    public void removeEventListener(zzZON listener) {
        if (this.zzWfu.contains(listener)) {
            this.zzWfu.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzWfu.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zz4C.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzWfu) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zz4C.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzWfu) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zz4C.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzWfu) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzWfu) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzWfu) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzW3X zzWBj(zzYxS[] zzYxSArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzYxSArray.length];
        for (int i = 0; i < zzYxSArray.length; ++i) {
            dataColumnArray[i] = zzYxSArray[i].zzWh3();
        }
        DataTable dataTable = this;
        zzW3X zzW3X2 = dataTable.zzWm7.zzZdS(dataColumnArray);
        if (zzW3X2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzW3X2;
    }

    final zzYhT zzXLK() {
        return this.zzWm7;
    }

    final Set<DataRow> zz4n() {
        return this.zz4C;
    }
}

