/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzZWZ;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzYIC = new ArrayList();
    private final Map<String, DataColumn> zzXUp = new HashMap<String, DataColumn>();
    private DataTable zzX7M;

    DataColumnCollection(DataTable table) {
        this.zzX7M = table;
    }

    public void add(DataColumn column) {
        if (zzZWZ.zzDQ(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzZtZ(column.getColumnName());
        if (this.zzXUp.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzZdS(this.zzX7M);
        column.setOrdinal(this.zzYIC.size());
        this.zzYIC.add(column);
        this.zzXUp.put(string, column);
        this.zzX7M.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzX7M);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzX7M);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzZWZ.zzDQ(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzZtZ(columnName);
        DataColumn dataColumn = this.zzXUp.get(string);
        if (dataColumn != null) {
            int n = this.zzYIC.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzYIC.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzYIC.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzYIC.remove(n);
            this.zzXUp.remove(DataColumnCollection.zzZtZ(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzX7M.getRows()) {
                dataRow.remove(n);
            }
            this.zzX7M.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzYIC.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzYIC.iterator();
    }

    public void clear() {
        this.zzXUp.clear();
        this.zzYIC.clear();
    }

    final DataColumn[] zzW4q() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzYIC);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzWBj(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzYIC.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzYIC.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzZtZ(string);
            String string3 = DataColumnCollection.zzZtZ(dataColumn.getColumnName());
            this.zzXUp.remove(string3);
            this.zzXUp.put(string2, dataColumn);
            return;
        }
    }

    private static String zzZtZ(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

