/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzWA0;
import com.aspose.words.internal.zzWcI;
import com.aspose.words.internal.zzWf4;
import com.aspose.words.internal.zzWqI;
import com.aspose.words.internal.zzWtp;
import com.aspose.words.internal.zzXaN;
import com.aspose.words.internal.zzYgy;
import com.aspose.words.internal.zzZTw;
import com.aspose.words.internal.zzZiA;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzYmb
extends CertPathBuilderSpi {
    private final zzWqI zzVVk;
    private zzYgy zzkx;

    zzYmb(zzWqI zzWqI2) {
        this.zzVVk = zzWqI2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzWf4 pkixParams;
        if (params instanceof zzWf4) {
            pkixParams = (zzWf4)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzWf4.zzWBj((PKIXBuilderParameters)params).zzXAt();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzWf4.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzWtp zzWtp2 = pkixParams.zzWsz().zzXEV();
        try {
            collection = zzZTw.zzWBj(zzWtp2, pkixParams.zzWsz().zzcL());
            collection.addAll(zzZTw.zzWBj(zzWtp2, pkixParams.zzWsz().zzZq1()));
        }
        catch (zzYgy zzYgy2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzYgy2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzWBj(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzkx != null) {
            throw new CertPathBuilderException(this.zzkx.getMessage(), this.zzkx.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzWBj(X509Certificate x509Certificate, zzWf4 zzWf42, List list) throws CertPathBuilderException {
        zzWA0 zzWA02;
        zzWcI zzWcI2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzWf42.zz9r().contains(x509Certificate)) {
            return null;
        }
        if (zzWf42.zzXPt() != -1 && list.size() - 1 > zzWf42.zzXPt()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzWcI2 = new zzWcI(this.zzVVk);
            zzWA02 = new zzWA0(this.zzVVk);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzZTw.zzWBj(x509Certificate, zzWf42.zzWsz().zzXK2(), zzWf42.zzWsz().zzZcO()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzWcI2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzYgy("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzWA02.engineValidate(certPath, zzWf42);
                }
                catch (Exception exception) {
                    throw new zzYgy("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzZiA> arrayList = new ArrayList<zzZiA>();
            arrayList.addAll(zzWf42.zzWsz().zzcL());
            try {
                arrayList.addAll(zzZTw.zzWBj(x509Certificate.getExtensionValue(zzXaN.zzXZu.getId()), zzWf42.zzWsz().zzZJ6()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzYgy("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzZTw.zzWBj(x509Certificate, zzWf42.zzWsz().zzZq1(), arrayList));
            }
            catch (zzYgy zzYgy2) {
                throw new zzYgy("Cannot find issuer certificate for certificate in certification path.", zzYgy2);
            }
            if (hashSet.isEmpty()) {
                throw new zzYgy("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzWBj(x509Certificate2, zzWf42, list);
            }
        }
        catch (zzYgy zzYgy3) {
            this.zzkx = zzYgy3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

