/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.testset.TestArtifactInfo;
import org.apache.maven.surefire.testset.TestRequest;

public class ProviderConfiguration {
    public static final int TESTS_SUCCEEDED_EXIT_CODE = 0;
    public static final int TESTS_FAILED_EXIT_CODE = 255;
    public static final int NO_TESTS_EXIT_CODE = 254;
    private final DirectoryScannerParameters dirScannerParams;
    private final ReporterConfiguration reporterConfiguration;
    private final TestArtifactInfo testArtifact;
    private final TestRequest testSuiteDefinition;
    private final Properties providerProperties;
    private final boolean failIfNoTests;
    private final Object forkTestSet;

    public ProviderConfiguration(DirectoryScannerParameters directoryScannerParameters, boolean failIfNoTests, ReporterConfiguration reporterConfiguration, TestArtifactInfo testArtifact, TestRequest testSuiteDefinition, Properties providerProperties, Object forkTestSet) {
        this.providerProperties = providerProperties;
        this.reporterConfiguration = reporterConfiguration;
        this.testArtifact = testArtifact;
        this.testSuiteDefinition = testSuiteDefinition;
        this.dirScannerParams = directoryScannerParameters;
        this.failIfNoTests = failIfNoTests;
        this.forkTestSet = forkTestSet;
    }

    public ReporterConfiguration getReporterConfiguration() {
        return this.reporterConfiguration;
    }

    public Boolean isFailIfNoTests() {
        return this.failIfNoTests ? Boolean.TRUE : Boolean.FALSE;
    }

    public File getBaseDir() {
        return this.dirScannerParams.getTestClassesDirectory();
    }

    public DirectoryScannerParameters getDirScannerParams() {
        return this.dirScannerParams;
    }

    public Object[] getDirScannerParamsArray() {
        if (this.dirScannerParams == null) {
            return null;
        }
        return new Object[]{this.dirScannerParams.getTestClassesDirectory(), this.dirScannerParams.getIncludes(), this.dirScannerParams.getExcludes()};
    }

    public List getIncludes() {
        return this.dirScannerParams.getIncludes();
    }

    public List getExcludes() {
        return this.dirScannerParams.getExcludes();
    }

    public TestArtifactInfo getTestArtifact() {
        return this.testArtifact;
    }

    public TestRequest getTestSuiteDefinition() {
        return this.testSuiteDefinition;
    }

    public Properties getProviderProperties() {
        return this.providerProperties;
    }

    public Object getTestForFork() {
        return this.forkTestSet;
    }

    public String getTestForForkString() {
        if (this.forkTestSet instanceof File) {
            return this.forkTestSet.toString();
        }
        return (String)this.forkTestSet;
    }

    public boolean isSurefireForkReturnCode(int returnCode) {
        return 0 == returnCode || 254 == returnCode || 255 == returnCode;
    }
}

