/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.maven.surefire.booter.BooterConstants;
import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.testset.TestArtifactInfo;
import org.apache.maven.surefire.testset.TestRequest;

public class BooterDeserializer
implements BooterConstants {
    private final PropertiesWrapper properties;

    public BooterDeserializer(InputStream inputStream) throws IOException {
        this.properties = SystemPropertyManager.loadProperties(inputStream);
    }

    public ProviderConfiguration deserialize() throws IOException {
        File reportsDirectory = new File(this.properties.getProperty("reportsDirectory"));
        Integer timeout = this.properties.getIntegerObjectProperty("forkTimeout");
        String testNgVersion = this.properties.getProperty("testFwJarVersion");
        String testArtifactClassifier = this.properties.getProperty("testFwJarClassifier");
        Object testForFork = this.properties.getTypeDecoded("forkTestSet");
        String requestedTest = this.properties.getProperty("requestedTest");
        String requestedTestMethod = this.properties.getProperty("requestedTestMethod");
        File sourceDirectory = this.properties.getFileProperty("testSuiteDefinitionTestSourceDirectory");
        List reports = this.properties.getStringList("report.");
        List excludesList = this.properties.getStringList("excludes");
        List includesList = this.properties.getStringList("includes");
        List testSuiteXmlFiles = this.properties.getStringList("testSuiteXmlFiles");
        File testClassesDirectory = this.properties.getFileProperty("testClassesDirectory");
        String runOrder = this.properties.getProperty("runOrder");
        DirectoryScannerParameters dirScannerParams = new DirectoryScannerParameters(testClassesDirectory, includesList, excludesList, this.properties.getBooleanObjectProperty("failIfNoTests"), runOrder);
        TestArtifactInfo testNg = new TestArtifactInfo(testNgVersion, testArtifactClassifier);
        TestRequest testSuiteDefinition = new TestRequest(testSuiteXmlFiles, sourceDirectory, requestedTest, requestedTestMethod);
        ReporterConfiguration reporterConfiguration = new ReporterConfiguration(reports, reportsDirectory, this.properties.getBooleanObjectProperty("isTrimStackTrace"), timeout);
        return new ProviderConfiguration(dirScannerParams, this.properties.getBooleanProperty("failIfNoTests"), reporterConfiguration, testNg, testSuiteDefinition, this.properties.getProperties(), testForFork);
    }

    public StartupConfiguration getProviderConfiguration() throws IOException {
        boolean useSystemClassLoader = this.properties.getBooleanProperty("useSystemClassLoader");
        boolean useManifestOnlyJar = this.properties.getBooleanProperty("useManifestOnlyJar");
        String providerConfiguration = this.properties.getProperty("providerConfiguration");
        ClassLoaderConfiguration classLoaderConfiguration = new ClassLoaderConfiguration(useSystemClassLoader, useManifestOnlyJar);
        ClasspathConfiguration classpathConfiguration = new ClasspathConfiguration(this.properties);
        return StartupConfiguration.inForkedVm(providerConfiguration, classpathConfiguration, classLoaderConfiguration);
    }
}

