/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.IOException;
import jnr.constants.platform.Errno;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import jnr.enxio.channels.NativeSocketChannel;
import jnr.ffi.LastError;
import jnr.ffi.Runtime;
import jnr.ffi.byref.IntByReference;
import jnr.unixsocket.Credentials;
import jnr.unixsocket.Native;
import jnr.unixsocket.SockAddrUnix;
import jnr.unixsocket.UnixSocketAddress;

public class UnixSocketChannel
extends NativeSocketChannel {
    private volatile State state;
    private UnixSocketAddress remoteAddress = null;
    private UnixSocketAddress localAddress = null;
    private final Object stateLock = new Object();

    public static final UnixSocketChannel open() throws IOException {
        return new UnixSocketChannel();
    }

    public static final UnixSocketChannel open(UnixSocketAddress remote) throws IOException {
        UnixSocketChannel channel = new UnixSocketChannel();
        channel.connect(remote);
        return channel;
    }

    public static final UnixSocketChannel[] pair() throws IOException {
        int[] sockets = new int[]{-1, -1};
        Native.socketpair(ProtocolFamily.PF_UNIX, Sock.SOCK_STREAM, 0, sockets);
        return new UnixSocketChannel[]{new UnixSocketChannel(sockets[0], 5), new UnixSocketChannel(sockets[1], 5)};
    }

    private UnixSocketChannel() throws IOException {
        super(Native.socket(ProtocolFamily.PF_UNIX, Sock.SOCK_STREAM, 0), 13);
        this.state = State.IDLE;
    }

    UnixSocketChannel(int fd, int ops) {
        super(fd, ops);
        this.state = State.CONNECTED;
    }

    UnixSocketChannel(int fd, UnixSocketAddress remote) {
        super(fd, 5);
        this.state = State.CONNECTED;
        this.remoteAddress = remote;
    }

    private final boolean doConnect(SockAddrUnix remote) throws IOException {
        if (Native.connect(this.getFD(), remote, remote.length()) != 0) {
            Errno error = Errno.valueOf(LastError.getLastError(Runtime.getSystemRuntime()));
            switch (error) {
                case EAGAIN: 
                case EWOULDBLOCK: {
                    return false;
                }
            }
            throw new IOException(error.toString());
        }
        return true;
    }

    public boolean connect(UnixSocketAddress remote) throws IOException {
        this.remoteAddress = remote;
        if (!this.doConnect(this.remoteAddress.getStruct())) {
            this.state = State.CONNECTING;
            return false;
        }
        this.state = State.CONNECTED;
        return true;
    }

    public boolean isConnected() {
        return this.state == State.CONNECTED;
    }

    public boolean isConnectionPending() {
        return this.state == State.CONNECTING;
    }

    public boolean finishConnect() throws IOException {
        switch (this.state) {
            case CONNECTED: {
                return true;
            }
            case CONNECTING: {
                if (!this.doConnect(this.remoteAddress.getStruct())) {
                    return false;
                }
                this.state = State.CONNECTED;
                return true;
            }
        }
        throw new IllegalStateException("socket is not waiting for connect to complete");
    }

    public final UnixSocketAddress getRemoteSocketAddress() {
        if (this.state != State.CONNECTED) {
            return null;
        }
        return this.remoteAddress != null ? this.remoteAddress : (this.remoteAddress = UnixSocketChannel.getpeername(this.getFD()));
    }

    public final UnixSocketAddress getLocalSocketAddress() {
        if (this.state != State.CONNECTED) {
            return null;
        }
        return this.localAddress != null ? this.localAddress : (this.localAddress = UnixSocketChannel.getsockname(this.getFD()));
    }

    public final Credentials getCredentials() {
        if (this.state != State.CONNECTED) {
            return null;
        }
        return Credentials.getCredentials(this.getFD());
    }

    static UnixSocketAddress getpeername(int sockfd) {
        UnixSocketAddress remote = new UnixSocketAddress();
        IntByReference len = new IntByReference(remote.getStruct().getMaximumLength());
        if (Native.libc().getpeername(sockfd, remote.getStruct(), len) < 0) {
            throw new Error(Native.getLastErrorString());
        }
        return remote;
    }

    static UnixSocketAddress getsockname(int sockfd) {
        UnixSocketAddress remote = new UnixSocketAddress();
        IntByReference len = new IntByReference(remote.getStruct().getMaximumLength());
        if (Native.libc().getsockname(sockfd, remote.getStruct(), len) < 0) {
            throw new Error(Native.getLastErrorString());
        }
        return remote;
    }

    public boolean getKeepAlive() {
        int ret = Native.getsockopt(this.getFD(), SocketLevel.SOL_SOCKET, SocketOption.SO_KEEPALIVE.intValue());
        return ret == 1;
    }

    public void setKeepAlive(boolean on) {
        Native.setsockopt(this.getFD(), SocketLevel.SOL_SOCKET, SocketOption.SO_KEEPALIVE, on);
    }

    public int getSoTimeout() {
        return Native.getsockopt(this.getFD(), SocketLevel.SOL_SOCKET, SocketOption.SO_RCVTIMEO.intValue());
    }

    public void setSoTimeout(int timeout) {
        Native.setsockopt(this.getFD(), SocketLevel.SOL_SOCKET, SocketOption.SO_RCVTIMEO, timeout);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        UNINITIALIZED,
        CONNECTED,
        IDLE,
        CONNECTING;

    }
}

