/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.google.common.collect.ImmutableList;
import com.spotify.docker.client.messages.swarm.AutoValue_TaskSpec;
import com.spotify.docker.client.messages.swarm.ContainerSpec;
import com.spotify.docker.client.messages.swarm.Driver;
import com.spotify.docker.client.messages.swarm.NetworkAttachmentConfig;
import com.spotify.docker.client.messages.swarm.Placement;
import com.spotify.docker.client.messages.swarm.ResourceRequirements;
import com.spotify.docker.client.messages.swarm.RestartPolicy;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.docker.client.shaded.javax.annotation.Nullable;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class TaskSpec {
    @Nullable
    @JsonProperty(value="ContainerSpec")
    public abstract ContainerSpec containerSpec();

    @Nullable
    @JsonProperty(value="Resources")
    public abstract ResourceRequirements resources();

    @Nullable
    @JsonProperty(value="RestartPolicy")
    public abstract RestartPolicy restartPolicy();

    @Nullable
    @JsonProperty(value="Placement")
    public abstract Placement placement();

    @Nullable
    @JsonProperty(value="Networks")
    public abstract ImmutableList<NetworkAttachmentConfig> networks();

    @Nullable
    @JsonProperty(value="LogDriver")
    public abstract Driver logDriver();

    public static Builder builder() {
        return new AutoValue_TaskSpec.Builder();
    }

    @JsonCreator
    static TaskSpec create(@JsonProperty(value="ContainerSpec") ContainerSpec containerSpec, @JsonProperty(value="Resources") ResourceRequirements resources, @JsonProperty(value="RestartPolicy") RestartPolicy restartPolicy, @JsonProperty(value="Placement") Placement placement, @JsonProperty(value="Networks") List<NetworkAttachmentConfig> networks, @JsonProperty(value="LogDriver") Driver logDriver) {
        Builder builder = TaskSpec.builder().containerSpec(containerSpec).resources(resources).restartPolicy(restartPolicy).placement(placement).logDriver(logDriver);
        if (networks != null) {
            builder.networks(networks);
        }
        return builder.build();
    }

    public static abstract class Builder {
        public abstract Builder containerSpec(ContainerSpec var1);

        @Deprecated
        public Builder withContainerSpec(ContainerSpec containerSpec) {
            this.containerSpec(containerSpec);
            return this;
        }

        public abstract Builder resources(ResourceRequirements var1);

        @Deprecated
        public Builder withResources(ResourceRequirements resources) {
            this.resources(resources);
            return this;
        }

        public abstract Builder restartPolicy(RestartPolicy var1);

        @Deprecated
        public Builder withRestartPolicy(RestartPolicy restartPolicy) {
            this.restartPolicy(restartPolicy);
            return this;
        }

        public abstract Builder placement(Placement var1);

        @Deprecated
        public Builder withPlacement(Placement placement) {
            this.placement(placement);
            return this;
        }

        public abstract Builder networks(NetworkAttachmentConfig ... var1);

        public abstract Builder networks(List<NetworkAttachmentConfig> var1);

        @Deprecated
        public Builder withNetworks(NetworkAttachmentConfig ... networks) {
            if (networks != null && networks.length > 0) {
                this.networks(networks);
            }
            return this;
        }

        @Deprecated
        public Builder withNetworks(List<NetworkAttachmentConfig> networks) {
            if (networks != null && !networks.isEmpty()) {
                this.networks(networks);
            }
            return this;
        }

        public abstract Builder logDriver(Driver var1);

        @Deprecated
        public Builder withLogDriver(Driver logDriver) {
            this.logDriver(logDriver);
            return this;
        }

        public abstract TaskSpec build();
    }
}

