/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.async;

import com.alipay.sofa.boot.util.NamedThreadFactory;
import com.alipay.sofa.runtime.log.SofaLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.core.env.Environment;

public class AsyncTaskExecutor {
    protected static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    protected static final AtomicReference<ThreadPoolExecutor> THREAD_POOL_REF = new AtomicReference();
    protected static final List<Future> FUTURES = new ArrayList<Future>();
    protected static final AtomicBoolean STARTED = new AtomicBoolean(false);

    public static Future submitTask(Environment environment, Runnable runnable) {
        ThreadPoolExecutor threadPoolExecutor;
        boolean success;
        if (THREAD_POOL_REF.get() == null && !(success = THREAD_POOL_REF.compareAndSet(null, threadPoolExecutor = AsyncTaskExecutor.createThreadPoolExecutor(environment)))) {
            threadPoolExecutor.shutdown();
        }
        Future<?> future = THREAD_POOL_REF.get().submit(runnable);
        FUTURES.add(future);
        return future;
    }

    private static ThreadPoolExecutor createThreadPoolExecutor(Environment environment) {
        int threadPoolCoreSize = CPU_COUNT + 1;
        String coreSizeStr = environment.getProperty("com.alipay.sofa.boot.asyncInitBeanCoreSize");
        if (coreSizeStr != null) {
            threadPoolCoreSize = Integer.parseInt(coreSizeStr);
        }
        int threadPoolMaxSize = CPU_COUNT + 1;
        String maxSizeStr = environment.getProperty("com.alipay.sofa.boot.asyncInitBeanMaxSize");
        if (maxSizeStr != null) {
            threadPoolMaxSize = Integer.parseInt(maxSizeStr);
        }
        SofaLogger.info(String.format("create async-init-bean thread pool, corePoolSize: %d, maxPoolSize: %d.", threadPoolCoreSize, threadPoolMaxSize), new Object[0]);
        return new ThreadPoolExecutor(threadPoolCoreSize, threadPoolMaxSize, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("async-init-bean"), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static void ensureAsyncTasksFinish() {
        for (Future future : FUTURES) {
            try {
                future.get();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        STARTED.set(true);
        FUTURES.clear();
        if (THREAD_POOL_REF.get() != null) {
            THREAD_POOL_REF.get().shutdown();
            THREAD_POOL_REF.set(null);
        }
    }

    public static boolean isStarted() {
        return STARTED.get();
    }
}

