/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.component.impl;

import com.alipay.sofa.boot.health.RuntimeHealthChecker;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.component.impl.ComponentManagerImpl;
import com.alipay.sofa.runtime.spi.client.ClientFactoryInternal;
import com.alipay.sofa.runtime.spi.component.ComponentManager;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;
import com.alipay.sofa.runtime.spi.spring.RuntimeShutdownAware;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class StandardSofaRuntimeManager
implements SofaRuntimeManager,
ApplicationContextAware {
    private ComponentManager componentManager;
    private ClientFactoryInternal clientFactoryInternal;
    private SofaRuntimeContext sofaRuntimeContext;
    private ApplicationContext rootApplicationContext;
    private String appName;
    private ClassLoader appClassLoader;
    private List<RuntimeShutdownAware> runtimeShutdownAwares = new CopyOnWriteArrayList<RuntimeShutdownAware>();
    private List<RuntimeHealthChecker> runtimeHealthCheckers = new CopyOnWriteArrayList<RuntimeHealthChecker>();

    public StandardSofaRuntimeManager(String appName, ClassLoader appClassLoader, ClientFactoryInternal clientFactoryInternal) {
        this.componentManager = new ComponentManagerImpl(clientFactoryInternal);
        this.appName = appName;
        this.appClassLoader = appClassLoader;
        this.sofaRuntimeContext = new SofaRuntimeContext(this, this.componentManager, clientFactoryInternal);
        this.clientFactoryInternal = clientFactoryInternal;
    }

    @Override
    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Override
    public ClientFactoryInternal getClientFactoryInternal() {
        return this.clientFactoryInternal;
    }

    public boolean isReadinessHealth() {
        for (RuntimeHealthChecker runtimeHealthChecker : this.runtimeHealthCheckers) {
            if (runtimeHealthChecker.isReadinessHealth()) continue;
            return false;
        }
        return true;
    }

    public boolean isLivenessHealth() {
        for (RuntimeHealthChecker runtimeHealthChecker : this.runtimeHealthCheckers) {
            if (runtimeHealthChecker.isLivenessHealth()) continue;
            return false;
        }
        return true;
    }

    @Override
    public SofaRuntimeContext getSofaRuntimeContext() {
        return this.sofaRuntimeContext;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public ClassLoader getAppClassLoader() {
        return this.appClassLoader;
    }

    @Override
    public void shutdown() throws ServiceRuntimeException {
        try {
            for (RuntimeShutdownAware shutdownAware : this.runtimeShutdownAwares) {
                shutdownAware.shutdown();
            }
            if (this.componentManager != null) {
                this.componentManager.shutdown();
            }
            this.clear();
        }
        catch (Throwable throwable) {
            throw new ServiceRuntimeException(throwable);
        }
    }

    @Override
    public void registerShutdownAware(RuntimeShutdownAware callback) {
        this.runtimeShutdownAwares.add(callback);
    }

    @Override
    public void registerRuntimeHealthChecker(RuntimeHealthChecker runtimeHealthChecker) {
        this.runtimeHealthCheckers.add(runtimeHealthChecker);
    }

    @Override
    public ApplicationContext getRootApplicationContext() {
        return this.rootApplicationContext;
    }

    protected void clear() {
        this.componentManager = null;
        this.sofaRuntimeContext = null;
        this.clientFactoryInternal = null;
        this.appClassLoader = null;
        this.runtimeShutdownAwares.clear();
        this.runtimeHealthCheckers.clear();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.rootApplicationContext = applicationContext;
    }
}

