/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.component.impl;

import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.component.ComponentName;
import com.alipay.sofa.runtime.log.SofaLogger;
import com.alipay.sofa.runtime.model.ComponentStatus;
import com.alipay.sofa.runtime.model.ComponentType;
import com.alipay.sofa.runtime.spi.client.ClientFactoryInternal;
import com.alipay.sofa.runtime.spi.component.ComponentInfo;
import com.alipay.sofa.runtime.spi.component.ComponentManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ComponentManagerImpl
implements ComponentManager {
    protected ConcurrentMap<ComponentName, ComponentInfo> registry = new ConcurrentHashMap<ComponentName, ComponentInfo>(16);
    protected ConcurrentMap<ComponentType, Map<ComponentName, ComponentInfo>> resolvedRegistry = new ConcurrentHashMap<ComponentType, Map<ComponentName, ComponentInfo>>(16);
    private ClientFactoryInternal clientFactoryInternal;

    public ComponentManagerImpl(ClientFactoryInternal clientFactoryInternal) {
        this.clientFactoryInternal = clientFactoryInternal;
    }

    public Collection<ComponentInfo> getComponentInfos() {
        return new ArrayList<ComponentInfo>(this.registry.values());
    }

    public Collection<ComponentName> getPendingComponentInfos() {
        ArrayList<ComponentName> names = new ArrayList<ComponentName>();
        for (ComponentInfo ri : this.registry.values()) {
            if (ri.getState() != ComponentStatus.REGISTERED) continue;
            names.add(ri.getName());
        }
        return names;
    }

    @Override
    public ComponentInfo getComponentInfo(ComponentName name) {
        return (ComponentInfo)this.registry.get(name);
    }

    @Override
    public boolean isRegistered(ComponentName name) {
        return this.registry.containsKey(name);
    }

    @Override
    public Collection<ComponentInfo> getComponents() {
        return this.registry.values();
    }

    @Override
    public int size() {
        return this.registry.size();
    }

    @Override
    public void shutdown() {
        ArrayList elems = new ArrayList(this.registry.values());
        for (ComponentInfo ri : elems) {
            try {
                this.unregister(ri);
            }
            catch (Throwable e) {
                SofaLogger.error(e, "failed to shutdown component manager", new Object[0]);
            }
        }
        try {
            this.registry.clear();
            this.registry = null;
            this.resolvedRegistry.clear();
            this.resolvedRegistry = null;
            this.clientFactoryInternal = null;
        }
        catch (Throwable e) {
            SofaLogger.error(e, "Failed to shutdown registry manager", new Object[0]);
        }
    }

    @Override
    public Collection<ComponentType> getComponentTypes() {
        return this.resolvedRegistry.keySet();
    }

    @Override
    public void register(ComponentInfo componentInfo) {
        this.doRegister(componentInfo);
    }

    @Override
    public ComponentInfo registerAndGet(ComponentInfo componentInfo) {
        return this.doRegister(componentInfo);
    }

    @Override
    public void registerComponentClient(Class<?> clientType, Object client) {
        this.clientFactoryInternal.registerClient(clientType, client);
    }

    private ComponentInfo doRegister(ComponentInfo ci) {
        ComponentName name = ci.getName();
        if (this.isRegistered(name)) {
            SofaLogger.error("Component was already registered: {0}", name);
            if (ci.canBeDuplicate()) {
                return this.getComponentInfo(name);
            }
            throw new ServiceRuntimeException("Component can not be registered duplicated: " + name);
        }
        try {
            ci.register();
        }
        catch (Throwable e) {
            SofaLogger.error(e, "Failed to register component: {0}", ci.getName());
            return null;
        }
        SofaLogger.info("Registering component: {0}", ci.getName());
        try {
            ComponentInfo old = this.registry.putIfAbsent(ci.getName(), ci);
            if (old != null) {
                SofaLogger.error("Component was already registered: {0}", name);
                if (ci.canBeDuplicate()) {
                    return old;
                }
                throw new ServiceRuntimeException("Component can not be registered duplicated: " + name);
            }
            if (ci.resolve()) {
                this.typeRegistry(ci);
                ci.activate();
            }
        }
        catch (Throwable e) {
            ci.exception(new Exception(e));
            SofaLogger.error(e, "Failed to create the component {0}", ci.getName());
        }
        return ci;
    }

    @Override
    public void unregister(ComponentInfo componentInfo) throws ServiceRuntimeException {
        ComponentName componentName = componentInfo.getName();
        this.registry.remove(componentName);
        if (componentName != null) {
            ComponentType componentType = componentName.getType();
            Map typesRi = (Map)this.resolvedRegistry.get(componentType);
            typesRi.remove(componentName);
        }
        componentInfo.unregister();
    }

    @Override
    public Collection<ComponentInfo> getComponentInfosByType(ComponentType type) {
        ArrayList<ComponentInfo> componentInfos = new ArrayList<ComponentInfo>();
        for (ComponentInfo componentInfo : this.registry.values()) {
            if (!type.equals(componentInfo.getType())) continue;
            componentInfos.add(componentInfo);
        }
        return componentInfos;
    }

    @Override
    public void resolvePendingResolveComponent(ComponentName componentName) {
        ComponentInfo componentInfo = (ComponentInfo)this.registry.get(componentName);
        if (componentInfo.isResolved()) {
            return;
        }
        if (componentInfo.resolve()) {
            this.typeRegistry(componentInfo);
            try {
                componentInfo.activate();
            }
            catch (Throwable e) {
                componentInfo.exception(new Exception(e));
                SofaLogger.error(e, "Failed to create the component " + componentInfo.getName(), new Object[0]);
            }
        }
    }

    private void typeRegistry(ComponentInfo componentInfo) {
        ComponentName name = componentInfo.getName();
        if (name != null) {
            ComponentType type = name.getType();
            Map typesRi = (Map)this.resolvedRegistry.get(type);
            if (typesRi == null) {
                this.resolvedRegistry.putIfAbsent(type, new HashMap());
                typesRi = (Map)this.resolvedRegistry.get(type);
            }
            typesRi.put(name, componentInfo);
        }
    }
}

