/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.cfg;

import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Stream;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.util.Snapshottable;
import tools.jackson.databind.AbstractTypeResolver;
import tools.jackson.databind.InjectableValues;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.cfg.BaseSettings;
import tools.jackson.databind.cfg.CoercionConfigs;
import tools.jackson.databind.cfg.ConfigOverrides;
import tools.jackson.databind.cfg.ContextAttributes;
import tools.jackson.databind.cfg.DatatypeFeatures;
import tools.jackson.databind.cfg.DeserializationContexts;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.cfg.SerializationContexts;
import tools.jackson.databind.deser.DeserializationProblemHandler;
import tools.jackson.databind.deser.DeserializerFactory;
import tools.jackson.databind.introspect.ClassIntrospector;
import tools.jackson.databind.introspect.MixInHandler;
import tools.jackson.databind.jsontype.SubtypeResolver;
import tools.jackson.databind.jsontype.TypeResolverProvider;
import tools.jackson.databind.ser.FilterProvider;
import tools.jackson.databind.ser.SerializerFactory;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.util.LinkedNode;

public abstract class MapperBuilderState
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected final BaseSettings _baseSettings;
    protected final TokenStreamFactory _streamFactory;
    protected final ConfigOverrides _configOverrides;
    protected final CoercionConfigs _coercionConfigs;
    protected final long _mapperFeatures;
    protected final int _serFeatures;
    protected final int _deserFeatures;
    protected final int _streamReadFeatures;
    protected final int _streamWriteFeatures;
    protected final int _formatReadFeatures;
    protected final int _formatWriteFeatures;
    protected final DatatypeFeatures _datatypeFeatures;
    protected final JacksonModule[] _modules;
    protected final TypeFactory _typeFactory;
    protected final ClassIntrospector _classIntrospector;
    protected final TypeResolverProvider _typeResolverProvider;
    protected final SubtypeResolver _subtypeResolver;
    protected final MixInHandler _mixInHandler;
    protected final SerializationContexts _serializationContexts;
    protected final SerializerFactory _serializerFactory;
    protected final FilterProvider _filterProvider;
    protected final PrettyPrinter _defaultPrettyPrinter;
    protected final DeserializationContexts _deserializationContexts;
    protected final DeserializerFactory _deserializerFactory;
    protected final InjectableValues _injectableValues;
    protected final LinkedNode<DeserializationProblemHandler> _problemHandlers;
    protected final AbstractTypeResolver[] _abstractTypeResolvers;
    protected final ContextAttributes _defaultAttributes;

    public MapperBuilderState(MapperBuilder<?, ?> src) {
        this._baseSettings = src._baseSettings;
        this._streamFactory = src._streamFactory;
        this._configOverrides = (ConfigOverrides)Snapshottable.takeSnapshot((Snapshottable)src._configOverrides);
        this._coercionConfigs = (CoercionConfigs)Snapshottable.takeSnapshot((Snapshottable)src._coercionConfigs);
        this._mapperFeatures = src._mapperFeatures;
        this._serFeatures = src._serFeatures;
        this._deserFeatures = src._deserFeatures;
        this._datatypeFeatures = src._datatypeFeatures;
        this._streamReadFeatures = src._streamReadFeatures;
        this._streamWriteFeatures = src._streamWriteFeatures;
        this._formatReadFeatures = src._formatReadFeatures;
        this._formatWriteFeatures = src._formatWriteFeatures;
        this._typeFactory = (TypeFactory)Snapshottable.takeSnapshot((Snapshottable)src._typeFactory);
        this._classIntrospector = src._classIntrospector;
        this._typeResolverProvider = src._typeResolverProvider;
        this._subtypeResolver = (SubtypeResolver)Snapshottable.takeSnapshot((Snapshottable)src._subtypeResolver);
        this._mixInHandler = (MixInHandler)Snapshottable.takeSnapshot((Snapshottable)src._mixInHandler);
        this._serializerFactory = src._serializerFactory;
        this._serializationContexts = src._serializationContexts;
        this._filterProvider = (FilterProvider)Snapshottable.takeSnapshot((Snapshottable)src._filterProvider);
        this._defaultPrettyPrinter = src._defaultPrettyPrinter;
        this._deserializerFactory = src._deserializerFactory;
        this._deserializationContexts = src._deserializationContexts;
        this._injectableValues = (InjectableValues)Snapshottable.takeSnapshot((Snapshottable)src._injectableValues);
        this._problemHandlers = src._problemHandlers;
        this._abstractTypeResolvers = src._abstractTypeResolvers;
        this._defaultAttributes = (ContextAttributes)Snapshottable.takeSnapshot((Snapshottable)src._defaultAttributes);
        this._modules = src._modules == null ? null : MapperBuilderState._toArray(src._modules.values());
    }

    private static JacksonModule[] _toArray(Collection<?> coll) {
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        return coll.toArray(new JacksonModule[0]);
    }

    public Stream<JacksonModule> modules() {
        if (this._modules == null) {
            return Stream.empty();
        }
        return Stream.of(this._modules);
    }

    protected abstract Object readResolve();
}

