/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.tools.IntReference;

public class InternalInputStream
extends SeekableInputStream {
    private static final String READ_ONLY_MODE = "r";
    private static int DEFAULT_BUFFER_SIZE = 2048;
    private RandomAccessFile stream;
    private byte[] buffer;
    private long bufferFrom;
    private long bufferTo;
    private long offset;
    private boolean isTempFile;
    private IntReference numOfFileUsers;
    private String filePath;
    private long fromOffset;
    private long size;

    public InternalInputStream(File file) throws IOException {
        this(file, false);
    }

    public InternalInputStream(File file, boolean isTempFile) throws IOException {
        this(file, 0, isTempFile);
    }

    public InternalInputStream(File file, int numOfFileUsers, boolean isTempFile) throws IOException {
        this(new RandomAccessFile(file, READ_ONLY_MODE), 0L, Long.MAX_VALUE, new IntReference(numOfFileUsers), file.getAbsolutePath(), isTempFile);
    }

    public InternalInputStream(String fileName) throws IOException {
        this(fileName, 0);
    }

    public InternalInputStream(String fileName, int numOfFileUsers) throws IOException {
        this(new RandomAccessFile(fileName, READ_ONLY_MODE), 0L, Long.MAX_VALUE, new IntReference(numOfFileUsers), fileName, false);
    }

    public InternalInputStream(RandomAccessFile stream, long fromOffset, long size, IntReference numOfFileUsers, String filePath, boolean isTempFile) throws IOException {
        this(stream, fromOffset, size, numOfFileUsers, filePath, isTempFile, DEFAULT_BUFFER_SIZE);
    }

    public InternalInputStream(RandomAccessFile stream, long fromOffset, long size, IntReference numOfFileUsers, String filePath, boolean isTempFile, int bufferSize) throws IOException {
        this.stream = stream;
        this.buffer = new byte[bufferSize];
        this.bufferFrom = 0L;
        this.bufferTo = 0L;
        this.offset = 0L;
        this.isTempFile = isTempFile;
        this.numOfFileUsers = numOfFileUsers;
        this.numOfFileUsers.increment();
        this.filePath = filePath;
        this.fromOffset = fromOffset;
        long streamLeft = stream.length() - fromOffset;
        if (streamLeft < 0L) {
            throw new IOException("Offset is greater than full stream size");
        }
        this.size = size < 0L ? streamLeft : Math.min(size, streamLeft);
    }

    public static InternalInputStream createConcatenated(byte[] alreadyRead, InputStream stream) throws IOException {
        File temp = InternalInputStream.createTempFile(alreadyRead, stream);
        return new InternalInputStream(temp, true);
    }

    @Override
    public int read() throws IOException {
        this.checkClosed("Reading");
        if (this.isStreamEnd()) {
            return -1;
        }
        byte res = this.buffer[(int)(this.offset - this.bufferFrom)];
        ++this.offset;
        return res & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int size) throws IOException {
        int read;
        this.checkClosed("Reading");
        if (buffer.length < size) {
            throw new IllegalArgumentException("Destination buffer size is less than size to be read");
        }
        int curPos = 0;
        for (int left = size; left > 0 && (read = this.append(buffer, curPos, left)) != -1; left -= read) {
            curPos += read;
        }
        return curPos == 0 ? -1 : curPos;
    }

    private int append(byte[] buffer, int from, int size) throws IOException {
        if (this.isStreamEnd()) {
            return -1;
        }
        int toBeRead = Math.min(size, (int)(this.bufferTo - this.offset));
        System.arraycopy(this.buffer, (int)(this.offset - this.bufferFrom), buffer, from, toBeRead);
        this.offset += (long)toBeRead;
        return toBeRead;
    }

    @Override
    public int skip(int size) throws IOException {
        this.checkClosed("Skipping");
        long newOffset = Math.min(this.offset + (long)size, this.getStreamLength());
        int skipped = (int)(newOffset - this.offset);
        this.seek(newOffset);
        return skipped;
    }

    @Override
    public void reset() throws IOException {
        this.checkClosed("Reset");
        this.seek(0L);
    }

    @Override
    public void seek(long offset) throws IOException {
        this.checkClosed("Seeking");
        if (offset > this.getStreamLength()) {
            throw new IllegalArgumentException("Destination offset is greater than stream length");
        }
        this.offset = offset < 0L ? 0L : offset;
    }

    @Override
    public int peek() throws IOException {
        this.checkClosed("Peeking");
        int res = this.read();
        if (res != -1) {
            this.unread();
        }
        return res;
    }

    @Override
    public long getOffset() throws IOException {
        this.checkClosed("Offset obtaining");
        return this.offset;
    }

    @Override
    public ASInputStream getStream(long startOffset, long length) throws IOException {
        return new InternalInputStream(this.stream, startOffset, length, this.numOfFileUsers, this.filePath, this.isTempFile);
    }

    @Override
    public void closeResource() throws IOException {
        if (!this.isSourceClosed) {
            this.isSourceClosed = true;
            this.numOfFileUsers.decrement();
            if (this.numOfFileUsers.equals(0)) {
                File tmp;
                this.stream.close();
                if (this.isTempFile && !(tmp = new File(this.filePath)).delete()) {
                    tmp.deleteOnExit();
                }
            }
        }
    }

    private boolean isStreamEnd() throws IOException {
        if (this.offset >= this.bufferFrom && this.offset < this.bufferTo) {
            return false;
        }
        int read = this.feedBuffer();
        this.bufferFrom = this.offset;
        this.bufferTo = read == -1 ? this.offset : this.offset + (long)read;
        return read <= 0;
    }

    private void checkClosed(String streamUsage) throws IOException {
        if (this.isSourceClosed) {
            throw new IOException(streamUsage + " can't be performed; stream is closed");
        }
    }

    private int feedBuffer() throws IOException {
        long left = this.getStreamLength() - this.offset;
        if (left <= 0L) {
            return -1;
        }
        long realOffset = this.fromOffset + this.offset;
        if (this.stream.getFilePointer() != realOffset) {
            this.stream.seek(realOffset);
        }
        int read = this.stream.read(this.buffer);
        return (int)Math.min((long)read, left);
    }

    @Override
    public long getStreamLength() throws IOException {
        this.checkClosed("Stream length obtaining");
        return this.size;
    }

    private static File createTempFile(byte[] alreadyRead, InputStream input) throws IOException {
        File file;
        File tmpFile = File.createTempFile("tmp_pdf_file", ".pdf");
        FileOutputStream output = new FileOutputStream(tmpFile);
        try {
            int n;
            output.write(alreadyRead);
            byte[] buffer = new byte[2048];
            while ((n = input.read(buffer, 0, 2048)) != -1) {
                output.write(buffer, 0, n);
            }
            file = tmpFile;
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                if (!tmpFile.delete()) {
                    tmpFile.deleteOnExit();
                }
                throw e;
            }
        }
        output.close();
        return file;
    }
}

