/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.jardiff;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.objectweb.asm.Type;
import org.osjava.jardiff.AbstractInfo;
import org.osjava.jardiff.ClassInfo;
import org.osjava.jardiff.DiffException;
import org.osjava.jardiff.DiffHandler;
import org.osjava.jardiff.FieldInfo;
import org.osjava.jardiff.MethodInfo;

public class StreamDiffHandler
implements DiffHandler {
    public static final String XML_URI = "http://www.osjava.org/jardiff/0.1";
    private final BufferedWriter out;

    public StreamDiffHandler() throws DiffException {
        try {
            this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    public StreamDiffHandler(OutputStream out) throws DiffException {
        try {
            this.out = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void startDiff(String oldJar, String newJar) throws DiffException {
        try {
            this.out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.out.write("<diff xmlns=\"");
            this.out.write(this.xmlEscape(XML_URI));
            this.out.write("\" old=\"");
            this.out.write(this.xmlEscape(oldJar));
            this.out.write("\" new=\"");
            this.out.write(this.xmlEscape(newJar));
            this.out.write("\">");
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void startOldContents() throws DiffException {
        try {
            this.out.write("<oldcontents>");
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void startNewContents() throws DiffException {
        try {
            this.out.write("<newcontents>");
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void contains(ClassInfo info) throws DiffException {
        try {
            this.out.write("<class name=\"");
            this.out.write(this.xmlEscape(info.getName()));
            this.out.write("\"/>");
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void endOldContents() throws DiffException {
        try {
            this.out.write("</oldcontents>");
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void endNewContents() throws DiffException {
        try {
            this.out.write("</newcontents>");
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void startRemoved() throws DiffException {
        try {
            this.out.write("<removed>");
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void classRemoved(ClassInfo info) throws DiffException {
        try {
            this.writeClassInfo(info);
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void endRemoved() throws DiffException {
        try {
            this.out.write("</removed>");
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void startAdded() throws DiffException {
        try {
            this.out.write("<added>");
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void classAdded(ClassInfo info) throws DiffException {
        try {
            this.writeClassInfo(info);
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void endAdded() throws DiffException {
        try {
            this.out.write("</added>");
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void startChanged() throws DiffException {
        try {
            this.out.write("<changed>");
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void startClassChanged(String internalName) throws DiffException {
        try {
            this.out.write("<classchanged name=\"");
            this.out.write(this.xmlEscape(internalName));
            this.out.write("\">");
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void fieldRemoved(FieldInfo info) throws DiffException {
        try {
            this.writeFieldInfo(info);
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void methodRemoved(MethodInfo info) throws DiffException {
        try {
            this.writeMethodInfo(info);
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void fieldAdded(FieldInfo info) throws DiffException {
        try {
            this.writeFieldInfo(info);
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void methodAdded(MethodInfo info) throws DiffException {
        try {
            this.writeMethodInfo(info);
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void classChanged(ClassInfo oldInfo, ClassInfo newInfo) throws DiffException {
        try {
            this.out.write("<classchange><from>");
            this.writeClassInfo(oldInfo);
            this.out.write("</from><to>");
            this.writeClassInfo(newInfo);
            this.out.write("</to></classchange>");
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void classDeprecated(ClassInfo oldInfo, ClassInfo newInfo) throws DiffException {
        this.classChanged(oldInfo, newInfo);
    }

    @Override
    public void fieldChanged(FieldInfo oldInfo, FieldInfo newInfo) throws DiffException {
        try {
            this.out.write("<fieldchange><from>");
            this.writeFieldInfo(oldInfo);
            this.out.write("</from><to>");
            this.writeFieldInfo(newInfo);
            this.out.write("</to></fieldchange>");
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void fieldDeprecated(FieldInfo oldInfo, FieldInfo newInfo) throws DiffException {
        this.fieldChanged(oldInfo, newInfo);
    }

    @Override
    public void methodChanged(MethodInfo oldInfo, MethodInfo newInfo) throws DiffException {
        try {
            this.out.write("<methodchange><from>");
            this.writeMethodInfo(oldInfo);
            this.out.write("</from><to>");
            this.writeMethodInfo(newInfo);
            this.out.write("</to></methodchange>");
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void methodDeprecated(MethodInfo oldInfo, MethodInfo newInfo) throws DiffException {
        this.methodChanged(oldInfo, newInfo);
    }

    @Override
    public void endClassChanged() throws DiffException {
        try {
            this.out.write("</classchanged>");
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void endChanged() throws DiffException {
        try {
            this.out.write("</changed>");
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    @Override
    public void endDiff() throws DiffException {
        try {
            this.out.write("</diff>");
            this.out.newLine();
            this.out.close();
        }
        catch (IOException ioe) {
            throw new DiffException(ioe);
        }
    }

    protected void writeClassInfo(ClassInfo info) throws IOException {
        this.out.write("<class");
        this.addAccessFlags(info);
        if (info.getName() != null) {
            this.out.write(" name=\"");
            this.out.write(this.xmlEscape(info.getName()));
            this.out.write("\"");
        }
        if (info.getSignature() != null) {
            this.out.write(" signature=\"");
            this.out.write(this.xmlEscape(info.getSignature()));
            this.out.write("\"");
        }
        if (info.getSupername() != null) {
            this.out.write(" superclass=\"");
            this.out.write(this.xmlEscape(info.getSupername()));
            this.out.write("\">");
        }
        String[] interfaces = info.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.out.write("<implements name=\"");
            this.out.write(this.xmlEscape(interfaces[i]));
            this.out.write("\"/>");
        }
        this.out.write("</class>");
    }

    protected void writeMethodInfo(MethodInfo info) throws IOException {
        String[] exceptions;
        this.out.write("<method");
        this.addAccessFlags(info);
        if (info.getName() != null) {
            this.out.write(" name=\"");
            this.out.write(this.xmlEscape(info.getName()));
            this.out.write("\"");
        }
        if (info.getSignature() != null) {
            this.out.write(" signature=\"");
            this.out.write(this.xmlEscape(info.getSignature()));
            this.out.write("\"");
        }
        this.out.write(">");
        if (info.getDesc() != null) {
            this.addMethodNodes(info.getDesc());
        }
        if ((exceptions = info.getExceptions()) != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                this.out.write("<exception name=\"");
                this.out.write(this.xmlEscape(exceptions[i]));
                this.out.write("\"/>");
            }
        }
        this.out.write("</method>");
    }

    protected void writeFieldInfo(FieldInfo info) throws IOException {
        this.out.write("<field");
        this.addAccessFlags(info);
        if (info.getName() != null) {
            this.out.write(" name=\"");
            this.out.write(this.xmlEscape(info.getName()));
            this.out.write("\"");
        }
        if (info.getSignature() != null) {
            this.out.write(" signature=\"");
            this.out.write(this.xmlEscape(info.getSignature()));
            this.out.write("\"");
        }
        if (info.getValue() != null) {
            this.out.write(" value=\"");
            this.out.write(this.xmlEscape(info.getValue().toString()));
            this.out.write("\"");
        }
        this.out.write(">");
        if (info.getDesc() != null) {
            this.addTypeNode(info.getDesc());
        }
        this.out.write("</field>");
    }

    protected void addAccessFlags(AbstractInfo info) throws IOException {
        this.out.write(" access=\"");
        this.out.write(info.getAccessType());
        this.out.write("\"");
        if (info.isAbstract()) {
            this.out.write(" abstract=\"yes\"");
        }
        if (info.isAnnotation()) {
            this.out.write(" annotation=\"yes\"");
        }
        if (info.isBridge()) {
            this.out.write(" bridge=\"yes\"");
        }
        if (info.isDeprecated()) {
            this.out.write(" deprecated=\"yes\"");
        }
        if (info.isEnum()) {
            this.out.write(" enum=\"yes\"");
        }
        if (info.isFinal()) {
            this.out.write(" final=\"yes\"");
        }
        if (info.isInterface()) {
            this.out.write(" interface=\"yes\"");
        }
        if (info.isNative()) {
            this.out.write(" native=\"yes\"");
        }
        if (info.isStatic()) {
            this.out.write(" static=\"yes\"");
        }
        if (info.isStrict()) {
            this.out.write(" strict=\"yes\"");
        }
        if (info.isSuper()) {
            this.out.write(" super=\"yes\"");
        }
        if (info.isSynchronized()) {
            this.out.write(" synchronized=\"yes\"");
        }
        if (info.isSynthetic()) {
            this.out.write(" synthetic=\"yes\"");
        }
        if (info.isTransient()) {
            this.out.write(" transient=\"yes\"");
        }
        if (info.isVarargs()) {
            this.out.write(" varargs=\"yes\"");
        }
        if (info.isVolatile()) {
            this.out.write(" volatile=\"yes\"");
        }
    }

    protected void addMethodNodes(String desc) throws IOException {
        Type[] args = Type.getArgumentTypes((String)desc);
        Type ret = Type.getReturnType((String)desc);
        this.out.write("<arguments>");
        for (int i = 0; i < args.length; ++i) {
            this.addTypeNode(args[i]);
        }
        this.out.write("</arguments>");
        this.out.write("<return>");
        this.addTypeNode(ret);
        this.out.write("</return>");
    }

    protected void addTypeNode(String desc) throws IOException {
        this.addTypeNode(Type.getType((String)desc));
    }

    protected void addTypeNode(Type type) throws IOException {
        this.out.write("<type");
        int i = type.getSort();
        if (i == 9) {
            this.out.write(" array=\"yes\" dimensions=\"");
            this.out.write("" + type.getDimensions());
            this.out.write("\"");
            type = type.getElementType();
            i = type.getSort();
        }
        switch (i) {
            case 1: {
                this.out.write(" primitive=\"yes\" name=\"boolean\"/>");
                break;
            }
            case 3: {
                this.out.write(" primitive=\"yes\" name=\"byte\"/>");
                break;
            }
            case 2: {
                this.out.write(" primitive=\"yes\" name=\"char\"/>");
                break;
            }
            case 8: {
                this.out.write(" primitive=\"yes\" name=\"double\"/>");
                break;
            }
            case 6: {
                this.out.write(" primitive=\"yes\" name=\"float\"/>");
                break;
            }
            case 5: {
                this.out.write(" primitive=\"yes\" name=\"int\"/>");
                break;
            }
            case 7: {
                this.out.write(" primitive=\"yes\" name=\"long\"/>");
                break;
            }
            case 10: {
                this.out.write(" name=\"");
                this.out.write(this.xmlEscape(type.getInternalName()));
                this.out.write("\"/>");
                break;
            }
            case 4: {
                this.out.write(" primitive=\"yes\" name=\"short\"/>");
                break;
            }
            case 0: {
                this.out.write(" primitive=\"yes\" name=\"void\"/>");
            }
        }
    }

    private final String xmlEscape(String str) {
        StringBuffer ret = new StringBuffer(str.length());
        block5: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    ret.append("&lt;");
                    continue block5;
                }
                case '&': {
                    ret.append("&amp;");
                    continue block5;
                }
                case '>': {
                    ret.append("&gt;");
                    continue block5;
                }
                default: {
                    ret.append(ch);
                }
            }
        }
        return ret.toString();
    }
}

