/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pitest.functional.SideEffect1;
import org.pitest.util.ExitCode;
import org.pitest.util.Log;
import org.pitest.util.ReceiveStrategy;
import org.pitest.util.SafeDataOutputStream;
import org.pitest.util.SocketReadingCallable;

public class CommunicationThread {
    private static final Logger LOG = Log.getLogger();
    private final SideEffect1<SafeDataOutputStream> sendInitialData;
    private final ReceiveStrategy receive;
    private final ServerSocket socket;
    private FutureTask<ExitCode> future;

    public CommunicationThread(ServerSocket socket, SideEffect1<SafeDataOutputStream> sendInitialData, ReceiveStrategy receive) {
        this.socket = socket;
        this.sendInitialData = sendInitialData;
        this.receive = receive;
    }

    public void start() throws IOException, InterruptedException {
        this.future = this.createFuture();
    }

    private FutureTask<ExitCode> createFuture() {
        FutureTask<ExitCode> newFuture = new FutureTask<ExitCode>(new SocketReadingCallable(this.socket, this.sendInitialData, this.receive));
        Thread thread = new Thread(newFuture);
        thread.setDaemon(true);
        thread.setName("pit communication");
        thread.start();
        return newFuture;
    }

    public ExitCode waitToFinish() {
        try {
            return this.future.get();
        }
        catch (ExecutionException e) {
            LOG.log(Level.WARNING, "Error while watching child process", e);
            return ExitCode.UNKNOWN_ERROR;
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, "interrupted while waiting for child process", e);
            return ExitCode.UNKNOWN_ERROR;
        }
    }
}

