/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.connection;

import java.io.IOException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.request.RootRequest;
import org.netbeans.lib.cvsclient.request.UnconfiguredRequestException;
import org.netbeans.lib.cvsclient.request.UseUnchangedRequest;
import org.netbeans.lib.cvsclient.request.ValidRequestsRequest;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public abstract class AbstractConnection
implements Connection {
    private String repository = null;
    private LoggedDataInputStream inputStream;
    private LoggedDataOutputStream outputStream;

    public LoggedDataInputStream getInputStream() {
        return this.inputStream;
    }

    protected final void setInputStream(LoggedDataInputStream loggedDataInputStream) {
        if (this.inputStream == loggedDataInputStream) {
            return;
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.inputStream = loggedDataInputStream;
    }

    public LoggedDataOutputStream getOutputStream() {
        return this.outputStream;
    }

    protected final void setOutputStream(LoggedDataOutputStream loggedDataOutputStream) {
        if (this.outputStream == loggedDataOutputStream) {
            return;
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.outputStream = loggedDataOutputStream;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String string) {
        this.repository = string;
    }

    protected void verifyProtocol() throws IOException {
        String string;
        int n;
        try {
            this.outputStream.writeBytes(new RootRequest(this.repository).getRequestString(), "US-ASCII");
            this.outputStream.writeBytes(new UseUnchangedRequest().getRequestString(), "US-ASCII");
            this.outputStream.writeBytes(new ValidRequestsRequest().getRequestString(), "US-ASCII");
            this.outputStream.writeBytes("noop \n", "US-ASCII");
        }
        catch (UnconfiguredRequestException unconfiguredRequestException) {
            throw new RuntimeException("Internal error verifying CVS protocol: " + unconfiguredRequestException.getMessage());
        }
        this.outputStream.flush();
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.inputStream.read()) != -1) {
            stringBuffer.append((char)n);
            if (n != 10) continue;
        }
        if (!(string = stringBuffer.toString()).startsWith("Valid-requests")) {
            throw new IOException("Unexpected server response: " + string);
        }
    }
}

